/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.workspace;

import com.dbeaver.remote.client.tm.model.TMTaskExecutionService;
import com.dbeaver.remote.client.tm.model.TMTaskSchedule;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.model.task.DBTScheduler;
import org.jkiss.dbeaver.model.task.DBTSchedulerExternalSettings;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.model.task.DBTTaskHandler;
import org.jkiss.dbeaver.model.task.DBTTaskInfoCollector;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleConfiguration;
import org.jkiss.dbeaver.model.task.DBTTaskScheduleInfo;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class RemoteTaskScheduler
implements DBTScheduler {
    private static final Log log = Log.getLog(RemoteTaskScheduler.class);
    private final TMTaskExecutionService executionService;
    private List<TMTaskSchedule> schedules;

    public RemoteTaskScheduler() throws DBException {
        DesktopWorkspaceRemote workspace = (DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace();
        this.executionService = workspace.getTaskExecutionService();
    }

    @NotNull
    public String getSchedulerName() {
        return "Remote Scheduler";
    }

    public boolean supportsFeature(String feature) {
        switch (feature) {
            case "frequency.daily": 
            case "frequency.monthly.startDate": 
            case "frequency.minutely.startDatetime": 
            case "frequency.onetime": 
            case "frequency.weekly.startDate": 
            case "frequency.minutely": 
            case "frequency.hourly": 
            case "frequency.daily.startDate": 
            case "frequency.monthly": 
            case "frequency.weekly": 
            case "frequency.onetime.startDatetime": 
            case "frequency.hourly.startDatetime": {
                return true;
            }
        }
        return false;
    }

    public DBTScheduler.RecurrenceType getRecurrenceType() {
        return DBTScheduler.RecurrenceType.Interval;
    }

    @NotNull
    public List<DBTTaskScheduleInfo> getAllScheduledTasks() throws DBException {
        try {
            List allTaskSchedules = this.executionService.getAllTaskSchedules(null);
            return allTaskSchedules.stream().map(TMTaskSchedule::getInformation).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new DBException("Error retrieving scheduled tasks", (Throwable)e);
        }
    }

    @Nullable
    public DBTTaskScheduleInfo getScheduledTaskInfo(@NotNull DBTTask task) {
        try {
            TMTaskSchedule schedule = this.getTaskSchedule(task);
            return schedule != null ? schedule.getInformation() : null;
        }
        catch (DBException e) {
            log.error((Object)("Error retrieving schedule information for task " + String.valueOf(task)), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public DBTTaskScheduleConfiguration getScheduledTaskConfiguration(@NotNull DBTTask task) throws DBException {
        TMTaskSchedule schedule = this.getTaskSchedule(task);
        return schedule != null ? schedule.getConfiguration() : null;
    }

    public boolean canSchedule(@NotNull DBTTask task, List<String> warnings) throws DBException {
        DBTTaskHandler taskHandler = task.getType().createHandler();
        if (taskHandler instanceof DBTTaskInfoCollector) {
            DBTTaskInfoCollector tic = (DBTTaskInfoCollector)taskHandler;
            this.validateTaskForSchedulingPossibility(task, tic, warnings);
        }
        return this.getExecutionService().getSupportedTasks().contains(task.getType().getId());
    }

    private TMTaskExecutionService getExecutionService() throws DBException {
        if (this.executionService == null) {
            throw new DBException("No scheduler execution service is available");
        }
        return this.executionService;
    }

    private void validateTaskForSchedulingPossibility(@NotNull DBTTask task, @NotNull DBTTaskInfoCollector infoCollector, List<String> warnings) throws DBException {
        DBTTaskInfoCollector.TaskInformation info = new DBTTaskInfoCollector.TaskInformation();
        infoCollector.collectTaskInfo(task, info);
        if (!info.getDataSources().isEmpty()) {
            DBSSecretController secretController = DBSSecretController.getProjectSecretController((DBPProject)task.getProject());
            ArrayList<DBPDataSourceContainer> naDataSources = new ArrayList<DBPDataSourceContainer>();
            for (DBPDataSourceContainer ds2 : info.getDataSources()) {
                ds2.resolveSecrets(secretController);
                ds2.getOrigin();
                if (ds2.isSharedCredentials() || CommonUtils.isEmpty((String)ds2.getConnectionConfiguration().getUserName())) continue;
                naDataSources.add(ds2);
            }
            if (!naDataSources.isEmpty()) {
                warnings.add("Task depends on the database connection(s) which use non-shared credentials configuration.\nIn order to schedule the task you must enable shared credentials mode or use SSO:\n - " + naDataSources.stream().map(ds -> "\"" + ds.getName() + "\"").collect(Collectors.joining("\n - ")));
            }
        }
    }

    public boolean setTaskSchedule(@NotNull DBTTask task, @NotNull DBTTaskScheduleConfiguration scheduleConfiguration) throws DBException {
        this.getExecutionService().scheduleTask(task.getProject().getId(), task.getId(), scheduleConfiguration);
        this.schedules = null;
        return true;
    }

    public void removeTaskSchedule(@NotNull DBTTask task, DBTTaskScheduleInfo scheduleInfo) throws DBException {
        this.getExecutionService().removeTaskSchedule(task.getProject().getId(), task.getId());
        this.schedules = null;
    }

    public void refreshScheduledTasks(@NotNull DBRProgressMonitor monitor) {
        this.schedules = null;
    }

    @Nullable
    public DBTSchedulerExternalSettings openSchedulerSettings() {
        return null;
    }

    @Nullable
    private TMTaskSchedule getTaskSchedule(@NotNull DBTTask task) throws DBException {
        if (this.schedules == null) {
            this.schedules = new ArrayList<TMTaskSchedule>(this.getExecutionService().getAllTaskSchedules(null));
        }
        for (TMTaskSchedule info : this.schedules) {
            if (!info.getTaskId().equals(task.getId())) continue;
            return info;
        }
        return null;
    }
}

