/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.workspace;

import com.dbeaver.model.ai.RAGEmbeddingStorage;
import com.dbeaver.model.ai.RAGStorageProvider;
import com.dbeaver.model.auth.SMClientUtils;
import com.dbeaver.model.auth.SMServerAPI;
import com.dbeaver.model.auth.SMSessionRemote;
import com.dbeaver.model.qm.QMService;
import com.dbeaver.model.qm.QMServiceProvider;
import com.dbeaver.remote.client.MSServiceType;
import com.dbeaver.remote.client.dc.DCApplicationConfiguration;
import com.dbeaver.remote.client.dc.DCClientConfiguration;
import com.dbeaver.remote.client.dc.DCConfigurationClient;
import com.dbeaver.remote.client.dc.DCUserConfiguration;
import com.dbeaver.remote.client.dc.DCUserConfigurationProvider;
import com.dbeaver.remote.client.qm.QMClient;
import com.dbeaver.remote.client.qm.QMClientConfiguration;
import com.dbeaver.remote.client.qm.RAGStorageClient;
import com.dbeaver.remote.client.rm.RMClient;
import com.dbeaver.remote.client.rm.RMClientConfiguration;
import com.dbeaver.remote.client.tm.client.TMClientConfiguration;
import com.dbeaver.remote.client.tm.client.TMTaskExecutionClient;
import com.dbeaver.remote.client.tm.client.TMTaskInfoClient;
import com.dbeaver.remote.client.tm.model.TMTaskExecutionService;
import com.dbeaver.remote.client.tm.model.TMTaskInfoService;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import com.dbeaver.remote.workspace.RemoteUserPreferenceStore;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMAuthInfo;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMSessionProvider;
import org.jkiss.dbeaver.model.rcp.DesktopProjectImpl;
import org.jkiss.dbeaver.model.rcp.DesktopWorkspaceImpl;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectInfo;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class DesktopWorkspaceRemote
extends DesktopWorkspaceImpl
implements DCUserConfigurationProvider,
QMServiceProvider,
RAGStorageProvider {
    private static final Log log = Log.getLog(DesktopWorkspaceRemote.class);
    public static final String REMOTE_PROJECTS_FOLDER = ".remote";
    public static final String FEATURE_ENABLE_DESKTOP = "enableDesktopApp";
    private RMController rmController;
    private DCApplicationConfiguration appConfiguration;
    private DCUserConfiguration userConfiguration;
    private SMAuthInfo smAuthInfo;
    private RMProject[] accessibleProjects;
    private RMClientConfiguration rmClientConfiguration;
    private QMService qmController;
    private RAGEmbeddingStorage ragStorage;
    private TMTaskExecutionService taskExecutionService;
    private TMTaskInfoService taskInfoService;

    protected DesktopWorkspaceRemote(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        super(platform, eclipseWorkspace);
    }

    @Nullable
    public SMAuthInfo getWorkspaceAuthInfo() {
        return this.smAuthInfo;
    }

    public void dispose() {
        try {
            SMSession currentSession = this.getAuthContext().getSpaceSession((DBRProgressMonitor)new LoggingProgressMonitor(log), (SMAuthSpace)this, false);
            if (currentSession != null) {
                currentSession.close();
            }
        }
        catch (Exception e) {
            log.debug((Object)"Error closing workspace session", (Throwable)e);
        }
        super.dispose();
    }

    public RMController getResourceController() {
        return this.rmController;
    }

    public RMClientConfiguration getRmClientConfiguration() {
        return this.rmClientConfiguration;
    }

    @Nullable
    public TMTaskExecutionService getTaskExecutionService() {
        return this.taskExecutionService;
    }

    @Nullable
    public TMTaskInfoService getTaskInfoService() {
        return this.taskInfoService;
    }

    public DCApplicationConfiguration getAppConfiguration() {
        return this.appConfiguration;
    }

    public DCUserConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    @Nullable
    public QMService getActiveQueryManagerService() {
        return this.qmController;
    }

    @Nullable
    public String getQueryManagerSessionId() {
        DBPApplication dBPApplication = DBWorkbench.getPlatform().getApplication();
        if (dBPApplication instanceof QMSessionProvider) {
            QMSessionProvider sessionProvider = (QMSessionProvider)dBPApplication;
            return sessionProvider.getQueryManagerSessionId();
        }
        return null;
    }

    @NotNull
    public RAGEmbeddingStorage getEmbeddingStorage() throws DBException {
        if (this.ragStorage == null) {
            throw new DBException("RAG Embedding Storage is not available in the current workspace");
        }
        return this.ragStorage;
    }

    protected boolean isDefaultProjectNeeded() {
        return false;
    }

    @NotNull
    public IWorkspace getEclipseWorkspace() {
        return super.getEclipseWorkspace();
    }

    protected void initializeRemoteWorkspace(@NotNull DBRProgressMonitor monitor, @NotNull SMSession workspaceSession) throws DBException {
        SMSessionRemote sessionRemote = (SMSessionRemote)DBUtils.getAdapter(SMSessionRemote.class, (Object)workspaceSession);
        if (sessionRemote != null) {
            String rmEndpoint;
            SMServerAPI serverApi = sessionRemote.getServerApi();
            log.debug((Object)("Remote server version is " + serverApi.getServerVersion()));
            this.smAuthInfo = (SMAuthInfo)DBUtils.getAdapter(SMAuthInfo.class, (Object)sessionRemote);
            DCConfigurationClient cfgClient = new DCConfigurationClient(DCClientConfiguration.builder((SMSessionRemote)sessionRemote).build());
            this.appConfiguration = cfgClient.getApplicationConfiguration();
            this.userConfiguration = cfgClient.getUserConfiguration();
            if (!SMClientUtils.isServerLegacy((SMServerAPI)serverApi, (String)"25.1.2") && !this.userConfiguration.isFeatureEnabled(FEATURE_ENABLE_DESKTOP)) {
                throw new DBException("Desktop application was disabled on the remote server");
            }
            DBPPreferenceStore dBPPreferenceStore = DBWorkbench.getPlatform().getPreferenceStore();
            if (dBPPreferenceStore instanceof RemoteUserPreferenceStore) {
                RemoteUserPreferenceStore remotePreferenceStore = (RemoteUserPreferenceStore)dBPPreferenceStore;
                if (SMClientUtils.isServerLegacy((SMServerAPI)serverApi, (String)"24.0.1")) {
                    remotePreferenceStore.setForceUseLocalPreferenceStore(true);
                    log.debug((Object)("Old server version is used " + serverApi.getServerVersion() + " preferences will be saved locally"));
                } else {
                    remotePreferenceStore.updateServerPreferences(this.appConfiguration.getProductConfiguration());
                    Map userPreferences = this.userConfiguration.getUserPreferences();
                    if (!CommonUtils.isEmpty((Map)userPreferences)) {
                        remotePreferenceStore.updateAllUserPreferences(userPreferences);
                    }
                    remotePreferenceStore.setSmController((SMController)DBUtils.getAdapter(SMController.class, (Object)sessionRemote));
                }
            }
            if ((rmEndpoint = this.userConfiguration.getServiceEndpoint(MSServiceType.RESOURCE_MANAGER)) == null) {
                throw new DBException("Cannot determine resource manager server endpoint");
            }
            SMCredentialsProvider smCredentialsProvider = sessionRemote.getRemoteCredentialsProvider();
            this.rmClientConfiguration = ((RMClientConfiguration.Builder)((RMClientConfiguration.Builder)((RMClientConfiguration.Builder)RMClientConfiguration.builder().setApiUrl(rmEndpoint)).setCredentialsProvider(smCredentialsProvider)).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)smCredentialsProvider).refreshSMSession())).setServerAPI(serverApi).build();
            this.rmController = new RMClient(this.rmClientConfiguration);
            String qmEndpoint = this.userConfiguration.getServiceEndpoint(MSServiceType.QUERY_MANAGER);
            if (qmEndpoint == null) {
                log.error((Object)"Cannot determine query manager server endpoint");
            } else {
                QMClientConfiguration qmClientConfiguration = ((QMClientConfiguration.Builder)((QMClientConfiguration.Builder)((QMClientConfiguration.Builder)QMClientConfiguration.builder().setApiUrl(qmEndpoint)).setCredentialsProvider(smCredentialsProvider)).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)smCredentialsProvider).refreshSMSession())).build();
                this.qmController = new QMClient(qmClientConfiguration);
                this.ragStorage = new RAGStorageClient(qmClientConfiguration);
            }
            String tmEndpoint = this.userConfiguration.getServiceEndpoint(MSServiceType.TASK_MANAGER);
            if (tmEndpoint == null) {
                log.error((Object)"Cannot determine task manager server endpoint");
            } else {
                TMClientConfiguration tmClientConfiguration = ((TMClientConfiguration.Builder)((TMClientConfiguration.Builder)((TMClientConfiguration.Builder)TMClientConfiguration.builder().setApiUrl(tmEndpoint)).setCredentialsProvider(smCredentialsProvider)).setRefreshSMSessionFunction(() -> ((SMCredentialsProvider)smCredentialsProvider).refreshSMSession())).build();
                this.taskExecutionService = new TMTaskExecutionClient(tmClientConfiguration);
                this.taskInfoService = new TMTaskInfoClient(tmClientConfiguration);
            }
        } else {
            throw new DBException("Team workspace requires remote app session (" + String.valueOf(workspaceSession) + " was provided)");
        }
    }

    protected void loadWorkspaceProjects() throws DBException {
        Set<Object> rmProjectsToAdd;
        RMProject[] loadedProjects;
        try {
            loadedProjects = this.rmController.listAccessibleProjects();
        }
        catch (DBException e) {
            Object loadedProjects2 = null;
            String msg = "Error loading accessible projects:\n" + e.getMessage();
            if (this.accessibleProjects == null) {
                throw new DBException(msg, (Throwable)e);
            }
            log.error((Object)msg, (Throwable)e);
            return;
        }
        if (this.accessibleProjects == null) {
            rmProjectsToAdd = new LinkedHashSet();
            Collections.addAll(rmProjectsToAdd, loadedProjects);
        } else {
            Map<String, RemoteProjectImpl> knownProjectsById = Stream.of(this.getEclipseWorkspace().getRoot().getProjects()).map(arg_0 -> ((DesktopWorkspaceRemote)this).getProject(arg_0)).filter(p -> p instanceof RemoteProjectImpl).collect(Collectors.toMap(DBPProject::getId, p -> (RemoteProjectImpl)((Object)p)));
            Map<String, RMProject> loadedRmProjects = Arrays.stream(loadedProjects).collect(Collectors.toMap(RMProject::getId, p -> p));
            rmProjectsToAdd = loadedRmProjects.values().stream().filter(p -> !knownProjectsById.containsKey(p.getId())).collect(Collectors.toSet());
        }
        this.accessibleProjects = loadedProjects;
        for (RMProject rmProject : rmProjectsToAdd) {
            this.createEclipseProjectForRemote(rmProject);
        }
        super.loadWorkspaceProjects();
    }

    private DBPProject createEclipseProjectForRemote(RMProject rmProject) throws DBException {
        IWorkspace eclipseWorkspace = this.getEclipseWorkspace();
        VoidProgressMonitor monitor = new VoidProgressMonitor();
        String projectName = rmProject.getDisplayName();
        IProject eProject = eclipseWorkspace.getRoot().getProject(projectName);
        if (eProject.exists()) {
            try {
                boolean hasRemoteNature = REMOTE_PROJECTS_FOLDER.equals(eProject.getLocation().removeLastSegments(1).lastSegment());
                if (!hasRemoteNature) {
                    log.warn((Object)("Cleanup local copy of project '" + rmProject.getName() + "'"));
                    eProject.delete(true, true, monitor.getNestedMonitor());
                }
            }
            catch (Exception exception) {
                log.error((Object)("Error deleting old version of remote project '" + rmProject.getName() + "'"));
            }
        }
        if (!eProject.exists()) {
            IPath wsLocation = eclipseWorkspace.getRoot().getLocation();
            IPath projectLocation = wsLocation.append(REMOTE_PROJECTS_FOLDER).append(rmProject.getId());
            int dupIndex = 0;
            while (projectLocation.toFile().exists()) {
                projectLocation = wsLocation.append(REMOTE_PROJECTS_FOLDER).append(rmProject.getId() + ++dupIndex);
            }
            if (dupIndex > 0) {
                log.debug((Object)("Project '" + rmProject.getId() + " location conflicts with another project. Appended suffix " + dupIndex));
            }
            ProjectDescription description = new ProjectDescription();
            description.setLocation(projectLocation);
            description.setName(projectName);
            description.setComment(CommonUtils.notEmpty((String)rmProject.getDescription()));
            description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature", "com.dbeaver.DBeaverRemote"});
            try {
                eProject.create((IProjectDescription)description, monitor.getNestedMonitor());
            }
            catch (Exception e) {
                log.error((Object)("Error creating local link to remote project '" + rmProject.getName() + "': " + e.getMessage()));
            }
        }
        DBPProject project = this.getProject(eProject);
        boolean cfr_ignored_0 = project instanceof RemoteProjectImpl;
        return project;
    }

    protected boolean isProjectAccessible(IProject project) {
        if (this.accessibleProjects != null) {
            RMProject[] rMProjectArray = this.accessibleProjects;
            int n = this.accessibleProjects.length;
            int n2 = 0;
            while (n2 < n) {
                RMProject rmProject = rMProjectArray[n2];
                if (rmProject.getDisplayName().equals(project.getName())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public RMProject getRmProject(String projectId) {
        if (this.accessibleProjects != null) {
            RMProject[] rMProjectArray = this.accessibleProjects;
            int n = this.accessibleProjects.length;
            int n2 = 0;
            while (n2 < n) {
                RMProject rmp = rMProjectArray[n2];
                if (rmp.getId().equals(projectId)) {
                    return rmp;
                }
                ++n2;
            }
        }
        return null;
    }

    protected DesktopProjectImpl createProjectFrom(IProject project) {
        String projectFolder = project.getLocation().removeLastSegments(1).lastSegment();
        if (REMOTE_PROJECTS_FOLDER.equals(projectFolder)) {
            return this.createRemoteProject(project);
        }
        return super.createProjectFrom(project);
    }

    @NotNull
    protected RemoteProjectImpl createRemoteProject(IProject project) {
        return new RemoteProjectImpl(this, project, this.getAuthContext());
    }

    @NotNull
    public DBPProject createProject(@NotNull String name, @Nullable String description) throws DBException {
        name = name.trim();
        GeneralUtils.validateResourceName((String)name);
        RMProject rmProject = this.rmController.createProject(name, description);
        this.accessibleProjects = (RMProject[])ArrayUtils.add(RMProject.class, (Object[])this.accessibleProjects, (Object)rmProject);
        return this.createEclipseProjectForRemote(rmProject);
    }

    public void deleteProject(@NotNull DBPProject project, boolean deleteContents) throws DBException {
        if (!(project instanceof RemoteProjectImpl)) {
            throw new DBException("Can not delete non-remote project '" + project.getName() + "'");
        }
        this.rmController.deleteProject(project.getId());
        this.accessibleProjects = (RMProject[])ArrayUtils.remove(RMProject.class, (Object[])this.accessibleProjects, (Object)((RemoteProjectImpl)project).getRMProject());
        super.deleteProject(project, deleteContents);
    }

    protected String initWorkspaceId() {
        return null;
    }

    @NotNull
    public String getWorkspaceId() {
        SMSessionRemote remote;
        SMSession sMSession = this.getWorkspaceSession();
        if (sMSession instanceof SMSessionRemote && SMClientUtils.isServerLegacy((SMServerAPI)(remote = (SMSessionRemote)sMSession).getServerApi(), (String)"24.1.0")) {
            return super.getWorkspaceId();
        }
        return this.appConfiguration.getApplicationWorkspaceId();
    }

    public boolean isEnabledSecretProviders() {
        return this.userConfiguration.isFeatureEnabled("secretManager");
    }

    public void addProjectToCache(@NotNull String projectId) throws DBException {
        RMProject rmProject = this.rmController.getProject(projectId, false, false);
        this.accessibleProjects = (RMProject[])ArrayUtils.add(RMProject.class, (Object[])this.accessibleProjects, (Object)rmProject);
        this.createEclipseProjectForRemote(rmProject);
    }

    public void updateProjectInCache(@NotNull String projectId, @Nullable RMProjectInfo projectInfo) throws DBException {
        DBNProject dbnProject;
        DBNModel navigatorModel;
        if (projectInfo == null) {
            log.error((Object)("No project info provided for project '" + projectId + "'"));
            return;
        }
        RemoteProjectImpl project = (RemoteProjectImpl)this.getProjectById(projectId);
        if (project == null) {
            log.error((Object)("Project '" + projectId + "' is not found in workspace"));
            return;
        }
        String oldName = project.getName();
        project.updateProjectInfo(projectInfo.getName(), projectInfo.getDescription());
        if (CommonUtils.equalObjects((Object)oldName, (Object)this.platform.getPreferenceStore().getString("project.active"))) {
            this.platform.getPreferenceStore().setValue("project.active", project.getName());
        }
        if ((navigatorModel = project.getNavigatorModel()) != null && (dbnProject = navigatorModel.getRoot().getProjectNode((DBPProject)project)) != null) {
            navigatorModel.fireNodeEvent(new DBNEvent((Object)dbnProject, DBNEvent.Action.UPDATE, (DBNNode)dbnProject));
        }
    }

    public void removeProjectFromCache(@NotNull String projectId) {
        RemoteProjectImpl project = (RemoteProjectImpl)this.getProjectById(projectId);
        if (project == null) {
            log.error((Object)("Project '" + projectId + "' is not found in workspace"));
            return;
        }
        IProject eclipseProject = project.getEclipseProject();
        try {
            if (eclipseProject != null) {
                eclipseProject.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            this.accessibleProjects = (RMProject[])ArrayUtils.remove(RMProject.class, (Object[])this.accessibleProjects, (Object)project.getRMProject());
        }
        catch (Exception exception) {
            log.error((Object)("Error cleaning project '" + projectId + "'"));
        }
    }
}

