/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.filesystem;

import com.dbeaver.remote.filesystem.RemoteFileStore;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileSystem;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMResource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class RemoteFileSystem
extends FileSystem {
    public static final String SCHEME_RM = "dbrm";
    private static final Log log = Log.getLog(RemoteFileSystem.class);
    private final Map<URI, RemoteFileStore> cachedStored = new HashMap<URI, RemoteFileStore>();

    static RemoteProjectImpl getRemoteProject(URI baseURI) {
        IContainer[] rootContainers;
        String resourcePath;
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        String wsPath = workspace.getAbsolutePath().toUri().getPath();
        String uriPath = baseURI.getPath();
        if (uriPath.startsWith(wsPath) && (resourcePath = uriPath.substring(wsPath.length())).startsWith(".remote")) {
            int divPos = (resourcePath = CommonUtils.removeLeadingSlash((String)resourcePath.substring(".remote".length()))).indexOf(47);
            String projectId = divPos != -1 ? resourcePath.substring(0, divPos) : resourcePath;
            DBPProject project = workspace.getProjectById(projectId);
            if (project instanceof RemoteProjectImpl) {
                RemoteProjectImpl rp = (RemoteProjectImpl)project;
                return rp;
            }
            log.debug((Object)("Cannot determine remote project from URI '" + String.valueOf(baseURI) + "'. Trying to find in Eclipse containers"));
        }
        if ((rootContainers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(baseURI)).length != 1) {
            return null;
        }
        IProject project = rootContainers[0].getProject();
        return (RemoteProjectImpl)DBPPlatformDesktop.getInstance().getWorkspace().getProject(project);
    }

    public synchronized IFileStore getStore(URI uri) {
        if (SCHEME_RM.equals(uri.getScheme())) {
            RemoteFileStore store = this.cachedStored.get(uri);
            if (store != null) {
                return store;
            }
            try {
                RMProject resource;
                String uriQuery = uri.getQuery();
                uriQuery = uriQuery.replace(" ", "%20");
                IFileStore rootStore = EFS.getStore((URI)new URI((String)(uriQuery.startsWith("file:/") ? uriQuery : "file:/" + uriQuery)));
                String path = uri.getPath();
                Path fullPath = new Path(path);
                if (path.isEmpty() || path.equals("/")) {
                    resource = new RMProject(rootStore.getParent().getName());
                } else {
                    URI baseURI = new URI(uriQuery);
                    RemoteProjectImpl remoteProject = RemoteFileSystem.getRemoteProject(baseURI);
                    if (remoteProject == null) {
                        throw new DBException("Couldn't find remote project for URI " + String.valueOf(baseURI));
                    }
                    resource = remoteProject.getResourceFromCache((IPath)fullPath);
                    if (resource == null) {
                        IPath folderPath = fullPath.removeLastSegments(1);
                        RMObject parentFolder = remoteProject.getResourceFromCache(folderPath);
                        if (!(parentFolder instanceof RMResource)) {
                            throw new DBException("Resource '" + String.valueOf(fullPath) + "' location does not exist in project '" + remoteProject.getName() + "'");
                        }
                        if (!parentFolder.isFolder()) {
                            throw new DBException("Resource '" + String.valueOf(fullPath) + "' can not be created inside file '" + String.valueOf(folderPath) + "'");
                        }
                        resource = new RMResource(fullPath.lastSegment());
                    }
                }
                store = new RemoteFileStore(rootStore, (IPath)fullPath, (RMObject)resource);
                if (resource instanceof RMProject) {
                    this.cachedStored.put(uri, store);
                }
                return store;
            }
            catch (Exception e) {
                log.error((Object)e.getMessage());
            }
        }
        return EFS.getNullFileSystem().getStore(uri);
    }

    static IPath getWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation();
    }
}

