/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.GeoRedundantBackup;
import com.azure.resourcemanager.postgresql.models.StorageAutogrow;
import java.io.IOException;

public final class StorageProfile
implements JsonSerializable<StorageProfile> {
    private Integer backupRetentionDays;
    private GeoRedundantBackup geoRedundantBackup;
    private Integer storageMB;
    private StorageAutogrow storageAutogrow;

    public Integer backupRetentionDays() {
        return this.backupRetentionDays;
    }

    public StorageProfile withBackupRetentionDays(Integer backupRetentionDays) {
        this.backupRetentionDays = backupRetentionDays;
        return this;
    }

    public GeoRedundantBackup geoRedundantBackup() {
        return this.geoRedundantBackup;
    }

    public StorageProfile withGeoRedundantBackup(GeoRedundantBackup geoRedundantBackup) {
        this.geoRedundantBackup = geoRedundantBackup;
        return this;
    }

    public Integer storageMB() {
        return this.storageMB;
    }

    public StorageProfile withStorageMB(Integer storageMB) {
        this.storageMB = storageMB;
        return this;
    }

    public StorageAutogrow storageAutogrow() {
        return this.storageAutogrow;
    }

    public StorageProfile withStorageAutogrow(StorageAutogrow storageAutogrow) {
        this.storageAutogrow = storageAutogrow;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("backupRetentionDays", (Number)this.backupRetentionDays);
        jsonWriter.writeStringField("geoRedundantBackup", this.geoRedundantBackup == null ? null : this.geoRedundantBackup.toString());
        jsonWriter.writeNumberField("storageMB", (Number)this.storageMB);
        jsonWriter.writeStringField("storageAutogrow", this.storageAutogrow == null ? null : this.storageAutogrow.toString());
        return jsonWriter.writeEndObject();
    }

    public static StorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return (StorageProfile)jsonReader.readObject(reader -> {
            StorageProfile deserializedStorageProfile = new StorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("backupRetentionDays".equals(fieldName)) {
                    deserializedStorageProfile.backupRetentionDays = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("geoRedundantBackup".equals(fieldName)) {
                    deserializedStorageProfile.geoRedundantBackup = GeoRedundantBackup.fromString(reader.getString());
                    continue;
                }
                if ("storageMB".equals(fieldName)) {
                    deserializedStorageProfile.storageMB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("storageAutogrow".equals(fieldName)) {
                    deserializedStorageProfile.storageAutogrow = StorageAutogrow.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorageProfile;
        });
    }
}

