/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.CreateMode;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForCreate;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;

public final class ServerPropertiesForDefaultCreate
extends ServerPropertiesForCreate {
    private CreateMode createMode = CreateMode.DEFAULT;
    private String administratorLogin;
    private String administratorLoginPassword;
    private static final ClientLogger LOGGER = new ClientLogger(ServerPropertiesForDefaultCreate.class);

    @Override
    public CreateMode createMode() {
        return this.createMode;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ServerPropertiesForDefaultCreate withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ServerPropertiesForDefaultCreate withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withVersion(ServerVersion version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        super.withSslEnforcement(sslEnforcement);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        super.withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        super.withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        super.withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    @Override
    public ServerPropertiesForDefaultCreate withStorageProfile(StorageProfile storageProfile) {
        super.withStorageProfile(storageProfile);
        return this;
    }

    @Override
    public void validate() {
        if (this.administratorLogin() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ServerPropertiesForDefaultCreate"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ServerPropertiesForDefaultCreate"));
        }
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version() == null ? null : this.version().toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement() == null ? null : this.sslEnforcement().toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion() == null ? null : this.minimalTlsVersion().toString());
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption() == null ? null : this.infrastructureEncryption().toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess() == null ? null : this.publicNetworkAccess().toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile());
        jsonWriter.writeStringField("administratorLogin", this.administratorLogin);
        jsonWriter.writeStringField("administratorLoginPassword", this.administratorLoginPassword);
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForDefaultCreate fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForDefaultCreate)jsonReader.readObject(reader -> {
            ServerPropertiesForDefaultCreate deserializedServerPropertiesForDefaultCreate = new ServerPropertiesForDefaultCreate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withVersion(ServerVersion.fromString(reader.getString()));
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withSslEnforcement(SslEnforcementEnum.fromString(reader.getString()));
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withMinimalTlsVersion(MinimalTlsVersionEnum.fromString(reader.getString()));
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withInfrastructureEncryption(InfrastructureEncryption.fromString(reader.getString()));
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withPublicNetworkAccess(PublicNetworkAccessEnum.fromString(reader.getString()));
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.withStorageProfile(StorageProfile.fromJson(reader));
                    continue;
                }
                if ("administratorLogin".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.administratorLogin = reader.getString();
                    continue;
                }
                if ("administratorLoginPassword".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.administratorLoginPassword = reader.getString();
                    continue;
                }
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForDefaultCreate.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForDefaultCreate;
        });
    }
}

