/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.CreateMode;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForDefaultCreate;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForGeoRestore;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForReplica;
import com.azure.resourcemanager.postgresql.models.ServerPropertiesForRestore;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;

public class ServerPropertiesForCreate
implements JsonSerializable<ServerPropertiesForCreate> {
    private CreateMode createMode = CreateMode.fromString("ServerPropertiesForCreate");
    private ServerVersion version;
    private SslEnforcementEnum sslEnforcement;
    private MinimalTlsVersionEnum minimalTlsVersion;
    private InfrastructureEncryption infrastructureEncryption;
    private PublicNetworkAccessEnum publicNetworkAccess;
    private StorageProfile storageProfile;

    public CreateMode createMode() {
        return this.createMode;
    }

    public ServerVersion version() {
        return this.version;
    }

    public ServerPropertiesForCreate withVersion(ServerVersion version) {
        this.version = version;
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.sslEnforcement;
    }

    public ServerPropertiesForCreate withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        this.sslEnforcement = sslEnforcement;
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.minimalTlsVersion;
    }

    public ServerPropertiesForCreate withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        this.minimalTlsVersion = minimalTlsVersion;
        return this;
    }

    public InfrastructureEncryption infrastructureEncryption() {
        return this.infrastructureEncryption;
    }

    public ServerPropertiesForCreate withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        this.infrastructureEncryption = infrastructureEncryption;
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    public ServerPropertiesForCreate withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    public StorageProfile storageProfile() {
        return this.storageProfile;
    }

    public ServerPropertiesForCreate withStorageProfile(StorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    public void validate() {
        if (this.storageProfile() != null) {
            this.storageProfile().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("createMode", this.createMode == null ? null : this.createMode.toString());
        jsonWriter.writeStringField("version", this.version == null ? null : this.version.toString());
        jsonWriter.writeStringField("sslEnforcement", this.sslEnforcement == null ? null : this.sslEnforcement.toString());
        jsonWriter.writeStringField("minimalTlsVersion", this.minimalTlsVersion == null ? null : this.minimalTlsVersion.toString());
        jsonWriter.writeStringField("infrastructureEncryption", this.infrastructureEncryption == null ? null : this.infrastructureEncryption.toString());
        jsonWriter.writeStringField("publicNetworkAccess", this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("storageProfile", (JsonSerializable)this.storageProfile);
        return jsonWriter.writeEndObject();
    }

    public static ServerPropertiesForCreate fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForCreate)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                ServerPropertiesForCreate serverPropertiesForCreate;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("createMode".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("Default".equals(discriminatorValue)) {
                    serverPropertiesForCreate = ServerPropertiesForDefaultCreate.fromJson(readerToUse.reset());
                    return serverPropertiesForCreate;
                }
                if ("PointInTimeRestore".equals(discriminatorValue)) {
                    serverPropertiesForCreate = ServerPropertiesForRestore.fromJson(readerToUse.reset());
                    return serverPropertiesForCreate;
                }
                if ("GeoRestore".equals(discriminatorValue)) {
                    serverPropertiesForCreate = ServerPropertiesForGeoRestore.fromJson(readerToUse.reset());
                    return serverPropertiesForCreate;
                }
                if ("Replica".equals(discriminatorValue)) {
                    serverPropertiesForCreate = ServerPropertiesForReplica.fromJson(readerToUse.reset());
                    return serverPropertiesForCreate;
                }
                serverPropertiesForCreate = ServerPropertiesForCreate.fromJsonKnownDiscriminator(readerToUse.reset());
                return serverPropertiesForCreate;
            }
        });
    }

    static ServerPropertiesForCreate fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (ServerPropertiesForCreate)jsonReader.readObject(reader -> {
            ServerPropertiesForCreate deserializedServerPropertiesForCreate = new ServerPropertiesForCreate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("createMode".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.createMode = CreateMode.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.version = ServerVersion.fromString(reader.getString());
                    continue;
                }
                if ("sslEnforcement".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.sslEnforcement = SslEnforcementEnum.fromString(reader.getString());
                    continue;
                }
                if ("minimalTlsVersion".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.minimalTlsVersion = MinimalTlsVersionEnum.fromString(reader.getString());
                    continue;
                }
                if ("infrastructureEncryption".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.infrastructureEncryption = InfrastructureEncryption.fromString(reader.getString());
                    continue;
                }
                if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.publicNetworkAccess = PublicNetworkAccessEnum.fromString(reader.getString());
                    continue;
                }
                if ("storageProfile".equals(fieldName)) {
                    deserializedServerPropertiesForCreate.storageProfile = StorageProfile.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPropertiesForCreate;
        });
    }
}

