/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.PrivateEndpointProperty;
import com.azure.resourcemanager.postgresql.models.PrivateEndpointProvisioningState;
import com.azure.resourcemanager.postgresql.models.ServerPrivateLinkServiceConnectionStateProperty;
import java.io.IOException;

public final class ServerPrivateEndpointConnectionProperties
implements JsonSerializable<ServerPrivateEndpointConnectionProperties> {
    private PrivateEndpointProperty privateEndpoint;
    private ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState;
    private PrivateEndpointProvisioningState provisioningState;

    public PrivateEndpointProperty privateEndpoint() {
        return this.privateEndpoint;
    }

    public ServerPrivateEndpointConnectionProperties withPrivateEndpoint(PrivateEndpointProperty privateEndpoint) {
        this.privateEndpoint = privateEndpoint;
        return this;
    }

    public ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState() {
        return this.privateLinkServiceConnectionState;
    }

    public ServerPrivateEndpointConnectionProperties withPrivateLinkServiceConnectionState(ServerPrivateLinkServiceConnectionStateProperty privateLinkServiceConnectionState) {
        this.privateLinkServiceConnectionState = privateLinkServiceConnectionState;
        return this;
    }

    public PrivateEndpointProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.privateEndpoint() != null) {
            this.privateEndpoint().validate();
        }
        if (this.privateLinkServiceConnectionState() != null) {
            this.privateLinkServiceConnectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("privateEndpoint", (JsonSerializable)this.privateEndpoint);
        jsonWriter.writeJsonField("privateLinkServiceConnectionState", (JsonSerializable)this.privateLinkServiceConnectionState);
        return jsonWriter.writeEndObject();
    }

    public static ServerPrivateEndpointConnectionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerPrivateEndpointConnectionProperties)jsonReader.readObject(reader -> {
            ServerPrivateEndpointConnectionProperties deserializedServerPrivateEndpointConnectionProperties = new ServerPrivateEndpointConnectionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("privateEndpoint".equals(fieldName)) {
                    deserializedServerPrivateEndpointConnectionProperties.privateEndpoint = PrivateEndpointProperty.fromJson(reader);
                    continue;
                }
                if ("privateLinkServiceConnectionState".equals(fieldName)) {
                    deserializedServerPrivateEndpointConnectionProperties.privateLinkServiceConnectionState = ServerPrivateLinkServiceConnectionStateProperty.fromJson(reader);
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedServerPrivateEndpointConnectionProperties.provisioningState = PrivateEndpointProvisioningState.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerPrivateEndpointConnectionProperties;
        });
    }
}

