/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.postgresql.PostgreSqlManager;
import com.azure.resourcemanager.postgresql.fluent.ServerBasedPerformanceTiersClient;
import com.azure.resourcemanager.postgresql.fluent.models.PerformanceTierPropertiesInner;
import com.azure.resourcemanager.postgresql.implementation.PerformanceTierPropertiesImpl;
import com.azure.resourcemanager.postgresql.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.postgresql.models.PerformanceTierProperties;
import com.azure.resourcemanager.postgresql.models.ServerBasedPerformanceTiers;

public final class ServerBasedPerformanceTiersImpl
implements ServerBasedPerformanceTiers {
    private static final ClientLogger LOGGER = new ClientLogger(ServerBasedPerformanceTiersImpl.class);
    private final ServerBasedPerformanceTiersClient innerClient;
    private final PostgreSqlManager serviceManager;

    public ServerBasedPerformanceTiersImpl(ServerBasedPerformanceTiersClient innerClient, PostgreSqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String resourceGroupName, String serverName) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    private ServerBasedPerformanceTiersClient serviceClient() {
        return this.innerClient;
    }

    private PostgreSqlManager manager() {
        return this.serviceManager;
    }
}

