/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.fluent.models.ServerProperties;
import com.azure.resourcemanager.postgresql.models.InfrastructureEncryption;
import com.azure.resourcemanager.postgresql.models.MinimalTlsVersionEnum;
import com.azure.resourcemanager.postgresql.models.PublicNetworkAccessEnum;
import com.azure.resourcemanager.postgresql.models.ResourceIdentity;
import com.azure.resourcemanager.postgresql.models.ServerPrivateEndpointConnection;
import com.azure.resourcemanager.postgresql.models.ServerState;
import com.azure.resourcemanager.postgresql.models.ServerVersion;
import com.azure.resourcemanager.postgresql.models.Sku;
import com.azure.resourcemanager.postgresql.models.SslEnforcementEnum;
import com.azure.resourcemanager.postgresql.models.StorageProfile;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

public final class ServerInner
extends Resource {
    private ResourceIdentity identity;
    private Sku sku;
    private ServerProperties innerProperties;
    private String type;
    private String name;
    private String id;

    public ResourceIdentity identity() {
        return this.identity;
    }

    public ServerInner withIdentity(ResourceIdentity identity) {
        this.identity = identity;
        return this;
    }

    public Sku sku() {
        return this.sku;
    }

    public ServerInner withSku(Sku sku) {
        this.sku = sku;
        return this;
    }

    private ServerProperties innerProperties() {
        return this.innerProperties;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public ServerInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ServerInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String administratorLogin() {
        return this.innerProperties() == null ? null : this.innerProperties().administratorLogin();
    }

    public ServerInner withAdministratorLogin(String administratorLogin) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withAdministratorLogin(administratorLogin);
        return this;
    }

    public ServerVersion version() {
        return this.innerProperties() == null ? null : this.innerProperties().version();
    }

    public ServerInner withVersion(ServerVersion version) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withVersion(version);
        return this;
    }

    public SslEnforcementEnum sslEnforcement() {
        return this.innerProperties() == null ? null : this.innerProperties().sslEnforcement();
    }

    public ServerInner withSslEnforcement(SslEnforcementEnum sslEnforcement) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withSslEnforcement(sslEnforcement);
        return this;
    }

    public MinimalTlsVersionEnum minimalTlsVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().minimalTlsVersion();
    }

    public ServerInner withMinimalTlsVersion(MinimalTlsVersionEnum minimalTlsVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMinimalTlsVersion(minimalTlsVersion);
        return this;
    }

    public String byokEnforcement() {
        return this.innerProperties() == null ? null : this.innerProperties().byokEnforcement();
    }

    public InfrastructureEncryption infrastructureEncryption() {
        return this.innerProperties() == null ? null : this.innerProperties().infrastructureEncryption();
    }

    public ServerInner withInfrastructureEncryption(InfrastructureEncryption infrastructureEncryption) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withInfrastructureEncryption(infrastructureEncryption);
        return this;
    }

    public ServerState userVisibleState() {
        return this.innerProperties() == null ? null : this.innerProperties().userVisibleState();
    }

    public ServerInner withUserVisibleState(ServerState userVisibleState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withUserVisibleState(userVisibleState);
        return this;
    }

    public String fullyQualifiedDomainName() {
        return this.innerProperties() == null ? null : this.innerProperties().fullyQualifiedDomainName();
    }

    public ServerInner withFullyQualifiedDomainName(String fullyQualifiedDomainName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withFullyQualifiedDomainName(fullyQualifiedDomainName);
        return this;
    }

    public OffsetDateTime earliestRestoreDate() {
        return this.innerProperties() == null ? null : this.innerProperties().earliestRestoreDate();
    }

    public ServerInner withEarliestRestoreDate(OffsetDateTime earliestRestoreDate) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withEarliestRestoreDate(earliestRestoreDate);
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ServerInner withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String replicationRole() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationRole();
    }

    public ServerInner withReplicationRole(String replicationRole) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicationRole(replicationRole);
        return this;
    }

    public String masterServerId() {
        return this.innerProperties() == null ? null : this.innerProperties().masterServerId();
    }

    public ServerInner withMasterServerId(String masterServerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withMasterServerId(masterServerId);
        return this;
    }

    public Integer replicaCapacity() {
        return this.innerProperties() == null ? null : this.innerProperties().replicaCapacity();
    }

    public ServerInner withReplicaCapacity(Integer replicaCapacity) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withReplicaCapacity(replicaCapacity);
        return this;
    }

    public PublicNetworkAccessEnum publicNetworkAccess() {
        return this.innerProperties() == null ? null : this.innerProperties().publicNetworkAccess();
    }

    public ServerInner withPublicNetworkAccess(PublicNetworkAccessEnum publicNetworkAccess) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ServerProperties();
        }
        this.innerProperties().withPublicNetworkAccess(publicNetworkAccess);
        return this;
    }

    public List<ServerPrivateEndpointConnection> privateEndpointConnections() {
        return this.innerProperties() == null ? null : this.innerProperties().privateEndpointConnections();
    }

    public void validate() {
        if (this.identity() != null) {
            this.identity().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("identity", (JsonSerializable)this.identity);
        jsonWriter.writeJsonField("sku", (JsonSerializable)this.sku);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static ServerInner fromJson(JsonReader jsonReader) throws IOException {
        return (ServerInner)((Object)jsonReader.readObject(reader -> {
            ServerInner deserializedServerInner = new ServerInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedServerInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedServerInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedServerInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedServerInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedServerInner.withTags(tags);
                    continue;
                }
                if ("identity".equals(fieldName)) {
                    deserializedServerInner.identity = ResourceIdentity.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedServerInner.sku = Sku.fromJson(reader);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedServerInner.innerProperties = ServerProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerInner;
        }));
    }
}

