/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.postgresql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.postgresql.models.AdministratorType;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public final class ServerAdministratorProperties
implements JsonSerializable<ServerAdministratorProperties> {
    private AdministratorType administratorType;
    private String login;
    private UUID sid;
    private UUID tenantId;
    private static final ClientLogger LOGGER = new ClientLogger(ServerAdministratorProperties.class);

    public AdministratorType administratorType() {
        return this.administratorType;
    }

    public ServerAdministratorProperties withAdministratorType(AdministratorType administratorType) {
        this.administratorType = administratorType;
        return this;
    }

    public String login() {
        return this.login;
    }

    public ServerAdministratorProperties withLogin(String login) {
        this.login = login;
        return this;
    }

    public UUID sid() {
        return this.sid;
    }

    public ServerAdministratorProperties withSid(UUID sid) {
        this.sid = sid;
        return this;
    }

    public UUID tenantId() {
        return this.tenantId;
    }

    public ServerAdministratorProperties withTenantId(UUID tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public void validate() {
        if (this.administratorType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property administratorType in model ServerAdministratorProperties"));
        }
        if (this.login() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property login in model ServerAdministratorProperties"));
        }
        if (this.sid() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sid in model ServerAdministratorProperties"));
        }
        if (this.tenantId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenantId in model ServerAdministratorProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("administratorType", this.administratorType == null ? null : this.administratorType.toString());
        jsonWriter.writeStringField("login", this.login);
        jsonWriter.writeStringField("sid", Objects.toString(this.sid, null));
        jsonWriter.writeStringField("tenantId", Objects.toString(this.tenantId, null));
        return jsonWriter.writeEndObject();
    }

    public static ServerAdministratorProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ServerAdministratorProperties)jsonReader.readObject(reader -> {
            ServerAdministratorProperties deserializedServerAdministratorProperties = new ServerAdministratorProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("administratorType".equals(fieldName)) {
                    deserializedServerAdministratorProperties.administratorType = AdministratorType.fromString(reader.getString());
                    continue;
                }
                if ("login".equals(fieldName)) {
                    deserializedServerAdministratorProperties.login = reader.getString();
                    continue;
                }
                if ("sid".equals(fieldName)) {
                    deserializedServerAdministratorProperties.sid = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                if ("tenantId".equals(fieldName)) {
                    deserializedServerAdministratorProperties.tenantId = (UUID)reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerAdministratorProperties;
        });
    }
}

