/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.rds.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.rds.model.DBSecurityGroupNameListCopier;
import software.amazon.awssdk.services.rds.model.DatabaseInsightsMode;
import software.amazon.awssdk.services.rds.model.LogTypeListCopier;
import software.amazon.awssdk.services.rds.model.ProcessorFeature;
import software.amazon.awssdk.services.rds.model.ProcessorFeatureListCopier;
import software.amazon.awssdk.services.rds.model.RdsRequest;
import software.amazon.awssdk.services.rds.model.Tag;
import software.amazon.awssdk.services.rds.model.TagListCopier;
import software.amazon.awssdk.services.rds.model.VpcSecurityGroupIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreDbInstanceFromS3Request
extends RdsRequest
implements ToCopyableBuilder<Builder, RestoreDbInstanceFromS3Request> {
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBName").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbName)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()}).build();
    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceIdentifier").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbInstanceIdentifier)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbInstanceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build()}).build();
    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AllocatedStorage").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::allocatedStorage)).setter(RestoreDbInstanceFromS3Request.setter(Builder::allocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()}).build();
    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBInstanceClass").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbInstanceClass)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbInstanceClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::engine)).setter(RestoreDbInstanceFromS3Request.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::masterUsername)).setter(RestoreDbInstanceFromS3Request.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserPassword").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::masterUserPassword)).setter(RestoreDbInstanceFromS3Request.setter(Builder::masterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserPassword").build()}).build();
    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DBSecurityGroups").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbSecurityGroups)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroups").build(), ListTrait.builder().memberLocationName("DBSecurityGroupName").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSecurityGroupName").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroupIds").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::vpcSecurityGroupIds)).setter(RestoreDbInstanceFromS3Request.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName("VpcSecurityGroupId").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroupId").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::availabilityZone)).setter(RestoreDbInstanceFromS3Request.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> DB_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBSubnetGroupName").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbSubnetGroupName)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBSubnetGroupName").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::preferredMaintenanceWindow)).setter(RestoreDbInstanceFromS3Request.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<String> DB_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBParameterGroupName").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dbParameterGroupName)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dbParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroupName").build()}).build();
    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BackupRetentionPeriod").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::backupRetentionPeriod)).setter(RestoreDbInstanceFromS3Request.setter(Builder::backupRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build()}).build();
    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredBackupWindow").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::preferredBackupWindow)).setter(RestoreDbInstanceFromS3Request.setter(Builder::preferredBackupWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build()}).build();
    private static final SdkField<Integer> PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Port").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::port)).setter(RestoreDbInstanceFromS3Request.setter(Builder::port)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Port").build()}).build();
    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("MultiAZ").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::multiAZ)).setter(RestoreDbInstanceFromS3Request.setter(Builder::multiAZ)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAZ").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::engineVersion)).setter(RestoreDbInstanceFromS3Request.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::autoMinorVersionUpgrade)).setter(RestoreDbInstanceFromS3Request.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LicenseModel").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::licenseModel)).setter(RestoreDbInstanceFromS3Request.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()}).build();
    private static final SdkField<Integer> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Iops").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::iops)).setter(RestoreDbInstanceFromS3Request.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()}).build();
    private static final SdkField<String> OPTION_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OptionGroupName").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::optionGroupName)).setter(RestoreDbInstanceFromS3Request.setter(Builder::optionGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupName").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::publiclyAccessible)).setter(RestoreDbInstanceFromS3Request.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::tags)).setter(RestoreDbInstanceFromS3Request.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageType").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::storageType)).setter(RestoreDbInstanceFromS3Request.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()}).build();
    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("StorageEncrypted").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::storageEncrypted)).setter(RestoreDbInstanceFromS3Request.setter(Builder::storageEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::kmsKeyId)).setter(RestoreDbInstanceFromS3Request.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTagsToSnapshot").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::copyTagsToSnapshot)).setter(RestoreDbInstanceFromS3Request.setter(Builder::copyTagsToSnapshot)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build()}).build();
    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MonitoringInterval").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::monitoringInterval)).setter(RestoreDbInstanceFromS3Request.setter(Builder::monitoringInterval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build()}).build();
    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringRoleArn").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::monitoringRoleArn)).setter(RestoreDbInstanceFromS3Request.setter(Builder::monitoringRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()}).build();
    private static final SdkField<Boolean> ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableIAMDatabaseAuthentication").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::enableIAMDatabaseAuthentication)).setter(RestoreDbInstanceFromS3Request.setter(Builder::enableIAMDatabaseAuthentication)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableIAMDatabaseAuthentication").build()}).build();
    private static final SdkField<String> SOURCE_ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEngine").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::sourceEngine)).setter(RestoreDbInstanceFromS3Request.setter(Builder::sourceEngine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngine").build()}).build();
    private static final SdkField<String> SOURCE_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceEngineVersion").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::sourceEngineVersion)).setter(RestoreDbInstanceFromS3Request.setter(Builder::sourceEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEngineVersion").build()}).build();
    private static final SdkField<String> S3_BUCKET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3BucketName").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::s3BucketName)).setter(RestoreDbInstanceFromS3Request.setter(Builder::s3BucketName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3BucketName").build()}).build();
    private static final SdkField<String> S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3Prefix").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::s3Prefix)).setter(RestoreDbInstanceFromS3Request.setter(Builder::s3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3Prefix").build()}).build();
    private static final SdkField<String> S3_INGESTION_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3IngestionRoleArn").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::s3IngestionRoleArn)).setter(RestoreDbInstanceFromS3Request.setter(Builder::s3IngestionRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3IngestionRoleArn").build()}).build();
    private static final SdkField<String> DATABASE_INSIGHTS_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseInsightsMode").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::databaseInsightsModeAsString)).setter(RestoreDbInstanceFromS3Request.setter(Builder::databaseInsightsMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseInsightsMode").build()}).build();
    private static final SdkField<Boolean> ENABLE_PERFORMANCE_INSIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnablePerformanceInsights").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::enablePerformanceInsights)).setter(RestoreDbInstanceFromS3Request.setter(Builder::enablePerformanceInsights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnablePerformanceInsights").build()}).build();
    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PerformanceInsightsKMSKeyId").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::performanceInsightsKMSKeyId)).setter(RestoreDbInstanceFromS3Request.setter(Builder::performanceInsightsKMSKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKMSKeyId").build()}).build();
    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PerformanceInsightsRetentionPeriod").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::performanceInsightsRetentionPeriod)).setter(RestoreDbInstanceFromS3Request.setter(Builder::performanceInsightsRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod").build()}).build();
    private static final SdkField<List<String>> ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EnableCloudwatchLogsExports").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::enableCloudwatchLogsExports)).setter(RestoreDbInstanceFromS3Request.setter(Builder::enableCloudwatchLogsExports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableCloudwatchLogsExports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProcessorFeatures").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::processorFeatures)).setter(RestoreDbInstanceFromS3Request.setter(Builder::processorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(), ListTrait.builder().memberLocationName("ProcessorFeature").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProcessorFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeature").build()}).build()).build()}).build();
    private static final SdkField<Boolean> USE_DEFAULT_PROCESSOR_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseDefaultProcessorFeatures").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::useDefaultProcessorFeatures)).setter(RestoreDbInstanceFromS3Request.setter(Builder::useDefaultProcessorFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseDefaultProcessorFeatures").build()}).build();
    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeletionProtection").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::deletionProtection)).setter(RestoreDbInstanceFromS3Request.setter(Builder::deletionProtection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build()}).build();
    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAllocatedStorage").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::maxAllocatedStorage)).setter(RestoreDbInstanceFromS3Request.setter(Builder::maxAllocatedStorage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::networkType)).setter(RestoreDbInstanceFromS3Request.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<Integer> STORAGE_THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("StorageThroughput").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::storageThroughput)).setter(RestoreDbInstanceFromS3Request.setter(Builder::storageThroughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageThroughput").build()}).build();
    private static final SdkField<Boolean> MANAGE_MASTER_USER_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ManageMasterUserPassword").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::manageMasterUserPassword)).setter(RestoreDbInstanceFromS3Request.setter(Builder::manageMasterUserPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManageMasterUserPassword").build()}).build();
    private static final SdkField<String> MASTER_USER_SECRET_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUserSecretKmsKeyId").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::masterUserSecretKmsKeyId)).setter(RestoreDbInstanceFromS3Request.setter(Builder::masterUserSecretKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUserSecretKmsKeyId").build()}).build();
    private static final SdkField<Boolean> DEDICATED_LOG_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DedicatedLogVolume").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::dedicatedLogVolume)).setter(RestoreDbInstanceFromS3Request.setter(Builder::dedicatedLogVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DedicatedLogVolume").build()}).build();
    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CACertificateIdentifier").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::caCertificateIdentifier)).setter(RestoreDbInstanceFromS3Request.setter(Builder::caCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build()}).build();
    private static final SdkField<String> ENGINE_LIFECYCLE_SUPPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineLifecycleSupport").getter(RestoreDbInstanceFromS3Request.getter(RestoreDbInstanceFromS3Request::engineLifecycleSupport)).setter(RestoreDbInstanceFromS3Request.setter(Builder::engineLifecycleSupport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineLifecycleSupport").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DB_NAME_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, ALLOCATED_STORAGE_FIELD, DB_INSTANCE_CLASS_FIELD, ENGINE_FIELD, MASTER_USERNAME_FIELD, MASTER_USER_PASSWORD_FIELD, DB_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD, AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_NAME_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, DB_PARAMETER_GROUP_NAME_FIELD, BACKUP_RETENTION_PERIOD_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, PORT_FIELD, MULTI_AZ_FIELD, ENGINE_VERSION_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, LICENSE_MODEL_FIELD, IOPS_FIELD, OPTION_GROUP_NAME_FIELD, PUBLICLY_ACCESSIBLE_FIELD, TAGS_FIELD, STORAGE_TYPE_FIELD, STORAGE_ENCRYPTED_FIELD, KMS_KEY_ID_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD, MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD, SOURCE_ENGINE_FIELD, SOURCE_ENGINE_VERSION_FIELD, S3_BUCKET_NAME_FIELD, S3_PREFIX_FIELD, S3_INGESTION_ROLE_ARN_FIELD, DATABASE_INSIGHTS_MODE_FIELD, ENABLE_PERFORMANCE_INSIGHTS_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD, PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD, USE_DEFAULT_PROCESSOR_FEATURES_FIELD, DELETION_PROTECTION_FIELD, MAX_ALLOCATED_STORAGE_FIELD, NETWORK_TYPE_FIELD, STORAGE_THROUGHPUT_FIELD, MANAGE_MASTER_USER_PASSWORD_FIELD, MASTER_USER_SECRET_KMS_KEY_ID_FIELD, DEDICATED_LOG_VOLUME_FIELD, CA_CERTIFICATE_IDENTIFIER_FIELD, ENGINE_LIFECYCLE_SUPPORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RestoreDbInstanceFromS3Request.memberNameToFieldInitializer();
    private final String dbName;
    private final String dbInstanceIdentifier;
    private final Integer allocatedStorage;
    private final String dbInstanceClass;
    private final String engine;
    private final String masterUsername;
    private final String masterUserPassword;
    private final List<String> dbSecurityGroups;
    private final List<String> vpcSecurityGroupIds;
    private final String availabilityZone;
    private final String dbSubnetGroupName;
    private final String preferredMaintenanceWindow;
    private final String dbParameterGroupName;
    private final Integer backupRetentionPeriod;
    private final String preferredBackupWindow;
    private final Integer port;
    private final Boolean multiAZ;
    private final String engineVersion;
    private final Boolean autoMinorVersionUpgrade;
    private final String licenseModel;
    private final Integer iops;
    private final String optionGroupName;
    private final Boolean publiclyAccessible;
    private final List<Tag> tags;
    private final String storageType;
    private final Boolean storageEncrypted;
    private final String kmsKeyId;
    private final Boolean copyTagsToSnapshot;
    private final Integer monitoringInterval;
    private final String monitoringRoleArn;
    private final Boolean enableIAMDatabaseAuthentication;
    private final String sourceEngine;
    private final String sourceEngineVersion;
    private final String s3BucketName;
    private final String s3Prefix;
    private final String s3IngestionRoleArn;
    private final String databaseInsightsMode;
    private final Boolean enablePerformanceInsights;
    private final String performanceInsightsKMSKeyId;
    private final Integer performanceInsightsRetentionPeriod;
    private final List<String> enableCloudwatchLogsExports;
    private final List<ProcessorFeature> processorFeatures;
    private final Boolean useDefaultProcessorFeatures;
    private final Boolean deletionProtection;
    private final Integer maxAllocatedStorage;
    private final String networkType;
    private final Integer storageThroughput;
    private final Boolean manageMasterUserPassword;
    private final String masterUserSecretKmsKeyId;
    private final Boolean dedicatedLogVolume;
    private final String caCertificateIdentifier;
    private final String engineLifecycleSupport;

    private RestoreDbInstanceFromS3Request(BuilderImpl builder) {
        super(builder);
        this.dbName = builder.dbName;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.allocatedStorage = builder.allocatedStorage;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.engine = builder.engine;
        this.masterUsername = builder.masterUsername;
        this.masterUserPassword = builder.masterUserPassword;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroupName = builder.dbSubnetGroupName;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.dbParameterGroupName = builder.dbParameterGroupName;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.port = builder.port;
        this.multiAZ = builder.multiAZ;
        this.engineVersion = builder.engineVersion;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupName = builder.optionGroupName;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.tags = builder.tags;
        this.storageType = builder.storageType;
        this.storageEncrypted = builder.storageEncrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.enableIAMDatabaseAuthentication = builder.enableIAMDatabaseAuthentication;
        this.sourceEngine = builder.sourceEngine;
        this.sourceEngineVersion = builder.sourceEngineVersion;
        this.s3BucketName = builder.s3BucketName;
        this.s3Prefix = builder.s3Prefix;
        this.s3IngestionRoleArn = builder.s3IngestionRoleArn;
        this.databaseInsightsMode = builder.databaseInsightsMode;
        this.enablePerformanceInsights = builder.enablePerformanceInsights;
        this.performanceInsightsKMSKeyId = builder.performanceInsightsKMSKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enableCloudwatchLogsExports = builder.enableCloudwatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.useDefaultProcessorFeatures = builder.useDefaultProcessorFeatures;
        this.deletionProtection = builder.deletionProtection;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
        this.networkType = builder.networkType;
        this.storageThroughput = builder.storageThroughput;
        this.manageMasterUserPassword = builder.manageMasterUserPassword;
        this.masterUserSecretKmsKeyId = builder.masterUserSecretKmsKeyId;
        this.dedicatedLogVolume = builder.dedicatedLogVolume;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.engineLifecycleSupport = builder.engineLifecycleSupport;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final String dbInstanceIdentifier() {
        return this.dbInstanceIdentifier;
    }

    public final Integer allocatedStorage() {
        return this.allocatedStorage;
    }

    public final String dbInstanceClass() {
        return this.dbInstanceClass;
    }

    public final String engine() {
        return this.engine;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String masterUserPassword() {
        return this.masterUserPassword;
    }

    public final boolean hasDbSecurityGroups() {
        return this.dbSecurityGroups != null && !(this.dbSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<String> dbSecurityGroups() {
        return this.dbSecurityGroups;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String dbSubnetGroupName() {
        return this.dbSubnetGroupName;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final String dbParameterGroupName() {
        return this.dbParameterGroupName;
    }

    public final Integer backupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public final String preferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public final Integer port() {
        return this.port;
    }

    public final Boolean multiAZ() {
        return this.multiAZ;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final String licenseModel() {
        return this.licenseModel;
    }

    public final Integer iops() {
        return this.iops;
    }

    public final String optionGroupName() {
        return this.optionGroupName;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String storageType() {
        return this.storageType;
    }

    public final Boolean storageEncrypted() {
        return this.storageEncrypted;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean copyTagsToSnapshot() {
        return this.copyTagsToSnapshot;
    }

    public final Integer monitoringInterval() {
        return this.monitoringInterval;
    }

    public final String monitoringRoleArn() {
        return this.monitoringRoleArn;
    }

    public final Boolean enableIAMDatabaseAuthentication() {
        return this.enableIAMDatabaseAuthentication;
    }

    public final String sourceEngine() {
        return this.sourceEngine;
    }

    public final String sourceEngineVersion() {
        return this.sourceEngineVersion;
    }

    public final String s3BucketName() {
        return this.s3BucketName;
    }

    public final String s3Prefix() {
        return this.s3Prefix;
    }

    public final String s3IngestionRoleArn() {
        return this.s3IngestionRoleArn;
    }

    public final DatabaseInsightsMode databaseInsightsMode() {
        return DatabaseInsightsMode.fromValue(this.databaseInsightsMode);
    }

    public final String databaseInsightsModeAsString() {
        return this.databaseInsightsMode;
    }

    public final Boolean enablePerformanceInsights() {
        return this.enablePerformanceInsights;
    }

    public final String performanceInsightsKMSKeyId() {
        return this.performanceInsightsKMSKeyId;
    }

    public final Integer performanceInsightsRetentionPeriod() {
        return this.performanceInsightsRetentionPeriod;
    }

    public final boolean hasEnableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports != null && !(this.enableCloudwatchLogsExports instanceof SdkAutoConstructList);
    }

    public final List<String> enableCloudwatchLogsExports() {
        return this.enableCloudwatchLogsExports;
    }

    public final boolean hasProcessorFeatures() {
        return this.processorFeatures != null && !(this.processorFeatures instanceof SdkAutoConstructList);
    }

    public final List<ProcessorFeature> processorFeatures() {
        return this.processorFeatures;
    }

    public final Boolean useDefaultProcessorFeatures() {
        return this.useDefaultProcessorFeatures;
    }

    public final Boolean deletionProtection() {
        return this.deletionProtection;
    }

    public final Integer maxAllocatedStorage() {
        return this.maxAllocatedStorage;
    }

    public final String networkType() {
        return this.networkType;
    }

    public final Integer storageThroughput() {
        return this.storageThroughput;
    }

    public final Boolean manageMasterUserPassword() {
        return this.manageMasterUserPassword;
    }

    public final String masterUserSecretKmsKeyId() {
        return this.masterUserSecretKmsKeyId;
    }

    public final Boolean dedicatedLogVolume() {
        return this.dedicatedLogVolume;
    }

    public final String caCertificateIdentifier() {
        return this.caCertificateIdentifier;
    }

    public final String engineLifecycleSupport() {
        return this.engineLifecycleSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.port());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiAZ());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.optionGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.storageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableIAMDatabaseAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngine());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3BucketName());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3IngestionRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseInsightsModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.enablePerformanceInsights());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsKMSKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProcessorFeatures() ? this.processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.useDefaultProcessorFeatures());
        hashCode = 31 * hashCode + Objects.hashCode(this.deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAllocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkType());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageThroughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageMasterUserPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUserSecretKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dedicatedLogVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineLifecycleSupport());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreDbInstanceFromS3Request)) {
            return false;
        }
        RestoreDbInstanceFromS3Request other = (RestoreDbInstanceFromS3Request)((Object)obj);
        return Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.dbInstanceIdentifier(), other.dbInstanceIdentifier()) && Objects.equals(this.allocatedStorage(), other.allocatedStorage()) && Objects.equals(this.dbInstanceClass(), other.dbInstanceClass()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.masterUserPassword(), other.masterUserPassword()) && this.hasDbSecurityGroups() == other.hasDbSecurityGroups() && Objects.equals(this.dbSecurityGroups(), other.dbSecurityGroups()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.dbSubnetGroupName(), other.dbSubnetGroupName()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.dbParameterGroupName(), other.dbParameterGroupName()) && Objects.equals(this.backupRetentionPeriod(), other.backupRetentionPeriod()) && Objects.equals(this.preferredBackupWindow(), other.preferredBackupWindow()) && Objects.equals(this.port(), other.port()) && Objects.equals(this.multiAZ(), other.multiAZ()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.licenseModel(), other.licenseModel()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.optionGroupName(), other.optionGroupName()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.storageType(), other.storageType()) && Objects.equals(this.storageEncrypted(), other.storageEncrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.copyTagsToSnapshot(), other.copyTagsToSnapshot()) && Objects.equals(this.monitoringInterval(), other.monitoringInterval()) && Objects.equals(this.monitoringRoleArn(), other.monitoringRoleArn()) && Objects.equals(this.enableIAMDatabaseAuthentication(), other.enableIAMDatabaseAuthentication()) && Objects.equals(this.sourceEngine(), other.sourceEngine()) && Objects.equals(this.sourceEngineVersion(), other.sourceEngineVersion()) && Objects.equals(this.s3BucketName(), other.s3BucketName()) && Objects.equals(this.s3Prefix(), other.s3Prefix()) && Objects.equals(this.s3IngestionRoleArn(), other.s3IngestionRoleArn()) && Objects.equals(this.databaseInsightsModeAsString(), other.databaseInsightsModeAsString()) && Objects.equals(this.enablePerformanceInsights(), other.enablePerformanceInsights()) && Objects.equals(this.performanceInsightsKMSKeyId(), other.performanceInsightsKMSKeyId()) && Objects.equals(this.performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod()) && this.hasEnableCloudwatchLogsExports() == other.hasEnableCloudwatchLogsExports() && Objects.equals(this.enableCloudwatchLogsExports(), other.enableCloudwatchLogsExports()) && this.hasProcessorFeatures() == other.hasProcessorFeatures() && Objects.equals(this.processorFeatures(), other.processorFeatures()) && Objects.equals(this.useDefaultProcessorFeatures(), other.useDefaultProcessorFeatures()) && Objects.equals(this.deletionProtection(), other.deletionProtection()) && Objects.equals(this.maxAllocatedStorage(), other.maxAllocatedStorage()) && Objects.equals(this.networkType(), other.networkType()) && Objects.equals(this.storageThroughput(), other.storageThroughput()) && Objects.equals(this.manageMasterUserPassword(), other.manageMasterUserPassword()) && Objects.equals(this.masterUserSecretKmsKeyId(), other.masterUserSecretKmsKeyId()) && Objects.equals(this.dedicatedLogVolume(), other.dedicatedLogVolume()) && Objects.equals(this.caCertificateIdentifier(), other.caCertificateIdentifier()) && Objects.equals(this.engineLifecycleSupport(), other.engineLifecycleSupport());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreDbInstanceFromS3Request").add("DBName", (Object)this.dbName()).add("DBInstanceIdentifier", (Object)this.dbInstanceIdentifier()).add("AllocatedStorage", (Object)this.allocatedStorage()).add("DBInstanceClass", (Object)this.dbInstanceClass()).add("Engine", (Object)this.engine()).add("MasterUsername", (Object)this.masterUsername()).add("MasterUserPassword", (Object)this.masterUserPassword()).add("DBSecurityGroups", this.hasDbSecurityGroups() ? this.dbSecurityGroups() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).add("AvailabilityZone", (Object)this.availabilityZone()).add("DBSubnetGroupName", (Object)this.dbSubnetGroupName()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("DBParameterGroupName", (Object)this.dbParameterGroupName()).add("BackupRetentionPeriod", (Object)this.backupRetentionPeriod()).add("PreferredBackupWindow", (Object)this.preferredBackupWindow()).add("Port", (Object)this.port()).add("MultiAZ", (Object)this.multiAZ()).add("EngineVersion", (Object)this.engineVersion()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("LicenseModel", (Object)this.licenseModel()).add("Iops", (Object)this.iops()).add("OptionGroupName", (Object)this.optionGroupName()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Tags", this.hasTags() ? this.tags() : null).add("StorageType", (Object)this.storageType()).add("StorageEncrypted", (Object)this.storageEncrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("CopyTagsToSnapshot", (Object)this.copyTagsToSnapshot()).add("MonitoringInterval", (Object)this.monitoringInterval()).add("MonitoringRoleArn", (Object)this.monitoringRoleArn()).add("EnableIAMDatabaseAuthentication", (Object)this.enableIAMDatabaseAuthentication()).add("SourceEngine", (Object)this.sourceEngine()).add("SourceEngineVersion", (Object)this.sourceEngineVersion()).add("S3BucketName", (Object)this.s3BucketName()).add("S3Prefix", (Object)this.s3Prefix()).add("S3IngestionRoleArn", (Object)this.s3IngestionRoleArn()).add("DatabaseInsightsMode", (Object)this.databaseInsightsModeAsString()).add("EnablePerformanceInsights", (Object)this.enablePerformanceInsights()).add("PerformanceInsightsKMSKeyId", (Object)this.performanceInsightsKMSKeyId()).add("PerformanceInsightsRetentionPeriod", (Object)this.performanceInsightsRetentionPeriod()).add("EnableCloudwatchLogsExports", this.hasEnableCloudwatchLogsExports() ? this.enableCloudwatchLogsExports() : null).add("ProcessorFeatures", this.hasProcessorFeatures() ? this.processorFeatures() : null).add("UseDefaultProcessorFeatures", (Object)this.useDefaultProcessorFeatures()).add("DeletionProtection", (Object)this.deletionProtection()).add("MaxAllocatedStorage", (Object)this.maxAllocatedStorage()).add("NetworkType", (Object)this.networkType()).add("StorageThroughput", (Object)this.storageThroughput()).add("ManageMasterUserPassword", (Object)this.manageMasterUserPassword()).add("MasterUserSecretKmsKeyId", (Object)this.masterUserSecretKmsKeyId()).add("DedicatedLogVolume", (Object)this.dedicatedLogVolume()).add("CACertificateIdentifier", (Object)this.caCertificateIdentifier()).add("EngineLifecycleSupport", (Object)this.engineLifecycleSupport()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "DBInstanceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceIdentifier()));
            }
            case "AllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.allocatedStorage()));
            }
            case "DBInstanceClass": {
                return Optional.ofNullable(clazz.cast(this.dbInstanceClass()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "MasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.masterUserPassword()));
            }
            case "DBSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.dbSecurityGroups()));
            }
            case "VpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "DBSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbSubnetGroupName()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "DBParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.dbParameterGroupName()));
            }
            case "BackupRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.backupRetentionPeriod()));
            }
            case "PreferredBackupWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredBackupWindow()));
            }
            case "Port": {
                return Optional.ofNullable(clazz.cast(this.port()));
            }
            case "MultiAZ": {
                return Optional.ofNullable(clazz.cast(this.multiAZ()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "LicenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModel()));
            }
            case "Iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "OptionGroupName": {
                return Optional.ofNullable(clazz.cast(this.optionGroupName()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "StorageType": {
                return Optional.ofNullable(clazz.cast(this.storageType()));
            }
            case "StorageEncrypted": {
                return Optional.ofNullable(clazz.cast(this.storageEncrypted()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "CopyTagsToSnapshot": {
                return Optional.ofNullable(clazz.cast(this.copyTagsToSnapshot()));
            }
            case "MonitoringInterval": {
                return Optional.ofNullable(clazz.cast(this.monitoringInterval()));
            }
            case "MonitoringRoleArn": {
                return Optional.ofNullable(clazz.cast(this.monitoringRoleArn()));
            }
            case "EnableIAMDatabaseAuthentication": {
                return Optional.ofNullable(clazz.cast(this.enableIAMDatabaseAuthentication()));
            }
            case "SourceEngine": {
                return Optional.ofNullable(clazz.cast(this.sourceEngine()));
            }
            case "SourceEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.sourceEngineVersion()));
            }
            case "S3BucketName": {
                return Optional.ofNullable(clazz.cast(this.s3BucketName()));
            }
            case "S3Prefix": {
                return Optional.ofNullable(clazz.cast(this.s3Prefix()));
            }
            case "S3IngestionRoleArn": {
                return Optional.ofNullable(clazz.cast(this.s3IngestionRoleArn()));
            }
            case "DatabaseInsightsMode": {
                return Optional.ofNullable(clazz.cast(this.databaseInsightsModeAsString()));
            }
            case "EnablePerformanceInsights": {
                return Optional.ofNullable(clazz.cast(this.enablePerformanceInsights()));
            }
            case "PerformanceInsightsKMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsKMSKeyId()));
            }
            case "PerformanceInsightsRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.performanceInsightsRetentionPeriod()));
            }
            case "EnableCloudwatchLogsExports": {
                return Optional.ofNullable(clazz.cast(this.enableCloudwatchLogsExports()));
            }
            case "ProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.processorFeatures()));
            }
            case "UseDefaultProcessorFeatures": {
                return Optional.ofNullable(clazz.cast(this.useDefaultProcessorFeatures()));
            }
            case "DeletionProtection": {
                return Optional.ofNullable(clazz.cast(this.deletionProtection()));
            }
            case "MaxAllocatedStorage": {
                return Optional.ofNullable(clazz.cast(this.maxAllocatedStorage()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkType()));
            }
            case "StorageThroughput": {
                return Optional.ofNullable(clazz.cast(this.storageThroughput()));
            }
            case "ManageMasterUserPassword": {
                return Optional.ofNullable(clazz.cast(this.manageMasterUserPassword()));
            }
            case "MasterUserSecretKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.masterUserSecretKmsKeyId()));
            }
            case "DedicatedLogVolume": {
                return Optional.ofNullable(clazz.cast(this.dedicatedLogVolume()));
            }
            case "CACertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.caCertificateIdentifier()));
            }
            case "EngineLifecycleSupport": {
                return Optional.ofNullable(clazz.cast(this.engineLifecycleSupport()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DBName", DB_NAME_FIELD);
        map.put("DBInstanceIdentifier", DB_INSTANCE_IDENTIFIER_FIELD);
        map.put("AllocatedStorage", ALLOCATED_STORAGE_FIELD);
        map.put("DBInstanceClass", DB_INSTANCE_CLASS_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("MasterUsername", MASTER_USERNAME_FIELD);
        map.put("MasterUserPassword", MASTER_USER_PASSWORD_FIELD);
        map.put("DBSecurityGroups", DB_SECURITY_GROUPS_FIELD);
        map.put("VpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("DBSubnetGroupName", DB_SUBNET_GROUP_NAME_FIELD);
        map.put("PreferredMaintenanceWindow", PREFERRED_MAINTENANCE_WINDOW_FIELD);
        map.put("DBParameterGroupName", DB_PARAMETER_GROUP_NAME_FIELD);
        map.put("BackupRetentionPeriod", BACKUP_RETENTION_PERIOD_FIELD);
        map.put("PreferredBackupWindow", PREFERRED_BACKUP_WINDOW_FIELD);
        map.put("Port", PORT_FIELD);
        map.put("MultiAZ", MULTI_AZ_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("LicenseModel", LICENSE_MODEL_FIELD);
        map.put("Iops", IOPS_FIELD);
        map.put("OptionGroupName", OPTION_GROUP_NAME_FIELD);
        map.put("PubliclyAccessible", PUBLICLY_ACCESSIBLE_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageEncrypted", STORAGE_ENCRYPTED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("CopyTagsToSnapshot", COPY_TAGS_TO_SNAPSHOT_FIELD);
        map.put("MonitoringInterval", MONITORING_INTERVAL_FIELD);
        map.put("MonitoringRoleArn", MONITORING_ROLE_ARN_FIELD);
        map.put("EnableIAMDatabaseAuthentication", ENABLE_IAM_DATABASE_AUTHENTICATION_FIELD);
        map.put("SourceEngine", SOURCE_ENGINE_FIELD);
        map.put("SourceEngineVersion", SOURCE_ENGINE_VERSION_FIELD);
        map.put("S3BucketName", S3_BUCKET_NAME_FIELD);
        map.put("S3Prefix", S3_PREFIX_FIELD);
        map.put("S3IngestionRoleArn", S3_INGESTION_ROLE_ARN_FIELD);
        map.put("DatabaseInsightsMode", DATABASE_INSIGHTS_MODE_FIELD);
        map.put("EnablePerformanceInsights", ENABLE_PERFORMANCE_INSIGHTS_FIELD);
        map.put("PerformanceInsightsKMSKeyId", PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD);
        map.put("PerformanceInsightsRetentionPeriod", PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD);
        map.put("EnableCloudwatchLogsExports", ENABLE_CLOUDWATCH_LOGS_EXPORTS_FIELD);
        map.put("ProcessorFeatures", PROCESSOR_FEATURES_FIELD);
        map.put("UseDefaultProcessorFeatures", USE_DEFAULT_PROCESSOR_FEATURES_FIELD);
        map.put("DeletionProtection", DELETION_PROTECTION_FIELD);
        map.put("MaxAllocatedStorage", MAX_ALLOCATED_STORAGE_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("StorageThroughput", STORAGE_THROUGHPUT_FIELD);
        map.put("ManageMasterUserPassword", MANAGE_MASTER_USER_PASSWORD_FIELD);
        map.put("MasterUserSecretKmsKeyId", MASTER_USER_SECRET_KMS_KEY_ID_FIELD);
        map.put("DedicatedLogVolume", DEDICATED_LOG_VOLUME_FIELD);
        map.put("CACertificateIdentifier", CA_CERTIFICATE_IDENTIFIER_FIELD);
        map.put("EngineLifecycleSupport", ENGINE_LIFECYCLE_SUPPORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreDbInstanceFromS3Request, T> g) {
        return obj -> g.apply((RestoreDbInstanceFromS3Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RdsRequest.BuilderImpl
    implements Builder {
        private String dbName;
        private String dbInstanceIdentifier;
        private Integer allocatedStorage;
        private String dbInstanceClass;
        private String engine;
        private String masterUsername;
        private String masterUserPassword;
        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String availabilityZone;
        private String dbSubnetGroupName;
        private String preferredMaintenanceWindow;
        private String dbParameterGroupName;
        private Integer backupRetentionPeriod;
        private String preferredBackupWindow;
        private Integer port;
        private Boolean multiAZ;
        private String engineVersion;
        private Boolean autoMinorVersionUpgrade;
        private String licenseModel;
        private Integer iops;
        private String optionGroupName;
        private Boolean publiclyAccessible;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String storageType;
        private Boolean storageEncrypted;
        private String kmsKeyId;
        private Boolean copyTagsToSnapshot;
        private Integer monitoringInterval;
        private String monitoringRoleArn;
        private Boolean enableIAMDatabaseAuthentication;
        private String sourceEngine;
        private String sourceEngineVersion;
        private String s3BucketName;
        private String s3Prefix;
        private String s3IngestionRoleArn;
        private String databaseInsightsMode;
        private Boolean enablePerformanceInsights;
        private String performanceInsightsKMSKeyId;
        private Integer performanceInsightsRetentionPeriod;
        private List<String> enableCloudwatchLogsExports = DefaultSdkAutoConstructList.getInstance();
        private List<ProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();
        private Boolean useDefaultProcessorFeatures;
        private Boolean deletionProtection;
        private Integer maxAllocatedStorage;
        private String networkType;
        private Integer storageThroughput;
        private Boolean manageMasterUserPassword;
        private String masterUserSecretKmsKeyId;
        private Boolean dedicatedLogVolume;
        private String caCertificateIdentifier;
        private String engineLifecycleSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreDbInstanceFromS3Request model) {
            super(model);
            this.dbName(model.dbName);
            this.dbInstanceIdentifier(model.dbInstanceIdentifier);
            this.allocatedStorage(model.allocatedStorage);
            this.dbInstanceClass(model.dbInstanceClass);
            this.engine(model.engine);
            this.masterUsername(model.masterUsername);
            this.masterUserPassword(model.masterUserPassword);
            this.dbSecurityGroups(model.dbSecurityGroups);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
            this.availabilityZone(model.availabilityZone);
            this.dbSubnetGroupName(model.dbSubnetGroupName);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.dbParameterGroupName(model.dbParameterGroupName);
            this.backupRetentionPeriod(model.backupRetentionPeriod);
            this.preferredBackupWindow(model.preferredBackupWindow);
            this.port(model.port);
            this.multiAZ(model.multiAZ);
            this.engineVersion(model.engineVersion);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.licenseModel(model.licenseModel);
            this.iops(model.iops);
            this.optionGroupName(model.optionGroupName);
            this.publiclyAccessible(model.publiclyAccessible);
            this.tags(model.tags);
            this.storageType(model.storageType);
            this.storageEncrypted(model.storageEncrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.copyTagsToSnapshot(model.copyTagsToSnapshot);
            this.monitoringInterval(model.monitoringInterval);
            this.monitoringRoleArn(model.monitoringRoleArn);
            this.enableIAMDatabaseAuthentication(model.enableIAMDatabaseAuthentication);
            this.sourceEngine(model.sourceEngine);
            this.sourceEngineVersion(model.sourceEngineVersion);
            this.s3BucketName(model.s3BucketName);
            this.s3Prefix(model.s3Prefix);
            this.s3IngestionRoleArn(model.s3IngestionRoleArn);
            this.databaseInsightsMode(model.databaseInsightsMode);
            this.enablePerformanceInsights(model.enablePerformanceInsights);
            this.performanceInsightsKMSKeyId(model.performanceInsightsKMSKeyId);
            this.performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            this.enableCloudwatchLogsExports(model.enableCloudwatchLogsExports);
            this.processorFeatures(model.processorFeatures);
            this.useDefaultProcessorFeatures(model.useDefaultProcessorFeatures);
            this.deletionProtection(model.deletionProtection);
            this.maxAllocatedStorage(model.maxAllocatedStorage);
            this.networkType(model.networkType);
            this.storageThroughput(model.storageThroughput);
            this.manageMasterUserPassword(model.manageMasterUserPassword);
            this.masterUserSecretKmsKeyId(model.masterUserSecretKmsKeyId);
            this.dedicatedLogVolume(model.dedicatedLogVolume);
            this.caCertificateIdentifier(model.caCertificateIdentifier);
            this.engineLifecycleSupport(model.engineLifecycleSupport);
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return this.dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return this.allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getDbInstanceClass() {
            return this.dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getMasterUserPassword() {
            return this.masterUserPassword;
        }

        public final void setMasterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
        }

        @Override
        public final Builder masterUserPassword(String masterUserPassword) {
            this.masterUserPassword = masterUserPassword;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (this.dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = DBSecurityGroupNameListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String ... dbSecurityGroups) {
            this.dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = VpcSecurityGroupIdListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getDbSubnetGroupName() {
            return this.dbSubnetGroupName;
        }

        public final void setDbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
        }

        @Override
        public final Builder dbSubnetGroupName(String dbSubnetGroupName) {
            this.dbSubnetGroupName = dbSubnetGroupName;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final String getDbParameterGroupName() {
            return this.dbParameterGroupName;
        }

        public final void setDbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
        }

        @Override
        public final Builder dbParameterGroupName(String dbParameterGroupName) {
            this.dbParameterGroupName = dbParameterGroupName;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return this.backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return this.preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(Integer port) {
            this.port = port;
        }

        @Override
        public final Builder port(Integer port) {
            this.port = port;
            return this;
        }

        public final Boolean getMultiAZ() {
            return this.multiAZ;
        }

        public final void setMultiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
        }

        @Override
        public final Builder multiAZ(Boolean multiAZ) {
            this.multiAZ = multiAZ;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return this.iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final String getOptionGroupName() {
            return this.optionGroupName;
        }

        public final void setOptionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
        }

        @Override
        public final Builder optionGroupName(String optionGroupName) {
            this.optionGroupName = optionGroupName;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return this.storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return this.copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return this.monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return this.monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Boolean getEnableIAMDatabaseAuthentication() {
            return this.enableIAMDatabaseAuthentication;
        }

        public final void setEnableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
        }

        @Override
        public final Builder enableIAMDatabaseAuthentication(Boolean enableIAMDatabaseAuthentication) {
            this.enableIAMDatabaseAuthentication = enableIAMDatabaseAuthentication;
            return this;
        }

        public final String getSourceEngine() {
            return this.sourceEngine;
        }

        public final void setSourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
        }

        @Override
        public final Builder sourceEngine(String sourceEngine) {
            this.sourceEngine = sourceEngine;
            return this;
        }

        public final String getSourceEngineVersion() {
            return this.sourceEngineVersion;
        }

        public final void setSourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
        }

        @Override
        public final Builder sourceEngineVersion(String sourceEngineVersion) {
            this.sourceEngineVersion = sourceEngineVersion;
            return this;
        }

        public final String getS3BucketName() {
            return this.s3BucketName;
        }

        public final void setS3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
        }

        @Override
        public final Builder s3BucketName(String s3BucketName) {
            this.s3BucketName = s3BucketName;
            return this;
        }

        public final String getS3Prefix() {
            return this.s3Prefix;
        }

        public final void setS3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
        }

        @Override
        public final Builder s3Prefix(String s3Prefix) {
            this.s3Prefix = s3Prefix;
            return this;
        }

        public final String getS3IngestionRoleArn() {
            return this.s3IngestionRoleArn;
        }

        public final void setS3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
        }

        @Override
        public final Builder s3IngestionRoleArn(String s3IngestionRoleArn) {
            this.s3IngestionRoleArn = s3IngestionRoleArn;
            return this;
        }

        public final String getDatabaseInsightsMode() {
            return this.databaseInsightsMode;
        }

        public final void setDatabaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
        }

        @Override
        public final Builder databaseInsightsMode(String databaseInsightsMode) {
            this.databaseInsightsMode = databaseInsightsMode;
            return this;
        }

        @Override
        public final Builder databaseInsightsMode(DatabaseInsightsMode databaseInsightsMode) {
            this.databaseInsightsMode(databaseInsightsMode == null ? null : databaseInsightsMode.toString());
            return this;
        }

        public final Boolean getEnablePerformanceInsights() {
            return this.enablePerformanceInsights;
        }

        public final void setEnablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
        }

        @Override
        public final Builder enablePerformanceInsights(Boolean enablePerformanceInsights) {
            this.enablePerformanceInsights = enablePerformanceInsights;
            return this;
        }

        public final String getPerformanceInsightsKMSKeyId() {
            return this.performanceInsightsKMSKeyId;
        }

        public final void setPerformanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
        }

        @Override
        public final Builder performanceInsightsKMSKeyId(String performanceInsightsKMSKeyId) {
            this.performanceInsightsKMSKeyId = performanceInsightsKMSKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return this.performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnableCloudwatchLogsExports() {
            if (this.enableCloudwatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enableCloudwatchLogsExports;
        }

        public final void setEnableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
        }

        @Override
        public final Builder enableCloudwatchLogsExports(Collection<String> enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports = LogTypeListCopier.copy(enableCloudwatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableCloudwatchLogsExports(String ... enableCloudwatchLogsExports) {
            this.enableCloudwatchLogsExports(Arrays.asList(enableCloudwatchLogsExports));
            return this;
        }

        public final List<ProcessorFeature.Builder> getProcessorFeatures() {
            List<ProcessorFeature.Builder> result = ProcessorFeatureListCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<ProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<ProcessorFeature> processorFeatures) {
            this.processorFeatures = ProcessorFeatureListCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(ProcessorFeature ... processorFeatures) {
            this.processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... processorFeatures) {
            this.processorFeatures(Stream.of(processorFeatures).map(c -> (ProcessorFeature)((ProcessorFeature.Builder)ProcessorFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getUseDefaultProcessorFeatures() {
            return this.useDefaultProcessorFeatures;
        }

        public final void setUseDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
        }

        @Override
        public final Builder useDefaultProcessorFeatures(Boolean useDefaultProcessorFeatures) {
            this.useDefaultProcessorFeatures = useDefaultProcessorFeatures;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return this.deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return this.maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        public final Integer getStorageThroughput() {
            return this.storageThroughput;
        }

        public final void setStorageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
        }

        @Override
        public final Builder storageThroughput(Integer storageThroughput) {
            this.storageThroughput = storageThroughput;
            return this;
        }

        public final Boolean getManageMasterUserPassword() {
            return this.manageMasterUserPassword;
        }

        public final void setManageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
        }

        @Override
        public final Builder manageMasterUserPassword(Boolean manageMasterUserPassword) {
            this.manageMasterUserPassword = manageMasterUserPassword;
            return this;
        }

        public final String getMasterUserSecretKmsKeyId() {
            return this.masterUserSecretKmsKeyId;
        }

        public final void setMasterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
        }

        @Override
        public final Builder masterUserSecretKmsKeyId(String masterUserSecretKmsKeyId) {
            this.masterUserSecretKmsKeyId = masterUserSecretKmsKeyId;
            return this;
        }

        public final Boolean getDedicatedLogVolume() {
            return this.dedicatedLogVolume;
        }

        public final void setDedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
        }

        @Override
        public final Builder dedicatedLogVolume(Boolean dedicatedLogVolume) {
            this.dedicatedLogVolume = dedicatedLogVolume;
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return this.caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getEngineLifecycleSupport() {
            return this.engineLifecycleSupport;
        }

        public final void setEngineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
        }

        @Override
        public final Builder engineLifecycleSupport(String engineLifecycleSupport) {
            this.engineLifecycleSupport = engineLifecycleSupport;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreDbInstanceFromS3Request build() {
            return new RestoreDbInstanceFromS3Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RdsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreDbInstanceFromS3Request> {
        public Builder dbName(String var1);

        public Builder dbInstanceIdentifier(String var1);

        public Builder allocatedStorage(Integer var1);

        public Builder dbInstanceClass(String var1);

        public Builder engine(String var1);

        public Builder masterUsername(String var1);

        public Builder masterUserPassword(String var1);

        public Builder dbSecurityGroups(Collection<String> var1);

        public Builder dbSecurityGroups(String ... var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder availabilityZone(String var1);

        public Builder dbSubnetGroupName(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder dbParameterGroupName(String var1);

        public Builder backupRetentionPeriod(Integer var1);

        public Builder preferredBackupWindow(String var1);

        public Builder port(Integer var1);

        public Builder multiAZ(Boolean var1);

        public Builder engineVersion(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder iops(Integer var1);

        public Builder optionGroupName(String var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder storageType(String var1);

        public Builder storageEncrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder copyTagsToSnapshot(Boolean var1);

        public Builder monitoringInterval(Integer var1);

        public Builder monitoringRoleArn(String var1);

        public Builder enableIAMDatabaseAuthentication(Boolean var1);

        public Builder sourceEngine(String var1);

        public Builder sourceEngineVersion(String var1);

        public Builder s3BucketName(String var1);

        public Builder s3Prefix(String var1);

        public Builder s3IngestionRoleArn(String var1);

        public Builder databaseInsightsMode(String var1);

        public Builder databaseInsightsMode(DatabaseInsightsMode var1);

        public Builder enablePerformanceInsights(Boolean var1);

        public Builder performanceInsightsKMSKeyId(String var1);

        public Builder performanceInsightsRetentionPeriod(Integer var1);

        public Builder enableCloudwatchLogsExports(Collection<String> var1);

        public Builder enableCloudwatchLogsExports(String ... var1);

        public Builder processorFeatures(Collection<ProcessorFeature> var1);

        public Builder processorFeatures(ProcessorFeature ... var1);

        public Builder processorFeatures(Consumer<ProcessorFeature.Builder> ... var1);

        public Builder useDefaultProcessorFeatures(Boolean var1);

        public Builder deletionProtection(Boolean var1);

        public Builder maxAllocatedStorage(Integer var1);

        public Builder networkType(String var1);

        public Builder storageThroughput(Integer var1);

        public Builder manageMasterUserPassword(Boolean var1);

        public Builder masterUserSecretKmsKeyId(String var1);

        public Builder dedicatedLogVolume(Boolean var1);

        public Builder caCertificateIdentifier(String var1);

        public Builder engineLifecycleSupport(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

