/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.spelling.preferences;

import com.dbeaver.ui.editors.spelling.SpellCheckEngine;
import com.dbeaver.ui.editors.spelling.internal.SpellingActivator;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.ui.UIUtils;

public class SpellingConfigurationBlock {
    private static final boolean SUPPORT_CONTENT_ASSIST_PROPOSALS = false;
    private static final String PREF_SPELLING_IGNORE_DIGITS = "spelling_ignore_digits";
    private static final String PREF_SPELLING_IGNORE_MIXED = "spelling_ignore_mixed";
    private static final String PREF_SPELLING_IGNORE_SENTENCE = "spelling_ignore_sentence";
    private static final String PREF_SPELLING_IGNORE_SINGLE_LETTERS = "spelling_ignore_single_letters";
    private static final String PREF_SPELLING_IGNORE_URLS = "spelling_ignore_urls";
    private static final String PREF_SPELLING_LOCALE = "spelling_locale";
    private static final String PREF_SPELLING_PROPOSAL_THRESHOLD = "spelling_proposal_threshold";
    private static final String PREF_SPELLING_PROBLEMS_THRESHOLD = "spelling_problems_threshold";
    private static final String PREF_SPELLING_USER_DICTIONARY = "spelling_user_dictionary";
    private static final String PREF_VALUE_NO_LOCALE = "";
    private Button ignoreWordsWithDigitsCheck;
    private Button ignoreMixedCaseWordsCheck;
    private Button ignoreCapitalizationCheck;
    private Button ignoreURLsCheck;
    private Button ignoreSingleLetterCheck;
    private Text proposalThresholdText;
    private Text correctionsThresholdText;
    private Combo platformDictionaryCombo;
    private Text userDictionaryPath = null;
    private List<Locale> dictionaryLocales;

    protected static String[] getDictionaryLabels(Collection<Locale> locales) {
        int index = 0;
        String[] labels = new String[locales.size() + 1];
        Iterator<Locale> iterator = locales.iterator();
        while (iterator.hasNext()) {
            Locale value;
            Locale locale = value = iterator.next();
            labels[index++] = locale.getDisplayName();
        }
        labels[index++] = "None";
        return labels;
    }

    protected static IStatus validateAbsoluteFilePath(String path) {
        StatusInfo status = new StatusInfo();
        File file = new File(path);
        if (!(file.exists() || file.isAbsolute() && file.getParentFile().canWrite())) {
            status.setError("The dictionary file must be read/write accessible.");
        } else if (!(!file.exists() || file.isFile() && file.isAbsolute() && file.canRead() && file.canWrite())) {
            status.setError("The dictionary file must be read/write accessible.");
        }
        return status;
    }

    private static IStatus validateLocale(String localeString) {
        if (PREF_VALUE_NO_LOCALE.equals(localeString)) {
            return new StatusInfo();
        }
        Locale locale = SpellCheckEngine.convertToLocale(localeString);
        if (SpellCheckEngine.findClosestLocale(locale) != null) {
            return new StatusInfo();
        }
        return new StatusInfo(4, "There is no dictionary available for this language.");
    }

    protected static IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError("A positive integer must be specified.");
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError(number + " is not a valid positive integer.");
                }
            }
            catch (NumberFormatException numberFormatException) {
                status.setError(number + "  is not a valid positive integer");
            }
        }
        return status;
    }

    public void performRevert() {
    }

    public void dispose() {
    }

    public SpellingConfigurationBlock() {
        IStatus status = SpellingConfigurationBlock.validateAbsoluteFilePath(this.getValue(PREF_SPELLING_USER_DICTIONARY));
        if (status.getSeverity() != 0) {
            this.setValue(PREF_SPELLING_USER_DICTIONARY, PREF_VALUE_NO_LOCALE);
        }
        if ((status = SpellingConfigurationBlock.validateLocale(this.getValue(PREF_SPELLING_LOCALE))).getSeverity() != 0) {
            this.setValue(PREF_SPELLING_LOCALE, SpellCheckEngine.getDefaultLocale().toString());
        }
    }

    protected String getValue(String key) {
        return SpellingActivator.getDefault().getPreferences().getString(key);
    }

    protected void setValue(String key, String value) {
        SpellingActivator.getDefault().getPreferences().setValue(key, value);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Group user = new Group(composite, 0);
        user.setText("Options");
        user.setLayout((Layout)new GridLayout());
        user.setLayoutData((Object)new GridData(768));
        this.ignoreWordsWithDigitsCheck = UIUtils.createCheckbox((Composite)user, (String)"Ignore &words with digits", null, (boolean)false, (int)1);
        this.ignoreMixedCaseWordsCheck = UIUtils.createCheckbox((Composite)user, (String)"Ignore &mixed case words", null, (boolean)false, (int)1);
        this.ignoreCapitalizationCheck = UIUtils.createCheckbox((Composite)user, (String)"Ignore &sentence capitalization", null, (boolean)false, (int)1);
        this.ignoreURLsCheck = UIUtils.createCheckbox((Composite)user, (String)"Ignore URLs", null, (boolean)false, (int)1);
        this.ignoreSingleLetterCheck = UIUtils.createCheckbox((Composite)user, (String)"I&gnore words shorter than 4 letters", null, (boolean)false, (int)1);
        this.dictionaryLocales = new ArrayList<Locale>(SpellCheckEngine.getLocalesWithInstalledDictionaries());
        boolean hasPlatformDictionaries = this.dictionaryLocales.size() > 0;
        Group engine = UIUtils.createControlGroup((Composite)composite, (String)(hasPlatformDictionaries ? "Dictionaries" : "Dictionary"), (int)3, (int)768, (int)-1);
        if (hasPlatformDictionaries) {
            this.platformDictionaryCombo = UIUtils.createLabelCombo((Composite)engine, (String)"Platform dictionary", (String)PREF_SPELLING_LOCALE, (int)12);
            this.platformDictionaryCombo.setEnabled(this.dictionaryLocales.size() > 0);
            String[] stringArray = SpellingConfigurationBlock.getDictionaryLabels(this.dictionaryLocales);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String label = stringArray[n2];
                this.platformDictionaryCombo.add(label);
                ++n2;
            }
            UIUtils.createEmptyLabel((Composite)engine, (int)1, (int)1);
        }
        this.userDictionaryPath = UIUtils.createLabelText((Composite)engine, (String)"Use&r defined dictionary", null);
        ((GridData)this.userDictionaryPath.getLayoutData()).widthHint = 100;
        Composite buttons = UIUtils.createComposite((Composite)engine, (int)2);
        buttons.setLayoutData((Object)new GridData(128));
        Button button = new Button(buttons, 8);
        button.setText("&Browse...");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpellingConfigurationBlock.this.handleBrowseButtonSelected();
            }
        });
        button.setLayoutData((Object)new GridData(256));
        Label description = new Label((Composite)engine, 0);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 3;
        description.setLayoutData((Object)gd);
        description.setText("The user dictionary is a text file with one word on each line");
        Group advanced = UIUtils.createControlGroup((Composite)composite, (String)"Advanced", (int)2, (int)768, (int)-1);
        this.proposalThresholdText = UIUtils.createLabelText((Composite)advanced, (String)"Maximum number of problems repor&ted per file", null);
        this.proposalThresholdText.setTextLimit(4);
        this.correctionsThresholdText = UIUtils.createLabelText((Composite)advanced, (String)"Ma&ximum number of correction proposals", null);
        this.correctionsThresholdText.setTextLimit(3);
        this.performDefaults();
        return composite;
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }

    public boolean performApply() {
        BundlePreferenceStore store = SpellingActivator.getDefault().getPreferences();
        store.setValue(PREF_SPELLING_IGNORE_DIGITS, this.ignoreWordsWithDigitsCheck.getSelection());
        store.setValue(PREF_SPELLING_IGNORE_MIXED, this.ignoreMixedCaseWordsCheck.getSelection());
        store.setValue(PREF_SPELLING_IGNORE_SENTENCE, this.ignoreCapitalizationCheck.getSelection());
        store.setValue(PREF_SPELLING_IGNORE_URLS, this.ignoreURLsCheck.getSelection());
        store.setValue(PREF_SPELLING_IGNORE_SINGLE_LETTERS, this.ignoreSingleLetterCheck.getSelection());
        store.setValue(PREF_SPELLING_PROBLEMS_THRESHOLD, this.proposalThresholdText.getText());
        store.setValue(PREF_SPELLING_PROPOSAL_THRESHOLD, this.correctionsThresholdText.getText());
        store.setValue(PREF_SPELLING_USER_DICTIONARY, this.userDictionaryPath.getText());
        store.setValue(PREF_SPELLING_LOCALE, this.platformDictionaryCombo.getText());
        return true;
    }

    public void performDefaults() {
        BundlePreferenceStore store = SpellingActivator.getDefault().getPreferences();
        this.ignoreWordsWithDigitsCheck.setSelection(store.getBoolean(PREF_SPELLING_IGNORE_DIGITS));
        this.ignoreMixedCaseWordsCheck.setSelection(store.getBoolean(PREF_SPELLING_IGNORE_MIXED));
        this.ignoreCapitalizationCheck.setSelection(store.getBoolean(PREF_SPELLING_IGNORE_SENTENCE));
        this.ignoreURLsCheck.setSelection(store.getBoolean(PREF_SPELLING_IGNORE_URLS));
        this.ignoreSingleLetterCheck.setSelection(store.getBoolean(PREF_SPELLING_IGNORE_SINGLE_LETTERS));
        this.proposalThresholdText.setText(store.getString(PREF_SPELLING_PROBLEMS_THRESHOLD));
        this.correctionsThresholdText.setText(store.getString(PREF_SPELLING_PROPOSAL_THRESHOLD));
        String dictLocale = store.getString(PREF_SPELLING_LOCALE);
        this.platformDictionaryCombo.setText(dictLocale);
        if (this.platformDictionaryCombo.getSelectionIndex() < 0 && this.platformDictionaryCombo.getItemCount() > 0) {
            this.platformDictionaryCombo.select(0);
        }
        this.userDictionaryPath.setText(store.getString(PREF_SPELLING_USER_DICTIONARY));
    }

    protected void handleBrowseButtonSelected() {
        FileDialog dialog = new FileDialog(this.userDictionaryPath.getShell(), 0x10001000);
        dialog.setText("Select User Dictionary");
        dialog.setFilterPath(this.userDictionaryPath.getText());
        String path = dialog.open();
        if (path != null) {
            this.userDictionaryPath.setText(path);
        }
    }

    protected void setEnabled(boolean enabled) {
    }

    protected static class ControlData {
        private final String fKey;
        private final String[] fValues;

        public ControlData(String key, String[] values) {
            this.fKey = key;
            this.fValues = values;
        }

        public String getKey() {
            return this.fKey;
        }
    }

    static class StatusInfo
    implements IStatus {
        private String fStatusMessage;
        private int fSeverity;

        public StatusInfo() {
            this(0, null);
        }

        public StatusInfo(int severity, String message) {
            this.fStatusMessage = message;
            this.fSeverity = severity;
        }

        public boolean isOK() {
            return this.fSeverity == 0;
        }

        public boolean isWarning() {
            return this.fSeverity == 2;
        }

        public boolean isInfo() {
            return this.fSeverity == 1;
        }

        public boolean isError() {
            return this.fSeverity == 4;
        }

        public String getMessage() {
            return this.fStatusMessage;
        }

        public void setError(String errorMessage) {
            Assert.isNotNull((Object)errorMessage);
            this.fStatusMessage = errorMessage;
            this.fSeverity = 4;
        }

        public void setWarning(String warningMessage) {
            Assert.isNotNull((Object)warningMessage);
            this.fStatusMessage = warningMessage;
            this.fSeverity = 2;
        }

        public void setInfo(String infoMessage) {
            Assert.isNotNull((Object)infoMessage);
            this.fStatusMessage = infoMessage;
            this.fSeverity = 1;
        }

        public void setOK() {
            this.fStatusMessage = null;
            this.fSeverity = 0;
        }

        public boolean matches(int severityMask) {
            return (this.fSeverity & severityMask) != 0;
        }

        public boolean isMultiStatus() {
            return false;
        }

        public int getSeverity() {
            return this.fSeverity;
        }

        public String getPlugin() {
            return "org.eclipse.ui.editors";
        }

        public Throwable getException() {
            return null;
        }

        public int getCode() {
            return this.fSeverity;
        }

        public IStatus[] getChildren() {
            return new IStatus[0];
        }
    }
}

