/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.xlsx;

import com.dbeaver.jdbc.files.database.FFSQLType;
import java.math.BigDecimal;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

class XlsxCell {
    @Nullable
    private final Cell cell;
    @NotNull
    private final DataFormatter formatter;
    @Nullable
    private final FormulaEvaluator evaluator;

    public XlsxCell(@Nullable Cell cell, @NotNull DataFormatter formatter, @Nullable FormulaEvaluator evaluator) {
        this.cell = cell;
        this.formatter = formatter;
        this.evaluator = evaluator;
    }

    @Nullable
    public Object getCellValue() {
        if (this.cell == null) {
            return null;
        }
        return switch (this.getJdbcType()) {
            case FFSQLType.NULL -> null;
            case FFSQLType.BOOLEAN -> this.cell.getBooleanCellValue();
            case FFSQLType.DATE, FFSQLType.TIMESTAMP -> this.cell.getDateCellValue();
            case FFSQLType.NUMERIC -> BigDecimal.valueOf(this.cell.getNumericCellValue());
            case FFSQLType.VARCHAR -> this.cell.getStringCellValue();
            default -> this.formatter.formatCellValue(this.cell);
        };
    }

    public FFSQLType getJdbcType() {
        if (this.cell == null) {
            return FFSQLType.VARCHAR;
        }
        Cell evaluated = this.evaluator != null ? this.evaluator.evaluateInCell(this.cell) : this.cell;
        CellType type = evaluated.getCellType() != CellType.FORMULA ? this.cell.getCellType() : this.cell.getCachedFormulaResultType();
        return switch (type) {
            case CellType.STRING -> FFSQLType.VARCHAR;
            case CellType.NUMERIC -> {
                if (DateUtil.isCellDateFormatted((Cell)this.cell)) {
                    boolean isTimestamp;
                    String fmt = this.cell.getCellStyle().getDataFormatString().toLowerCase();
                    boolean hasHour = fmt.contains("h");
                    boolean hasSec = fmt.contains("s");
                    boolean hasMin = (hasHour || hasSec) && fmt.contains("m");
                    boolean v1 = isTimestamp = hasHour || hasMin || hasSec;
                    if (isTimestamp) {
                        yield FFSQLType.TIMESTAMP;
                    }
                    yield FFSQLType.DATE;
                }
                yield FFSQLType.NUMERIC;
            }
            case CellType.BOOLEAN -> FFSQLType.BOOLEAN;
            case CellType._NONE, CellType.BLANK, CellType.ERROR -> FFSQLType.NULL;
            default -> FFSQLType.VARCHAR;
        };
    }
}

