/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.upd.protocol;

import java.io.Reader;
import java.sql.SQLException;

public class UPDValueReader {
    private final Type type;
    private final Reader reader;
    private final long length;

    public UPDValueReader(Type type, Reader reader, long length) {
        this.type = type;
        this.reader = reader;
        this.length = length;
    }

    public Type getType() {
        return this.type;
    }

    public Reader getReader() {
        return this.reader;
    }

    public long getLength() {
        return this.length;
    }

    public String readString() throws SQLException {
        try {
            int bytesRead;
            StringBuilder sb = new StringBuilder();
            char[] buffer = new char[1024];
            while ((bytesRead = this.reader.read(buffer)) != -1) {
                sb.append(buffer, 0, bytesRead);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new SQLException("Error reading string", e);
        }
    }

    public static enum Type {
        CHARACTER,
        NCHAR,
        CLOB,
        NCLOB;

    }
}

