/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.view;

import com.dbeaver.model.tableau.TBObject;
import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.navigator.DBNTableauRootNode;
import com.dbeaver.ui.tableau.TableauFeatures;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IToolTipProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.navigator.DBNEmptyNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNObjectNode;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.properties.PropertyCollector;
import org.jkiss.dbeaver.ui.UIExecutionQueue;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CustomSashForm;
import org.jkiss.dbeaver.ui.controls.ViewerColumnController;
import org.jkiss.dbeaver.ui.internal.UINavigatorMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.dbeaver.ui.navigator.database.NavigatorViewBase;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;

public class TableauSitesView
extends NavigatorViewBase
implements DBPProjectListener {
    private static final Log log = Log.getLog(TableauSitesView.class);
    public static final String VIEW_ID = "com.dbeaver.tableau.sites";
    private ViewerColumnController<?, ?> columnController;
    private PropertyTreeViewer objectProps;

    private void updateTitle() {
        DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
        this.setPartName("Tableau (" + (activeProject == null ? "?" : activeProject.getName()) + ")");
    }

    public void createPartControl(Composite parent) {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("database-developer")) {
            log.debug((Object)"The user needs more permissions to see the Database Tasks View.");
            return;
        }
        CustomSashForm sashForm = UIUtils.createPartDivider((IWorkbenchPart)this, (Composite)parent, (int)256);
        super.createPartControl((Composite)sashForm);
        this.createDetailsView((Composite)sashForm);
        sashForm.setWeights(new int[]{600, 400});
        TableauFeatures.SITES_VIEW_OPEN.use();
        DBPPlatformDesktop.getInstance().getWorkspace().addProjectListener((DBPProjectListener)this);
        TreeViewer viewer = this.getNavigatorViewer();
        viewer.addSelectionChangedListener(event -> this.updateObjectProperties());
        viewer.getTree().setHeaderVisible(true);
        UIExecutionQueue.queueExec(() -> {
            this.createColumns(viewer);
            this.updateTitle();
        });
    }

    private void createColumns(TreeViewer viewer) {
        final ILabelProvider mainLabelProvider = (ILabelProvider)viewer.getLabelProvider();
        this.columnController = new ViewerColumnController("tableauSites", (ColumnViewer)viewer);
        this.columnController.setForceAutoSize(true);
        this.columnController.addColumn(UINavigatorMessages.navigator_project_explorer_columns_name_text, UINavigatorMessages.navigator_project_explorer_columns_name_description, 16384, true, true, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return mainLabelProvider.getText(element);
            }

            public Image getImage(Object element) {
                return mainLabelProvider.getImage(element);
            }

            public String getToolTipText(Object element) {
                if (mainLabelProvider instanceof IToolTipProvider) {
                    return ((IToolTipProvider)mainLabelProvider).getToolTipText(element);
                }
                return null;
            }
        });
        this.columnController.addColumn("Information", "Element information", 131072, true, false, (CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof DBNTableauDataSourceConnectionNode) {
                    DBNTableauDataSourceConnectionNode dsConNode = (DBNTableauDataSourceConnectionNode)element;
                    List dsList = dsConNode.getAssociatedDataSources();
                    return dsList.isEmpty() ? "" : dsList.stream().map(DBPNamedObject::getName).collect(Collectors.joining(","));
                }
                return "";
            }

            public Image getImage(Object element) {
                return super.getImage(element);
            }

            public String getToolTipText(Object element) {
                boolean cfr_ignored_0 = element instanceof DBNTableauDataSourceConnectionNode;
                return null;
            }
        });
        UIUtils.asyncExec(() -> this.columnController.createColumns(true));
    }

    private void createDetailsView(Composite parent) {
        Composite composite = UIUtils.createComposite((Composite)parent, (int)1);
        this.objectProps = new PropertyTreeViewer(composite, 0);
        this.objectProps.getControl().setLayoutData((Object)new GridData(1808));
    }

    private void updateObjectProperties() {
        DBNNode selNode = NavigatorUtils.getSelectedNode((ISelectionProvider)this.getNavigatorViewer());
        if (!(selNode instanceof DBNObjectNode)) {
            this.objectProps.clearProperties();
        } else {
            Object nodeObject = ((DBNObjectNode)selNode).getNodeObject();
            if (nodeObject instanceof TBObject && ((TBObject)nodeObject).needsDetails()) {
                try {
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            ((TBObject)nodeObject).loadDetails(monitor);
                        }
                        catch (DBException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    DBWorkbench.getPlatformUI().showError("Error loading details", "Error while loading object detailed information", (Throwable)e);
                }
                catch (InterruptedException interruptedException) {}
            }
            PropertyCollector collector = new PropertyCollector(nodeObject, false);
            collector.collectProperties();
            this.objectProps.loadProperties((DBPPropertySource)collector);
            this.objectProps.repackColumns();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        return (T)super.getAdapter(adapter);
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    public void dispose() {
        DBPPlatformDesktop.getInstance().getWorkspace().removeProjectListener((DBPProjectListener)this);
        super.dispose();
    }

    public DBNNode getRootNode() {
        DBNTableauRootNode tbRootNode = TBUtils.getTableauProjectNode((DBNModel)TableauSitesView.getGlobalNavigatorModel());
        if (tbRootNode != null) {
            return tbRootNode;
        }
        return new DBNEmptyNode();
    }

    public void handleActiveProjectChange(@NotNull DBPProject oldValue, @NotNull DBPProject newValue) {
        this.updateRepresentation();
    }

    private void updateRepresentation() {
        this.getNavigatorTree().reloadTree(this.getRootNode());
        this.updateTitle();
    }
}

