/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.tableau.editor;

import com.dbeaver.model.tableau.TBUtils;
import com.dbeaver.model.tableau.navigator.DBNTableauConnectionRelationNode;
import com.dbeaver.model.tableau.navigator.DBNTableauDataSourceConnectionNode;
import com.dbeaver.model.tableau.tds.TDSConnection;
import com.dbeaver.ui.tableau.editor.TableauCustomQueryEditorInput;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNEvent;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.ui.editors.text.PersistentStorageDocumentProvider;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class TableauCustomQueryEditor
extends SQLEditor {
    public TableauCustomQueryEditorInput getEditorInput() {
        return (TableauCustomQueryEditorInput)super.getEditorInput();
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        List associatedDataSources;
        this.setDocumentProvider((IDocumentProvider)new PersistentStorageDocumentProvider());
        super.init(site, editorInput);
        DBPProject project = this.getEditorInput().getProject();
        TDSConnection tdsConnection = this.getEditorInput().getRelation().getConnection();
        if (tdsConnection != null && !(associatedDataSources = TBUtils.getAssociatedDataSources((DBPDataSourceRegistry)project.getDataSourceRegistry(), (TDSConnection)tdsConnection)).isEmpty()) {
            DBPDataSourceContainer ds = (DBPDataSourceContainer)associatedDataSources.get(0);
            super.setDataSourceContainer(ds);
        }
    }

    protected boolean isDetectTitleImageFromInput() {
        return false;
    }

    public boolean setDataSourceContainer(final @Nullable DBPDataSourceContainer newDataSource) {
        final DBPDataSourceContainer oldDataSource = this.getDataSourceContainer();
        final TDSConnection connection = this.getEditorInput().getRelation().getConnection();
        final DBNTableauConnectionRelationNode node = this.getEditorInput().getNavigatorNode();
        if (connection != null && newDataSource != oldDataSource) {
            new AbstractJob("Change connection association"){
                {
                    super($anonymous0);
                    this.setUser(true);
                }

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        if (oldDataSource != null) {
                            TBUtils.unlinkDataSourceWithConnection((DBRProgressMonitor)monitor, (DBPDataSourceContainer)oldDataSource, (TDSConnection)connection);
                        }
                        if (newDataSource != null) {
                            TBUtils.linkDataSourceWithConnection((DBRProgressMonitor)monitor, (DBPDataSourceContainer)newDataSource, (TDSConnection)connection);
                        }
                        DBNTableauDataSourceConnectionNode conNode = node.getParentNode();
                        node.getModel().fireNodeUpdate((Object)conNode, (DBNNode)conNode, DBNEvent.NodeChange.REFRESH);
                    }
                    catch (Exception e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return super.setDataSourceContainer(newDataSource);
    }
}

