/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws.rds;

import com.dbeaver.cloud.aws.AWSCloudAbstractInstance;
import com.dbeaver.cloud.aws.AWSCloudSession;
import com.dbeaver.cloud.aws.AWSCloudZone;
import com.dbeaver.cloud.aws.AWSDatabaseEngine;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.runtime.net.DefaultCallbackHandler;
import software.amazon.awssdk.services.rds.model.DBInstance;

public abstract class AWSCloudRdsBaseInstance
extends AWSCloudAbstractInstance {
    protected AWSCloudRdsBaseInstance(AWSCloudSession session, AWSCloudZone zone) {
        super(session, zone);
    }

    @Override
    protected boolean isDriverNeedsPassword(DBPConnectionConfiguration configuration) {
        return !"iam".equals(configuration.getAuthModelId());
    }

    protected void setDefaultDataSourceConfiguration(DBInstance dbInstance, AWSDatabaseEngine instanceFamily, DBPConnectionConfiguration configuration) throws DBException {
        switch (instanceFamily) {
            case AURORA_POSTGRESQL: 
            case POSTGRES: {
                configuration.setAuthModelId(dbInstance.iamDatabaseAuthenticationEnabled() != false ? "iam" : "native");
                configuration.setProperty("ssl", "true");
                configuration.setProperty("sslmode", "require");
                configuration.setProperty("sslpasswordcallback", DefaultCallbackHandler.class.getName());
                break;
            }
            case AURORA: 
            case AURORA_MYSQL: 
            case MYSQL: {
                configuration.setAuthModelId(dbInstance.iamDatabaseAuthenticationEnabled() != false ? "iam" : "native");
                configuration.setProperty("useSSL", "true");
                configuration.setProperty("requireSSL", "true");
                configuration.setProperty("sslMode", "REQUIRED");
                break;
            }
            case MARIADB: {
                configuration.setAuthModelId("native");
                configuration.setProperty("useSSL", "false");
                break;
            }
            case ORACLE_SE: 
            case ORACLE_SE1: 
            case ORACLE_SE2: 
            case ORACLE_EE: {
                configuration.setAuthModelId("oracle_native");
                break;
            }
            case SQLSERVER_SE: 
            case SQLSERVER_EE: 
            case SQLSERVER_EX: {
                configuration.setAuthModelId("sqlserver_database");
                break;
            }
            case DOCDB: {
                break;
            }
            default: {
                throw new DBException("RDS engine '" + String.valueOf((Object)instanceFamily) + "' not supported");
            }
        }
    }

    public String toString() {
        return this.getAwsResourceARN();
    }
}

