/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.aws;

import com.dbeaver.cloud.aws.AWSCloudConstants;
import com.dbeaver.cloud.aws.AWSSecretManagerConfiguration;
import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.net.auth.aws.AuthModelAWSCredentials;
import java.util.Objects;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.utils.ArrayUtils;
import software.amazon.awssdk.regions.PartitionMetadata;
import software.amazon.awssdk.regions.Region;

public class AWSCloudConfiguration
extends AbstractCloudConfiguration<AWSCloudConfiguration> {
    private String[] defaultRegions = new String[]{AWSCloudConstants.BASE_DEFAULT_REGION_ID};
    private String[] enabledServices = new String[]{"rds", "redshift", "athena", "dynamodb", "documentdb", "keyspaces"};
    private boolean govRegionsEnabled;
    private boolean isoRegionsEnabled;
    private boolean s3Disabled;
    private boolean autoRegistrationEnabled = false;
    private String[] autoRegistrationAccounts = null;
    private boolean federatedAccessEnabled;
    private String proxyAccessKey;
    private String proxySecretKey;
    private String proxyDefaultRole;
    private AuthModelAWSCredentials credentials = new AuthModelAWSCredentials();
    private AWSSecretManagerConfiguration secretManagerConfiguration;

    public boolean isAutoRegistrationEnabled() {
        return this.autoRegistrationEnabled;
    }

    public void setAutoRegistrationEnabled(boolean autoRegistrationEnabled) {
        this.autoRegistrationEnabled = autoRegistrationEnabled;
    }

    public String[] getAutoRegistrationAccounts() {
        return this.autoRegistrationAccounts;
    }

    public void setAutoRegistrationAccounts(String[] autoRegistrationAccounts) {
        this.autoRegistrationAccounts = autoRegistrationAccounts;
    }

    public String[] getDefaultRegions() {
        return this.defaultRegions;
    }

    public void setDefaultRegions(String[] defaultRegions) {
        this.defaultRegions = defaultRegions;
    }

    public String[] getEnabledServices() {
        return this.enabledServices;
    }

    public void setEnabledServices(String[] enabledServices) {
        this.enabledServices = enabledServices;
    }

    public boolean isGovRegionsEnabled() {
        return this.govRegionsEnabled;
    }

    public void setGovRegionsEnabled(boolean govRegionsEnabled) {
        this.govRegionsEnabled = govRegionsEnabled;
    }

    public boolean isIsoRegionsEnabled() {
        return this.isoRegionsEnabled;
    }

    public boolean isS3Disabled() {
        return this.s3Disabled;
    }

    public AuthModelAWSCredentials getDefaultCredentials() {
        return this.credentials;
    }

    public boolean isFederatedAccessEnabled() {
        return this.federatedAccessEnabled;
    }

    public void setFederatedAccessEnabled(boolean federatedAccessEnabled) {
        this.federatedAccessEnabled = federatedAccessEnabled;
    }

    @Deprecated
    public String getProxyAccessKey() {
        return this.proxyAccessKey;
    }

    public void setProxyAccessKey(String proxyAccessKey) {
        this.proxyAccessKey = proxyAccessKey;
    }

    @Deprecated
    public String getProxySecretKey() {
        return this.proxySecretKey;
    }

    public void setProxySecretKey(String proxySecretKey) {
        this.proxySecretKey = proxySecretKey;
    }

    @Deprecated
    public String getProxyDefaultRole() {
        return this.proxyDefaultRole;
    }

    public void setProxyDefaultRole(String proxyDefaultRole) {
        this.proxyDefaultRole = proxyDefaultRole;
    }

    public String[] getEnabledZones() {
        return this.defaultRegions;
    }

    @Nullable
    public String getGlobalCloudId() {
        return "AWS";
    }

    public AWSSecretManagerConfiguration getSecretManagerConfiguration() {
        return this.secretManagerConfiguration;
    }

    public void setSecretManagerConfiguration(AWSSecretManagerConfiguration secretManagerConfiguration) {
        this.secretManagerConfiguration = secretManagerConfiguration;
    }

    @NotNull
    public Region getStsRegion() {
        String[] stringArray = this.defaultRegions;
        int n = this.defaultRegions.length;
        int n2 = 0;
        while (n2 < n) {
            String region = stringArray[n2];
            PartitionMetadata partition = Region.of((String)region).metadata().partition();
            if (!partition.id().equals("aws")) {
                return Region.of((String)region);
            }
            ++n2;
        }
        return Region.AWS_GLOBAL;
    }

    @Nullable
    public PartitionMetadata getRegionPartition() {
        if (!ArrayUtils.isEmpty((Object[])this.defaultRegions)) {
            return Region.of((String)this.defaultRegions[0]).metadata().partition();
        }
        return null;
    }

    public void mergeCloudSettings(AWSCloudConfiguration config) {
        super.mergeCloudSettings((AbstractCloudConfiguration)config);
        this.autoRegistrationEnabled = config.autoRegistrationEnabled;
        this.autoRegistrationAccounts = config.autoRegistrationAccounts;
        this.defaultRegions = config.defaultRegions;
        this.enabledServices = config.enabledServices;
        this.govRegionsEnabled = config.govRegionsEnabled;
        this.isoRegionsEnabled = config.isoRegionsEnabled;
        this.s3Disabled = config.s3Disabled;
        this.credentials = config.credentials;
    }

    public void processPostLoadActions() {
        super.processPostLoadActions();
        if (this.isDefaultConfiguration() && this.credentials != null) {
            this.credentials.setSessionCredentials(true);
            this.credentials.setProfileName(null);
            this.credentials.setDefaultAwsCredentials(false);
        }
    }

    public boolean isCloudSettingsEqual(AWSCloudConfiguration cfg) {
        return Objects.equals(this.getCloudId(), cfg.getCloudId()) && Objects.equals(this.getCloudName(), cfg.getCloudName()) && this.autoRegistrationEnabled == cfg.autoRegistrationEnabled && Objects.deepEquals(this.autoRegistrationAccounts, cfg.autoRegistrationAccounts) && Objects.deepEquals(this.defaultRegions, cfg.defaultRegions) && Objects.deepEquals(this.enabledServices, cfg.enabledServices) && Objects.equals(this.govRegionsEnabled, cfg.govRegionsEnabled) && Objects.equals(this.isoRegionsEnabled, cfg.isoRegionsEnabled) && this.s3Disabled == cfg.s3Disabled;
    }
}

