/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import java.lang.reflect.Type;
import java.util.concurrent.Callable;
import javax.annotation.concurrent.Immutable;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseAuthorization;
import net.java.truelicense.core.LicenseInitialization;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.LicenseParametersProvider;
import net.java.truelicense.core.LicenseProvider;
import net.java.truelicense.core.LicenseValidation;
import net.java.truelicense.core.auth.Artifactory;
import net.java.truelicense.core.auth.Authentication;
import net.java.truelicense.core.auth.Repository;
import net.java.truelicense.core.auth.RepositoryProvider;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.codec.Codecs;
import net.java.truelicense.core.crypto.Encryption;
import net.java.truelicense.core.io.Copy;
import net.java.truelicense.core.io.Sink;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.io.StoreProvider;
import net.java.truelicense.core.io.Transformation;

@Immutable
abstract class BasicLicenseManager
implements LicenseParametersProvider,
StoreProvider {
    BasicLicenseManager() {
    }

    public License create(final License license, final Sink sink) throws LicenseManagementException {
        return BasicLicenseManager.wrap(new Callable<License>(){

            @Override
            public License call() throws Exception {
                BasicLicenseManager.this.authorization().clearCreate(BasicLicenseManager.this.parameters());
                return BasicLicenseManager.this.encrypt(license, sink);
            }
        });
    }

    public License install(final Source source) throws LicenseManagementException {
        return BasicLicenseManager.wrap(new Callable<License>(){

            @Override
            public License call() throws Exception {
                BasicLicenseManager.this.authorization().clearInstall(BasicLicenseManager.this.parameters());
                License license = BasicLicenseManager.this.decodeLicense(source);
                Copy.copy(source, BasicLicenseManager.this.store());
                return license;
            }
        });
    }

    public License view() throws LicenseManagementException {
        return BasicLicenseManager.wrap(new Callable<License>(){

            @Override
            public License call() throws Exception {
                BasicLicenseManager.this.authorization().clearView(BasicLicenseManager.this.parameters());
                return BasicLicenseManager.this.decodeLicense(BasicLicenseManager.this.store());
            }
        });
    }

    public void verify() throws LicenseManagementException {
        BasicLicenseManager.wrap(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BasicLicenseManager.this.authorization().clearVerify(BasicLicenseManager.this.parameters());
                BasicLicenseManager.this.validate(BasicLicenseManager.this.store());
                return null;
            }
        });
    }

    public void uninstall() throws LicenseManagementException {
        BasicLicenseManager.wrap(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                BasicLicenseManager.this.authorization().clearUninstall(BasicLicenseManager.this.parameters());
                Store store = BasicLicenseManager.this.store();
                BasicLicenseManager.this.authenticate(store);
                store.delete();
                return null;
            }
        });
    }

    private static <V> V wrap(Callable<V> callable) throws LicenseManagementException {
        try {
            return callable.call();
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (LicenseManagementException licenseManagementException) {
            throw licenseManagementException;
        }
        catch (Exception exception) {
            throw new LicenseManagementException(exception);
        }
    }

    License encrypt(License license, Sink sink) throws Exception {
        return this.compress(license, this.encryption().apply(sink));
    }

    License compress(License license, Sink sink) throws Exception {
        return this.encodeRepository(license, this.compression().apply(sink));
    }

    License encodeRepository(License license, Sink sink) throws Exception {
        LicenseAndRepositoryProvider licenseAndRepositoryProvider = this.encodeAndSign(license);
        this.codec().encode(sink, licenseAndRepositoryProvider.repository());
        return licenseAndRepositoryProvider.license();
    }

    LicenseAndRepositoryProvider encodeAndSign(License license) throws Exception {
        final License license2 = this.validate(license);
        final Repository repository = this.repository();
        this.authentication().sign(this.codec(), repository, license2);
        return new LicenseAndRepositoryProvider(){

            @Override
            public License license() {
                return license2;
            }

            @Override
            public Repository repository() {
                return repository;
            }
        };
    }

    License validate(License license) throws Exception {
        License license2 = this.initialize(license);
        this.validation().validate(license2);
        return license2;
    }

    License initialize(License license) throws Exception {
        License license2 = this.duplicate(license);
        this.initialization().initialize(license2);
        return license2;
    }

    <V> V duplicate(V v) throws Exception {
        return Codecs.clone(v, this.codec());
    }

    void validate(Source source) throws Exception {
        this.validation().validate(this.decodeLicense(source));
    }

    License decodeLicense(Source source) throws Exception {
        return (License)this.authenticate(source).decode((Type)((Object)License.class));
    }

    Artifactory authenticate(Source source) throws Exception {
        return this.authentication().verify(this.codec(), this.decodeRepository(source));
    }

    Repository decodeRepository(Source source) throws Exception {
        return (Repository)this.codec().decode(this.decompress(source), (Type)((Object)Repository.class));
    }

    Source decompress(Source source) {
        return this.compression().unapply(this.decrypt(source));
    }

    Source decrypt(Source source) {
        return this.encryption().unapply(source);
    }

    final LicenseAuthorization authorization() {
        return this.parameters().authorization();
    }

    final LicenseInitialization initialization() {
        return this.parameters().initialization();
    }

    final LicenseValidation validation() {
        return this.parameters().validation();
    }

    final Repository repository() {
        return this.parameters().repository();
    }

    final Authentication authentication() {
        return this.parameters().authentication();
    }

    final Codec codec() {
        return this.parameters().codec();
    }

    final Transformation compression() {
        return this.parameters().compression();
    }

    final Encryption encryption() {
        return this.parameters().encryption();
    }

    @Override
    public abstract Store store();

    private static interface LicenseAndRepositoryProvider
    extends LicenseProvider,
    RepositoryProvider {
    }
}

