/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.GroupByElement;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionListDeParser;

public class GroupByDeParser
extends AbstractDeParser<GroupByElement> {
    private ExpressionListDeParser expressionListDeParser;

    GroupByDeParser() {
        this(null, new StringBuilder());
    }

    public GroupByDeParser(ExpressionVisitor expressionVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionListDeParser = new ExpressionListDeParser(expressionVisitor, buffer);
        this.buffer = buffer;
    }

    @Override
    public void deParse(GroupByElement groupBy) {
        this.buffer.append("GROUP BY ");
        this.expressionListDeParser.deParse(groupBy.getGroupByExpressionList());
        int i = 0;
        if (!groupBy.getGroupingSets().isEmpty()) {
            if (this.buffer.charAt(this.buffer.length() - 1) != ' ') {
                this.buffer.append(' ');
            }
            this.buffer.append("GROUPING SETS (");
            for (ExpressionList expressionList : groupBy.getGroupingSets()) {
                this.buffer.append(i++ > 0 ? ", " : "");
                this.expressionListDeParser.deParse(expressionList);
            }
            this.buffer.append(")");
        }
        if (groupBy.isMysqlWithRollup()) {
            this.buffer.append(" WITH ROLLUP");
        }
    }
}

