/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.io.Serializable;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Alias;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;

public class UnPivot
implements Serializable {
    private boolean includeNulls = false;
    private boolean includeNullsSpecified = false;
    private ExpressionList<Column> unpivotClause;
    private ExpressionList<Column> unpivotForClause;
    private List<SelectItem<?>> unpivotInClause;
    private Alias alias;

    public void accept(PivotVisitor pivotVisitor) {
        pivotVisitor.visit(this);
    }

    public boolean getIncludeNulls() {
        return this.includeNulls;
    }

    public void setIncludeNulls(boolean includeNulls) {
        this.includeNullsSpecified = true;
        this.includeNulls = includeNulls;
    }

    public boolean getIncludeNullsSpecified() {
        return this.includeNullsSpecified;
    }

    public List<Column> getUnPivotClause() {
        return this.unpivotClause;
    }

    public void setUnPivotClause(ExpressionList<Column> unpivotClause) {
        this.unpivotClause = unpivotClause;
    }

    public List<Column> getUnPivotForClause() {
        return this.unpivotForClause;
    }

    public void setUnPivotForClause(ExpressionList<Column> forColumns) {
        this.unpivotForClause = forColumns;
    }

    public List<SelectItem<?>> getUnPivotInClause() {
        return this.unpivotInClause;
    }

    public void setUnPivotInClause(List<SelectItem<?>> unpivotInClause) {
        this.unpivotInClause = unpivotInClause;
    }

    public String toString() {
        return "UNPIVOT" + (this.includeNullsSpecified && this.includeNulls ? " INCLUDE NULLS" : "") + (this.includeNullsSpecified && !this.includeNulls ? " EXCLUDE NULLS" : "") + " (" + this.unpivotClause.toString() + " FOR " + this.unpivotForClause.toString() + " IN " + PlainSelect.getStringList(this.unpivotInClause, true, true) + ")" + (this.alias != null ? this.alias.toString() : "");
    }

    public UnPivot withIncludeNulls(boolean includeNulls) {
        this.setIncludeNulls(includeNulls);
        return this;
    }

    public Alias getAlias() {
        return this.alias;
    }

    public void setAlias(Alias alias) {
        this.alias = alias;
    }
}

