/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.util.JSLikeList;

public class Util {
    public static <T> List<T> nullToEmpty(List<T> ts) {
        if (ts == null) {
            return Collections.emptyList();
        }
        return ts;
    }

    public static String trimSpacesEnd(String s) {
        int endIndex;
        char[] chars = s.toCharArray();
        for (endIndex = s.length(); endIndex > 0 && (chars[endIndex - 1] == ' ' || chars[endIndex - 1] == '\t'); --endIndex) {
        }
        return new String(chars, 0, endIndex);
    }

    @SafeVarargs
    public static <R> R firstNotnull(Supplier<R> ... sups) {
        for (Supplier<R> sup : sups) {
            R ret = sup.get();
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @SafeVarargs
    public static <R> Optional<R> firstPresent(Supplier<Optional<R>> ... sups) {
        for (Supplier<Optional<R>> sup : sups) {
            Optional<R> ret = sup.get();
            if (!ret.isPresent()) continue;
            return ret;
        }
        return Optional.empty();
    }

    public static String repeat(String s, int n) {
        return Stream.generate(() -> s).limit(n).collect(Collectors.joining());
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        return Stream.of(l1, l2).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static JSLikeList<String> sortByLengthDesc(JSLikeList<String> strings) {
        return new JSLikeList<String>(strings.stream().sorted(Comparator.comparingInt(String::length).reversed()).collect(Collectors.toList()));
    }
}

