/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import org.apache.commons.lang3.StringUtils;

public class EnvironmentUtils {
    public static String findCommandName() {
        Map mdc = Scope.getCurrentScope().getMdcManager().getAll();
        String defaultCommandName = "Unknown";
        try {
            String commandName = (String)mdc.get("liquibaseCommandName");
            if (commandName.equalsIgnoreCase("flow")) {
                String flowCommand = (String)Scope.getCurrentScope().get("flowCurrentCommandName", String.class);
                if (flowCommand == null) {
                    return defaultCommandName;
                }
                return EnvironmentUtils.format(flowCommand.split(" "));
            }
            return EnvironmentUtils.format(StringUtils.splitByCharacterTypeCamelCase((String)commandName));
        }
        catch (Exception e) {
            return defaultCommandName;
        }
    }

    private static String format(String[] originalCommand) {
        return Arrays.stream(originalCommand).map(String::trim).map(StringUtils::capitalize).filter(part -> !part.isEmpty()).collect(Collectors.joining(" "));
    }
}

