/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerStatement;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DisableTriggerGenerator
extends AbstractSqlGenerator<DisableTriggerStatement> {
    public boolean supports(DisableTriggerStatement disableTriggertStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    public ValidationErrors validate(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkDisallowedField("catalogName", (Object)disableTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        validationErrors.checkRequiredField("triggerName", (Object)disableTriggerStatement.getTriggerName());
        if (database instanceof MSSQLDatabase) {
            if (disableTriggerStatement.getScope() != null && !disableTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && !disableTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                validationErrors.addError("Invalid disableTrigger scope: " + disableTriggerStatement.getScope());
                if (disableTriggerStatement.getTableName() != null && disableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                    validationErrors.addError("Cannot specify tableName and scope != TABLE");
                }
            }
            if ((disableTriggerStatement.getScope() == null || disableTriggerStatement.getScope().equals("TABLE")) && disableTriggerStatement.getTableName() == null) {
                validationErrors.addError("tableName is required if scope is TABLE or not set");
            }
        }
        if (database instanceof PostgresDatabase) {
            validationErrors.checkRequiredField("tableName", (Object)disableTriggerStatement.getTriggerName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        if (database instanceof OracleDatabase) {
            sql.append("ALTER TRIGGER ");
            if (disableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            sql.append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            sql.append("DISABLE");
        } else if (database instanceof MSSQLDatabase) {
            boolean catalogTrigger = "CATALOG".equalsIgnoreCase(disableTriggerStatement.getScope());
            sql.append("DISABLE TRIGGER ");
            if (disableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            if (catalogTrigger) {
                sql.append(database.escapeObjectName(disableTriggerStatement.getTriggerName(), Trigger.class));
            } else {
                sql.append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTriggerName(), Trigger.class));
            }
            sql.append(" ");
            sql.append(" ON ");
            if (disableTriggerStatement.getScope() != null && catalogTrigger) {
                sql.append("DATABASE");
            } else {
                sql.append(database.escapeTableName(disableTriggerStatement.getCatalogName(), disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTableName()));
            }
        } else if (database instanceof PostgresDatabase) {
            sql.append("ALTER TABLE ");
            sql.append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTableName(), Trigger.class)).append(" ");
            sql.append(" DISABLE TRIGGER ");
            sql.append(database.escapeObjectName(disableTriggerStatement.getTriggerName(), Trigger.class));
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database type " + database.getShortName());
        }
        UnparsedSql generatedSql = new UnparsedSql(sql.toString(), new DatabaseObject[0]);
        return new Sql[]{generatedSql};
    }
}

