/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerChange;
import java.util.ArrayList;
import java.util.Arrays;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringClauses;

public class CreateTriggerGenerator
extends AbstractSqlGenerator<CreateTriggerStatement> {
    public int getPriority() {
        return 101;
    }

    public ValidationErrors validate(CreateTriggerStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("triggerName", (Object)statement.getTriggerName());
        validationErrors.checkRequiredField("triggerBody", (Object)statement.getTriggerBody());
        validationErrors.checkDisallowedField("catalogName", (Object)statement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return validationErrors;
    }

    public boolean supports(CreateTriggerStatement statement, Database database) {
        return !(database instanceof CockroachDatabase);
    }

    public Sql[] generateSql(CreateTriggerStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String endDelimiter = ";";
        if (database instanceof OracleDatabase) {
            endDelimiter = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            endDelimiter = "";
        }
        String schemaName = statement.getSchemaName();
        if (schemaName == null && database instanceof PostgresDatabase) {
            schemaName = database.getDefaultSchemaName();
        }
        String body = CreateProcedureGenerator.addSchemaToText((String)statement.getTriggerBody(), (String)schemaName, (String)"ON", (Database)database);
        body = CreateProcedureGenerator.removeTrailingDelimiter((String)body, (String)endDelimiter);
        if (this.needAppendSchemaName(database)) {
            body = CreateProcedureGenerator.addSchemaToText((String)body, (String)statement.getSchemaName(), (String)"TRIGGER", (Database)database);
        }
        ArrayList<Object> returnSql = new ArrayList<Object>();
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            String fullyQualifiedName;
            if (database instanceof MSSQLDatabase) {
                fullyQualifiedName = database.escapeObjectName(statement.getTriggerName(), Trigger.class);
                fullyQualifiedName = statement.getSchemaName() == null ? "[dbo]." + fullyQualifiedName : database.escapeObjectName(statement.getSchemaName(), Schema.class) + "." + fullyQualifiedName;
                if (statement.getTableName() == null) {
                    returnSql.add(new UnparsedSql("if (select count(*) from sys.triggers where parent_class_desc='DATABASE' and name='" + database.escapeStringForDatabase(statement.getTriggerName()) + "') = 0 exec ('CREATE TRIGGER " + database.escapeObjectName(statement.getTriggerName(), Trigger.class) + " on DATABASE FOR DROP_TABLE as begin select ''STUB'' END')", new DatabaseObject[0]));
                } else {
                    returnSql.add(new UnparsedSql("if object_id('" + fullyQualifiedName + "', 'tr') is null exec ('CREATE TRIGGER " + database.escapeObjectName(statement.getTriggerName(), Trigger.class) + " on " + database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), Table.class) + " after insert as begin select ''STUB'' END')", new DatabaseObject[0]));
                }
                SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
                LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
                StringClauses parsedSql = sqlParser.parse(body, true, true);
                StringClauses.ClauseIterator clauseIterator = parsedSql.getClauseIterator();
                Object next = "START";
                while (next != null && !next.toString().equalsIgnoreCase("create") && !next.toString().equalsIgnoreCase("alter") && clauseIterator.hasNext()) {
                    next = clauseIterator.nextNonWhitespace();
                }
                clauseIterator.replace((Object)"ALTER");
                body = parsedSql.toString();
            } else {
                fullyQualifiedName = database.escapeObjectName(statement.getProcedureName(), Trigger.class);
                returnSql.add(new UnparsedSql("DROP TRIGGER IF EXISTS " + fullyQualifiedName, new DatabaseObject[0]));
            }
        }
        returnSql.add(new UnparsedSql(body, endDelimiter, new DatabaseObject[0]));
        if (statement.getDisabled() != null && statement.getDisabled().booleanValue()) {
            DisableTriggerChange disableTriggerChange = new DisableTriggerChange();
            disableTriggerChange.setCatalogName(statement.getCatalogName());
            disableTriggerChange.setSchemaName(statement.getSchemaName());
            disableTriggerChange.setTriggerName(statement.getTriggerName());
            disableTriggerChange.setTableName(statement.getTableName());
            disableTriggerChange.setScope(statement.getScope());
            returnSql.addAll(Arrays.asList(SqlGeneratorFactory.getInstance().generateSql(disableTriggerChange.generateStatements(database), database)));
        }
        CreateProcedureGenerator.surroundWithSchemaSets(returnSql, (String)statement.getSchemaName(), (Database)database);
        return returnSql.toArray(new Sql[returnSql.size()]);
    }

    private boolean needAppendSchemaName(Database database) {
        return !(database instanceof PostgresDatabase);
    }
}

