/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage;

import com.datical.liquibase.ext.storedlogic.AbstractChangedStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.DatabasePackage;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;

public class ChangedPackageChangeGenerator
extends AbstractChangedStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if ((database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) && DatabasePackage.class.isAssignableFrom(objectType)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences objectDifferences, DiffOutputControl diffOutputControl, Database database, Database database2, ChangeGeneratorChain changeGeneratorChain) {
        if (objectDifferences.isDifferent("body")) {
            CreatePackageChange replaceChange = new CreatePackageChange();
            replaceChange.setPackageText(this.convertToReplace(((StoredDatabaseLogic)databaseObject).getBody(), database2));
            replaceChange.setPackageName(databaseObject.getName());
            if (diffOutputControl.getIncludeCatalog()) {
                replaceChange.setCatalogName(databaseObject.getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                replaceChange.setSchemaName(databaseObject.getSchema().getName());
            }
            return new Change[]{replaceChange};
        }
        return null;
    }
}

