/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.statement.compositetype.DropCompositeTypeStatement;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DropCompositeTypeGenerator
extends AbstractSqlGenerator<DropCompositeTypeStatement> {
    public boolean supports(DropCompositeTypeStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(DropCompositeTypeStatement statement, Database database, SqlGeneratorChain<DropCompositeTypeStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getName());
        return validationErrors;
    }

    public Sql[] generateSql(DropCompositeTypeStatement statement, Database database, SqlGeneratorChain<DropCompositeTypeStatement> sqlGeneratorChain) {
        StringBuilder builder = new StringBuilder();
        boolean ifExists = statement.getIfExists() != null && statement.getIfExists() != false;
        boolean hasOnDelete = statement.getOnDelete() != null;
        builder.append("DROP TYPE ").append(ifExists ? "IF EXISTS " : "").append(database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getName(), CompositeType.class)).append(hasOnDelete ? " " + statement.getOnDelete() : "");
        return new Sql[]{new UnparsedSql(builder.toString(), new DatabaseObject[0])};
    }
}

