/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.parser;

import com.datical.liquibase.ext.parser.ProFormattedSqlChangeLogParser;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.SetupException;
import liquibase.parser.AbstractFormattedChangeLogParser;
import liquibase.parser.core.ParsedNode;
import liquibase.parser.core.ParsedNodeException;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class ProFormattedChangelogParserUtil {
    static final String FILTER_REGEX = ".*\\s+filter:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern FILTER_PATTERN = Pattern.compile(".*\\s+filter:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String ENDS_WITH_FILTER_REGEX = ".*endsWithFilter:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern ENDS_WITH_FILTER_PATTERN = Pattern.compile(".*endsWithFilter:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String RESOURCE_FILTER_REGEX = ".*resourceFilter:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern RESOURCE_FILTER_PATTERN = Pattern.compile(".*resourceFilter:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String MIN_DEPTH_REGEX = ".*minDepth:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern MIN_DEPTH_PATTERN = Pattern.compile(".*minDepth:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String MAX_DEPTH_REGEX = ".*maxDepth:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern MAX_DEPTH_PATTERN = Pattern.compile(".*maxDepth:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String INCLUDE_ALL_PATH_REGEX = ".*?path:\\s*\"?([^\\s\"]+)\"?.*";
    static final Pattern INCLUDE_ALL_PATH_PATTERN = Pattern.compile(".*?path:\\s*\"?([^\\s\"]+)\"?.*", 2);
    static final String RELATIVE_TO_CHANGELOG_REGEX = ".*relativeToChangelog:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern RELATIVE_TO_CHANGELOG_PATTERN = Pattern.compile(".*relativeToChangelog:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String RELATIVE_TO_CHANGELOG_FILE_REGEX = ".*relativeToChangelogFile:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern RELATIVE_TO_CHANGELOG_FILE_PATTERN = Pattern.compile(".*relativeToChangelogFile:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final String ERROR_IF_MISSING_OR_EMPTY_REGEX = ".*errorIfMissingOrEmpty:(\\w+).*";
    static final Pattern ERROR_IF_MISSING_OR_EMPTY_PATTERN = Pattern.compile(".*errorIfMissingOrEmpty:(\\w+).*", 2);
    static final String RESOURCE_COMPARATOR_DEF_REGEX = ".*\\s+resourceComparator:\\s*(\"[^\"]*+\"|\\S*).*";
    static final Pattern RESOURCE_COMPARATOR_DEF_PATTERN = Pattern.compile(".*\\s+resourceComparator:\\s*(\"[^\"]*+\"|\\S*).*", 2);
    static final Pattern IGNORE_CHANGESET_PATTERN = Pattern.compile(".*ignore:(\\w*).*", 2);
    static final String INCLUDE_FILE_REGEX = ".*?file:\\s*\"?([^\"\\s]*)\"?.*";
    static final Pattern INCLUDE_FILE_PATTERN = Pattern.compile(".*?file:\\s*\"?([^\"\\s]*)\"?.*", 2);
    static final String ERROR_IF_MISSING_REGEX = ".*errorIfMissing:(\\w+).*";
    static final Pattern ERROR_IF_MISSING_PATTERN = Pattern.compile(".*errorIfMissing:(\\w+).*", 2);

    public static boolean handleInclude(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Matcher includeMatcher) throws ChangeLogParseException {
        ParsedNode includeNode = new ParsedNode(null, "include");
        String includeParameters = includeMatcher.group(1);
        Matcher matcher = INCLUDE_FILE_PATTERN.matcher(includeParameters);
        if (!matcher.matches()) {
            return false;
        }
        Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched include tag");
        ProFormattedChangelogParserUtil.addNode(includeNode, ProFormattedChangelogParserUtil.createChildNode("file", INCLUDE_FILE_PATTERN.matcher(includeParameters)));
        Matcher contextMatcher = ProFormattedChangelogParserUtil.determineContextMatcher(includeParameters);
        String contextDescription = ProFormattedChangelogParserUtil.determineContextDescription(contextMatcher);
        ProFormattedChangelogParserUtil.addNode(includeNode, ProFormattedChangelogParserUtil.createChildNode(contextDescription, contextMatcher, changeLog));
        ProFormattedChangelogParserUtil.addNode(includeNode, ProFormattedChangelogParserUtil.createChildNode("labels", AbstractFormattedChangeLogParser.LABELS_PATTERN.matcher(includeParameters), changeLog));
        ProFormattedChangelogParserUtil.addNode(includeNode, ProFormattedChangelogParserUtil.createChildNode("ignore", IGNORE_CHANGESET_PATTERN.matcher(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeNode, ProFormattedChangelogParserUtil.createChildNode("errorIfMissing", ERROR_IF_MISSING_PATTERN.matcher(includeParameters)));
        ParsedNode childNode = ProFormattedChangelogParserUtil.handleRelativeToChangelogAttributeInInclude(includeParameters);
        ProFormattedChangelogParserUtil.addNode(includeNode, childNode);
        try {
            changeLog.handleChildNodeHelper(includeNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException e) {
            throw new ChangeLogParseException(e);
        }
        return true;
    }

    private static ParsedNode handleRelativeToChangelogAttributeInInclude(String includeParameters) throws ChangeLogParseException {
        ParsedNode childNode = ProFormattedChangelogParserUtil.createChildNode("relativeToChangelogFile", RELATIVE_TO_CHANGELOG_PATTERN.matcher(includeParameters));
        if (childNode == null) {
            childNode = ProFormattedChangelogParserUtil.createChildNode("relativeToChangelogFile", RELATIVE_TO_CHANGELOG_FILE_PATTERN.matcher(includeParameters));
        }
        return childNode;
    }

    public static boolean handleIncludeAll(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Matcher includeAllMatcher) throws ChangeLogParseException {
        ParsedNode includeAllNode = new ParsedNode(null, "includeAll");
        String includeParameters = includeAllMatcher.group(1);
        Matcher matcher = INCLUDE_ALL_PATH_PATTERN.matcher(includeParameters);
        if (!matcher.matches()) {
            return false;
        }
        Scope.getCurrentScope().getLog(ProFormattedSqlChangeLogParser.class).fine("Matched includeAll tag");
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("path", INCLUDE_ALL_PATH_PATTERN.matcher(includeParameters)));
        ParsedNode childNode = ProFormattedChangelogParserUtil.handleRelativeToChangelogAttributeInInclude(includeParameters);
        ProFormattedChangelogParserUtil.addNode(includeAllNode, childNode);
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("resourceFilter", ProFormattedChangelogParserUtil.determineResourceFilterMatcher(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("errorIfMissingOrEmpty", ERROR_IF_MISSING_OR_EMPTY_PATTERN.matcher(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("resourceComparator", RESOURCE_COMPARATOR_DEF_PATTERN.matcher(includeParameters)));
        Matcher contextMatcher = ProFormattedChangelogParserUtil.determineContextMatcher(includeParameters);
        String contextDescription = ProFormattedChangelogParserUtil.determineContextDescription(contextMatcher);
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode(contextDescription, contextMatcher, changeLog));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("labels", AbstractFormattedChangeLogParser.LABELS_PATTERN.matcher(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("ignore", IGNORE_CHANGESET_PATTERN.matcher(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("minDepth", ProFormattedChangelogParserUtil.determineMinDepth(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("maxDepth", ProFormattedChangelogParserUtil.determineMaxDepth(includeParameters)));
        ProFormattedChangelogParserUtil.addNode(includeAllNode, ProFormattedChangelogParserUtil.createChildNode("endsWithFilter", ENDS_WITH_FILTER_PATTERN.matcher(includeParameters)));
        try {
            changeLog.handleChildNodeHelper(includeAllNode, resourceAccessor, new HashMap());
        }
        catch (SetupException | ParsedNodeException e) {
            throw new ChangeLogParseException(e);
        }
        return true;
    }

    public static Matcher determineContextMatcher(String line) {
        Matcher contextFilterPatternMatcher = AbstractFormattedChangeLogParser.CONTEXT_FILTER_PATTERN.matcher(line);
        if (contextFilterPatternMatcher.matches()) {
            return contextFilterPatternMatcher;
        }
        Matcher contextPatternMatcher = AbstractFormattedChangeLogParser.CONTEXT_PATTERN.matcher(line);
        if (contextPatternMatcher.matches()) {
            return contextPatternMatcher;
        }
        return null;
    }

    public static String getValueFromMatcher(Matcher matcher) {
        if (matcher != null && matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public static Integer determineMinDepth(String line) throws ChangeLogParseException {
        Integer minDepth = null;
        Matcher minDepthMatcher = MIN_DEPTH_PATTERN.matcher(line);
        if (minDepthMatcher.matches()) {
            String minDepthString = minDepthMatcher.group(1);
            try {
                minDepth = Integer.parseInt(minDepthString);
                if (minDepth < 0) {
                    throw new ChangeLogParseException("Illegal min depth value of '" + minDepthString + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new ChangeLogParseException("Invalid min depth value of '" + minDepthString + "'.  The value must be a valid integer > 0");
            }
        }
        return minDepth;
    }

    public static Integer determineMaxDepth(String line) throws ChangeLogParseException {
        Integer maxDepth = null;
        Matcher maxDepthMatcher = MAX_DEPTH_PATTERN.matcher(line);
        if (maxDepthMatcher.matches()) {
            String maxDepthString = maxDepthMatcher.group(1);
            try {
                maxDepth = Integer.parseInt(maxDepthString);
                if (maxDepth < 0) {
                    throw new ChangeLogParseException("Illegal max depth value of '" + maxDepthString + "'.  The value must be > 0.");
                }
            }
            catch (NumberFormatException nfe) {
                throw new ChangeLogParseException("Invalid max depth value of '" + maxDepthString + "'.  The value must be a valid integer < MAX_VALUE");
            }
        }
        return maxDepth;
    }

    public static Matcher determineResourceFilterMatcher(String line) {
        Matcher resourceFilterMatcher = FILTER_PATTERN.matcher(line);
        if (resourceFilterMatcher.matches()) {
            return resourceFilterMatcher;
        }
        Matcher filterDefMatcher = RESOURCE_FILTER_PATTERN.matcher(line);
        if (filterDefMatcher.matches()) {
            return filterDefMatcher;
        }
        return null;
    }

    public static String determineContextDescription(Matcher contextMatcher) {
        String contextDescription = null;
        if (contextMatcher != null) {
            contextDescription = contextMatcher.pattern() == AbstractFormattedChangeLogParser.CONTEXT_PATTERN ? "context" : "contextFilter";
        }
        return contextDescription;
    }

    public static ParsedNode createChildNode(String name, Integer intValue) throws ChangeLogParseException {
        try {
            if (intValue != null) {
                ProFormattedChangelogParserUtil.logMatch(name, intValue.toString());
                ParsedNode parsedNode = new ParsedNode(null, name);
                parsedNode.setValue((Object)intValue);
                return parsedNode;
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
        return null;
    }

    public static void addNode(ParsedNode parent, ParsedNode child) throws ChangeLogParseException {
        try {
            if (child != null) {
                parent.addChild(child);
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
    }

    public static ParsedNode createChildNode(String name, Matcher matcher) throws ChangeLogParseException {
        return ProFormattedChangelogParserUtil.createChildNode(name, matcher, null);
    }

    public static ParsedNode createChildNode(String name, Matcher matcher, DatabaseChangeLog changeLog) throws ChangeLogParseException {
        try {
            String value = ProFormattedChangelogParserUtil.getValueFromMatcher(matcher);
            if (value != null) {
                if (changeLog != null) {
                    value = changeLog.getChangeLogParameters().expandExpressions(StringUtil.stripEnclosingQuotes((String)value), changeLog);
                }
                ProFormattedChangelogParserUtil.logMatch(name, value);
                ParsedNode parsedNode = new ParsedNode(null, name);
                parsedNode.setValue((Object)value);
                return parsedNode;
            }
        }
        catch (ParsedNodeException pne) {
            throw new ChangeLogParseException((Throwable)pne);
        }
        return null;
    }

    private static void logMatch(String attribute, String value) {
        if (StringUtils.isEmpty((CharSequence)attribute)) {
            return;
        }
        Scope.getCurrentScope().getLog(ProFormattedChangelogParserUtil.class).fine("Matched attribute '" + attribute + "' = '" + value + "'");
    }
}

