/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.config.LiquibaseFlowConfiguration;
import com.datical.liquibase.ext.flow.file.FlowFileDTO;
import com.datical.liquibase.ext.flow.file.Stage;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import lombok.Generated;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class FlowFile {
    private Map<String, Object> inheritedVariables = new HashMap<String, Object>();
    private LinkedHashMap<String, Stage> stages = new LinkedHashMap();
    private Stage endStage;
    private LinkedHashMap<String, Object> globalVariables = new LinkedHashMap();
    private LinkedHashMap<String, Object> includedVariables = new LinkedHashMap();
    private final Map<String, Object> userMetadata = new HashMap<String, Object>();
    private FlowFileDTO dto;

    public FlowFile() {
    }

    public FlowFile(Map<String, Object> inheritedVariables) {
        this.inheritedVariables = inheritedVariables;
    }

    public void addUserMetadata(String key, Object value) {
        this.userMetadata.put(key, value);
    }

    public Map<String, Object> getUserMetadata() {
        return Collections.unmodifiableMap(this.userMetadata);
    }

    public LinkedHashMap<String, Object> getAllVariables() {
        LinkedHashMap<String, Object> variables;
        LinkedHashMap<String, Object> linkedHashMap = variables = this.inheritedVariables != null ? new LinkedHashMap<String, Object>(this.inheritedVariables) : new LinkedHashMap();
        if (this.globalVariables != null) {
            variables.putAll(this.globalVariables);
        }
        if (this.includedVariables != null) {
            variables.putAll(this.includedVariables);
        }
        return variables;
    }

    public static void dumpFlowFile(FlowFile flowFile) throws Exception {
        Scope.child((String)LiquibaseFlowConfiguration.FLOW_VERBOSE_TO_STRING.getKey(), (Object)true, () -> Scope.getCurrentScope().getLog(FlowFile.class).info(flowFile.toString()));
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE);
    }

    @Generated
    public void setStages(LinkedHashMap<String, Stage> stages) {
        this.stages = stages;
    }

    @Generated
    public LinkedHashMap<String, Stage> getStages() {
        return this.stages;
    }

    @Generated
    public void setEndStage(Stage endStage) {
        this.endStage = endStage;
    }

    @Generated
    public Stage getEndStage() {
        return this.endStage;
    }

    @Generated
    public void setGlobalVariables(LinkedHashMap<String, Object> globalVariables) {
        this.globalVariables = globalVariables;
    }

    @Generated
    public LinkedHashMap<String, Object> getGlobalVariables() {
        return this.globalVariables;
    }

    @Generated
    public void setIncludedVariables(LinkedHashMap<String, Object> includedVariables) {
        this.includedVariables = includedVariables;
    }

    @Generated
    public void setDto(FlowFileDTO dto) {
        this.dto = dto;
    }

    @Generated
    public FlowFileDTO getDto() {
        return this.dto;
    }
}

