/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.command.FlowValidateCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.FlowShellCommandAction;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.flow.condition.FlowStringUtil;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.provider.CommandResultsValueProvider;
import com.datical.liquibase.ext.flow.provider.StageGlobalArgsValueProvider;
import com.datical.liquibase.ext.flow.provider.StageValueProvider;
import com.datical.liquibase.ext.logging.structured.mdc.customobjects.FlowFileRoot;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.OutputStream;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedSet;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandFailedException;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.util.CollectionUtil;
import liquibase.util.ExceptionUtil;
import liquibase.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;

public class FlowCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final CommandArgumentDefinition<FlowFile> FLOW_FILE_DTO;
    public static final String DEFAULT_FLOW_FILE_NAME = "liquibase.flowfile.yaml";
    public static final String BANNER = "******************************************************************************";
    public static final String STATUS_CODE = "statusCode";
    public static final String FAIL = "Fail";
    public static final String SUCCESS = "Success";
    private Boolean validated;
    private FlowFileLoad flowFileLoad;

    @Override
    public void validate(CommandScope commandScope) throws CommandValidationException {
        super.validate(commandScope);
        try {
            CommandScope validationScope = new CommandScope(FlowValidateCommandStep.COMMAND_NAME);
            for (Map.Entry validateArgument : validationScope.getCommand().getArguments().entrySet()) {
                ConfiguredValue configuredValue = commandScope.getConfiguredValue((CommandArgumentDefinition)validateArgument.getValue());
                if (configuredValue.wasDefaultValueUsed()) continue;
                validationScope.addArgumentValue((String)validateArgument.getKey(), configuredValue.getValue());
            }
            CommandResults results = validationScope.execute();
            this.validated = (Boolean)results.getResult("validated");
            this.flowFileLoad = (FlowFileLoad)results.getResult("flowFilePath");
        }
        catch (CommandExecutionException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error during validation", (Throwable)e);
            throw new CommandValidationException("Error during validation: " + e.getMessage());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        String exitMessage;
        Integer exitCode;
        String startTimeString;
        LinkedHashMap<String, Stage> stages;
        CommandScope commandScope;
        FlowFile flowFile;
        block62: {
            OutputStream outputStream;
            CommandResultsValueProvider resultsValueProvider;
            ConfigurationValueProvider currentProvider;
            LiquibaseConfiguration liquibaseConfiguration;
            String currentStageName;
            CommandExecutionException commandExecutionException;
            int maxExitCode;
            block58: {
                if (this.validated == null || Boolean.FALSE.equals(this.validated)) {
                    resultsBuilder.addResult(STATUS_CODE, (Object)0);
                    return;
                }
                FlowFile flowFile2 = flowFile = this.flowFileLoad != null ? this.flowFileLoad.flowFile : null;
                if (flowFile == null) {
                    resultsBuilder.addResult(STATUS_CODE, (Object)0);
                    return;
                }
                commandScope = resultsBuilder.getCommandScope();
                stages = flowFile.getStages();
                startTimeString = Instant.ofEpochMilli(new Date().getTime()).toString();
                maxExitCode = 0;
                commandExecutionException = null;
                currentStageName = null;
                Map<String, Object> userMetadata = flowFile.getUserMetadata();
                if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                    Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
                }
                liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
                currentProvider = null;
                resultsValueProvider = new CommandResultsValueProvider();
                exitCode = null;
                exitMessage = null;
                currentProvider = liquibaseConfiguration.getProvider((ConfigurationValueProvider)resultsValueProvider);
                if (currentProvider != null) {
                    liquibaseConfiguration.removeProvider(currentProvider);
                }
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)resultsValueProvider);
                if (stages == null || stages.isEmpty()) {
                    Scope.getCurrentScope().getUI().sendMessage("No stages found.");
                    break block58;
                }
                FlowFileLoad parentFlowFileLoad = this.flowFileLoad;
                for (Map.Entry<String, Stage> stageEntry : stages.entrySet()) {
                    currentStageName = stageEntry.getKey();
                    this.executeStage(stageEntry.getValue(), currentStageName, resultsBuilder, resultsValueProvider, flowFile);
                    exitCode = (Integer)resultsBuilder.getResult("exitCode");
                    if (exitCode == null) continue;
                    exitMessage = (String)resultsBuilder.getResult("exitMessage");
                    exitMessage = StringUtils.isNotEmpty((CharSequence)exitMessage) ? "Exit code: " + exitCode + " - " + exitMessage : "Exit code: " + exitCode;
                    if (exitCode == 0) {
                        Scope.getCurrentScope().getLog(FlowCommandStep.class).info(exitMessage);
                    }
                    throw new CommandFailedException(null, exitCode.intValue(), exitMessage, true);
                }
                this.flowFileLoad = parentFlowFileLoad;
            }
            try {
                this.executeStage(flowFile.getEndStage(), "endStage", resultsBuilder, resultsValueProvider, flowFile);
            }
            catch (CommandExecutionException cee) {
                int finallyMaxExitCode = this.findExitCode(cee);
                if (finallyMaxExitCode > maxExitCode || commandExecutionException == null) {
                    commandExecutionException = cee;
                } else {
                    this.showExceptionMessageOnConsole(cee);
                }
                this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, true, commandExecutionException);
            }
            finally {
                for (Map.Entry<String, OutputStream> outputStreamEntry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    outputStream = outputStreamEntry.getValue();
                    String filename = outputStreamEntry.getKey();
                    try {
                        outputStream.close();
                    }
                    catch (Exception e) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e);
                    }
                }
            }
            for (Map.Entry outputStreamEntry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                outputStream = (OutputStream)outputStreamEntry.getValue();
                String filename = (String)outputStreamEntry.getKey();
                try {
                    outputStream.close();
                }
                catch (Exception e) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e);
                }
            }
            liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)resultsValueProvider);
            if (currentProvider != null) {
                liquibaseConfiguration.registerProvider(currentProvider);
            }
            break block62;
            catch (CommandExecutionException e) {
                maxExitCode = this.findExitCode(e);
                commandExecutionException = e;
                this.showExceptionMessageOnConsole(commandExecutionException);
                this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, false, e);
                try {
                    this.executeStage(flowFile.getEndStage(), "endStage", resultsBuilder, resultsValueProvider, flowFile);
                }
                catch (CommandExecutionException cee) {
                    int finallyMaxExitCode = this.findExitCode(cee);
                    if (finallyMaxExitCode > maxExitCode || commandExecutionException == null) {
                        commandExecutionException = cee;
                    } else {
                        this.showExceptionMessageOnConsole(cee);
                    }
                    this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, true, commandExecutionException);
                }
                finally {
                    for (Map.Entry<String, OutputStream> outputStreamEntry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        OutputStream outputStream2 = outputStreamEntry.getValue();
                        String filename = outputStreamEntry.getKey();
                        try {
                            outputStream2.close();
                        }
                        catch (Exception e2) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e2);
                        }
                    }
                }
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)resultsValueProvider);
                if (currentProvider != null) {
                    liquibaseConfiguration.registerProvider(currentProvider);
                }
                catch (Throwable throwable) {
                    try {
                        this.executeStage(flowFile.getEndStage(), "endStage", resultsBuilder, resultsValueProvider, flowFile);
                    }
                    catch (CommandExecutionException cee) {
                        int finallyMaxExitCode = this.findExitCode(cee);
                        if (finallyMaxExitCode > maxExitCode || commandExecutionException == null) {
                            commandExecutionException = cee;
                        } else {
                            this.showExceptionMessageOnConsole(cee);
                        }
                        this.handleCommandExecutionException(flowFile, commandScope, stages, startTimeString, currentStageName, true, commandExecutionException);
                    }
                    finally {
                        for (Map.Entry<String, OutputStream> outputStreamEntry : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                            OutputStream outputStream3 = outputStreamEntry.getValue();
                            String filename = outputStreamEntry.getKey();
                            try {
                                outputStream3.close();
                            }
                            catch (Exception e3) {
                                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file " + filename, (Throwable)e3);
                            }
                        }
                    }
                    liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)resultsValueProvider);
                    if (currentProvider != null) {
                        liquibaseConfiguration.registerProvider(currentProvider);
                    }
                    throw throwable;
                }
            }
        }
        this.addFlowInfoToMdc(flowFile, commandScope, stages, startTimeString, null, null);
        resultsBuilder.addResult(STATUS_CODE, (Object)0);
        if (exitCode != null && exitCode == 0 && exitMessage != null) {
            Scope.getCurrentScope().getUI().sendMessage(String.format("%s%n", exitMessage));
        }
    }

    private void showExceptionMessageOnConsole(CommandExecutionException cee) {
        String message = cee.getMessage();
        if (StringUtil.isNotEmpty((String)message)) {
            message = message.replaceAll("liquibase.exception.*: ", "");
            message = "ERROR: " + message;
            Scope.getCurrentScope().getUI().sendErrorMessage(message);
        }
    }

    private int findExitCode(CommandExecutionException cee) {
        Throwable e;
        for (e = cee; e != null && !(e instanceof CommandFailedException); e = (Exception)e.getCause()) {
        }
        if (e != null) {
            return ((CommandFailedException)e).getExitCode();
        }
        return 0;
    }

    private void handleCommandExecutionException(FlowFile flowFile, CommandScope commandScope, LinkedHashMap<String, Stage> stages, String startTimeString, String currentStageName, boolean replaceMessage, CommandExecutionException cee) throws CommandExecutionException, CommandFailedException {
        CommandFailedException returnException;
        this.addFlowInfoToMdc(flowFile, commandScope, stages, startTimeString, currentStageName, cee.getMessage());
        if (ExceptionUtil.showExceptionInLog((Throwable)cee)) {
            Scope.getCurrentScope().getLog(FlowCommandStep.class).warning("Exception occurred", (Throwable)cee);
        }
        if ((returnException = this.findCommandFailedException((Exception)((Object)cee))) != null) {
            String message = returnException.getMessage();
            if (replaceMessage) {
                message = message.replaceAll("(.*?) command", "Flow command");
                throw new CommandFailedException(returnException.getResults(), returnException.getExitCode().intValue(), message, true);
            }
            throw returnException;
        }
        throw cee;
    }

    private CommandFailedException findCommandFailedException(Exception e) {
        while (e != null && e.getCause() != null) {
            Throwable t = e.getCause();
            if (t instanceof CommandFailedException) {
                return (CommandFailedException)t;
            }
            e = (Exception)e.getCause();
        }
        return null;
    }

    private void addFlowInfoToMdc(FlowFile flowFile, CommandScope commandScope, LinkedHashMap<String, Stage> stages, String startTimeString, String currentStageName, String failureMessage) {
        if (stages == null || stages.isEmpty()) {
            return;
        }
        String stopTimeString = Instant.ofEpochMilli(new Date().getTime()).toString();
        Scope.getCurrentScope().getMdcManager().clear();
        String name = (String)commandScope.getConfiguredValue(FLOW_FILE).getValue();
        Stage endStage = flowFile.getEndStage();
        FlowFileRoot flowFileRoot = new FlowFileRoot(name, this.flowFileLoad, stages, endStage);
        try (MdcObject flowFileStartTime = Scope.getCurrentScope().addMdcValue("flowStart", startTimeString);
             MdcObject flowFileRootMdc = Scope.getCurrentScope().addMdcValue("flowFileRoot", (CustomMdcObject)flowFileRoot);
             MdcObject flowFileStopTime = Scope.getCurrentScope().addMdcValue("flowStop", stopTimeString);
             MdcObject flowFileOutcome = Scope.getCurrentScope().addMdcValue("flowFileOutcome", currentStageName != null ? FAIL : SUCCESS);
             MdcObject flowFileError = this.handleFlowFileError(currentStageName, failureMessage);){
            String flowMessage = "Flow command complete";
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(flowMessage);
        }
    }

    private MdcObject handleFlowFileError(String currentStageName, String failureMessage) {
        if (currentStageName == null) {
            return null;
        }
        Scope.getCurrentScope().addMdcValue("flowFileFailedStage", currentStageName);
        return Scope.getCurrentScope().addMdcValue("flowFileFailedMessage", failureMessage);
    }

    private void executeStage(Stage stage, String stageName, CommandResultsBuilder resultsBuilder, CommandResultsValueProvider resultsValueProvider, FlowFile flowFile) throws Exception {
        Scope.child(Collections.emptyMap(), () -> {
            if (stage == null) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Empty stage '" + stageName + "' found"));
                return;
            }
            Map<String, Object> userMetadata = stage.getCombinedUserMetadata(flowFile.getUserMetadata());
            if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
            }
            if (stage.getActions() == null || stage.getActions().isEmpty()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No actions found for Stage: " + stageName));
                return;
            }
            if (stage.getCondition() != null && !stage.getCondition().evaluate()) {
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping stage: " + stageName + " because condition '" + stage.getCondition().getRawConditionText() + "' evaluated to false."));
                return;
            }
            LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            StageGlobalArgsValueProvider flowValueProvider = new StageGlobalArgsValueProvider(stage.getGlobalArgs());
            SortedSet providers = liquibaseConfiguration.getProviders();
            StageValueProvider stageValueProvider = FlowCommandStep.getStageValueProvider(providers);
            try {
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)flowValueProvider);
                liquibaseConfiguration.registerProvider((ConfigurationValueProvider)stageValueProvider);
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Executing Stage: " + stageName));
                for (Action action : stage.getActions()) {
                    this.runAction(resultsBuilder, action, stage, flowFile, stageValueProvider);
                    Integer exitStatus = (Integer)resultsBuilder.getResult("exitCode");
                    if (exitStatus != null) {
                        break;
                    }
                    String key = action.getCommand().toUpperCase();
                    resultsValueProvider.addResults(key, (CommandResults)resultsBuilder.getResult(key));
                }
            }
            finally {
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)flowValueProvider);
                liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)stageValueProvider);
            }
        });
    }

    private static StageValueProvider getStageValueProvider(SortedSet<ConfigurationValueProvider> providers) {
        Integer precedence = providers.stream().filter(provider -> provider instanceof StageValueProvider).map(ConfigurationValueProvider::getPrecedence).max(Comparator.naturalOrder()).orElse(251);
        StageValueProvider stageValueProvider = new StageValueProvider(precedence + 1);
        stageValueProvider.addExitCode(0);
        return stageValueProvider;
    }

    protected void runAction(CommandResultsBuilder resultsBuilder, Action action, Stage stage, FlowFile flowFile, StageValueProvider stageValueProvider) throws CommandExecutionException {
        String originalConditionText;
        Condition condition = action.getCondition();
        if (condition != null) {
            originalConditionText = condition.getOriginalConditionText().replace(FlowStringUtil.class.getSimpleName() + ".", "");
            if (!condition.evaluate()) {
                String actionString = action.toString();
                Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping action: " + actionString + " because condition '" + originalConditionText + "' evaluated to false."));
                return;
            }
        } else {
            originalConditionText = null;
        }
        try {
            Scope.getCurrentScope().addMdcValue("liquibaseCommandName", "flow");
            CommandScope commandScope = resultsBuilder.getCommandScope();
            HashMap<String, Object> scopedValues = new HashMap<String, Object>();
            scopedValues.put(FLOW_SHELL_INTERPRETER.getName(), commandScope.getArgumentValue(FLOW_SHELL_INTERPRETER));
            Scope.child(scopedValues, () -> {
                Map<String, Object> userMetadata = action.getCombinedUserMetadata(flowFile.getUserMetadata(), stage.getUserMetadata());
                if (!CollectionUtil.createIfNull(userMetadata).isEmpty()) {
                    Scope.getCurrentScope().addMdcValue("userMetadata", userMetadata);
                }
                if (condition != null) {
                    Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s because condition '%s' evaluated to true.", action, originalConditionText)));
                } else {
                    Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s", action)));
                }
                action.execute(resultsBuilder);
                Scope.getCurrentScope().getUI().sendMessage("");
                stageValueProvider.addExitCode(0);
            });
        }
        catch (Exception actionException) {
            this.addExitCodeToVariables(action, actionException, stageValueProvider);
            if (action.getContinueOnError().booleanValue()) {
                FlowCommandStep.sendContinueOnErrorMessage(action, actionException);
                return;
            }
            throw new CommandExecutionException((Throwable)actionException);
        }
    }

    private void addExitCodeToVariables(Action action, Exception actionException, StageValueProvider stageValueProvider) {
        if (action instanceof FlowShellCommandAction) {
            int exitCode = ((FlowShellCommandAction)action).getCommandReturnCode();
            stageValueProvider.addExitCode(exitCode);
            return;
        }
        CommandFailedException commandFailedException = this.findCommandFailedException(actionException);
        if (commandFailedException != null) {
            stageValueProvider.addExitCode(commandFailedException.getExitCode());
            return;
        }
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Could not determine action's exit code! Liquibase encountered an error so we are defaulting the exit code to '1'.");
        stageValueProvider.addExitCode(1);
    }

    private static void sendContinueOnErrorMessage(Action action, Exception e) {
        Scope.getCurrentScope().getUI().sendMessage("");
        Scope.getCurrentScope().getUI().sendErrorMessage(String.format("Error executing %s! Continuing flow execution because continueOnError was set to true.", action), (Throwable)e);
        Scope.getCurrentScope().getUI().sendMessage("");
    }

    private String createBanner(String message) {
        return String.format("%s%n* %n* %s%n* %n%s%n", BANNER, WordUtils.wrap((String)message, (int)(BANNER.length() - 2)), BANNER);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Run a series of commands contained in one or more stages, as configured in a liquibase flow-file."));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)DEFAULT_FLOW_FILE_NAME).description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)true).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands. EXAMPLES: bash, sh, cmd.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)false).description("Do not delete temporary files created by the shell command execution").build();
        FLOW_FILE_DTO = commandBuilder.argument("flowFileDTO", FlowFile.class).description("An already loaded FlowFile object").hidden().build();
    }
}

