/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog;

import com.datical.liquibase.ext.changelog.AbstractFormattedChangelogRewriter;
import java.io.IOException;
import java.io.InputStream;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.LiquibaseException;
import liquibase.util.StreamUtil;

public class FormattedSqlChangelogRewriter
extends AbstractFormattedChangelogRewriter {
    @Override
    protected String getSingleLineCommentSequence() {
        return "\\-\\-";
    }

    @Override
    protected String getFirstLine() {
        return "liquibase formatted sql";
    }

    @Override
    protected String getSingleLineCommentOneCharacter() {
        return "-";
    }

    @Override
    protected String getSequenceName() {
        return "SQL";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean supports(String path) throws LiquibaseException {
        try (InputStream is = Scope.getCurrentScope().getResourceAccessor().getExisting(path).openInputStream();){
            String encoding = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
            String changelogString = StreamUtil.readStreamAsString((InputStream)is, (String)encoding);
            boolean bl = changelogString.toLowerCase().contains(this.getFirstLine());
            return bl;
        }
        catch (IOException ioe) {
            throw new LiquibaseException((Throwable)ioe);
        }
    }
}

