/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.DropCompositeTypeChange;
import com.datical.liquibase.ext.appdba.type.TypeAttribute;
import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.statement.compositetype.CreateCompositeTypeStatement;
import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.statement.SqlStatement;
import lombok.Generated;

@DatabaseChange(name="createCompositeType", description="Create new Composite Type", priority=5)
public class CreateCompositeTypeChange
extends AbstractChange {
    private String catalogName;
    private String schemaName;
    private String typeName;
    private List<TypeAttribute> typeAttributes = new ArrayList<TypeAttribute>();

    public boolean supports(Database database) {
        return database instanceof PostgresDatabase;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors errors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (errors.hasErrors()) {
            return errors;
        }
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.addAll(super.validate(database));
        if (this.typeAttributes != null) {
            for (TypeAttribute typeAttribute : this.typeAttributes) {
                if (typeAttribute.getType() == null) {
                    validationErrors.addError("attribute 'type' is required for all attributes");
                }
                if (typeAttribute.getName() != null) continue;
                validationErrors.addError("attribute 'name' is required for all attributes");
            }
        }
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return "Composite type '" + this.typeName + "' successfully created.";
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new CreateCompositeTypeStatement(this.catalogName, this.schemaName, this.typeName, this.typeAttributes)};
    }

    protected Change[] createInverses() {
        DropCompositeTypeChange inverse = new DropCompositeTypeChange();
        inverse.setTypeName(this.getTypeName());
        inverse.setSchemaName(this.getSchemaName());
        inverse.setCatalogName(this.getCatalogName());
        return new Change[]{inverse};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    @DatabaseChangeProperty(requiredForDatabase={"postgresql"}, description="Attributes definitions")
    public List<TypeAttribute> getTypeAttributes() {
        if (this.typeAttributes == null) {
            return new ArrayList<TypeAttribute>();
        }
        return this.typeAttributes;
    }

    @Generated
    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Generated
    public void setTypeAttributes(List<TypeAttribute> typeAttributes) {
        this.typeAttributes = typeAttributes;
    }

    @Generated
    public String getCatalogName() {
        return this.catalogName;
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTypeName() {
        return this.typeName;
    }
}

