/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.analytics;

import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import liquibase.Scope;
import liquibase.analytics.LiquibaseAnalyticsListener;
import liquibase.license.LicenseTrackList;
import liquibase.license.LicenseTrackingArgs;
import liquibase.license.LicenseTrackingListener;
import liquibase.logging.Logger;
import lombok.Generated;

public class LiquibaseLicenseTrackingListener
implements LicenseTrackingListener {
    public int getPriority() {
        return (Boolean)LicenseTrackingArgs.ENABLED.getCurrentValue() != false ? 10 : -1;
    }

    public void handleEvent(LicenseTrackList event) throws Exception {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        Level logLevel = (Level)LicenseTrackingArgs.LOG_LEVEL.getCurrentValue();
        String baseUrl = (String)LicenseTrackingArgs.URL.getCurrentValue();
        Integer timeout = (Integer)LicenseTrackingArgs.TIMEOUT.getCurrentValue();
        URI uri = new URI((baseUrl.endsWith("/") ? baseUrl : baseUrl + "/") + "v1/track");
        LiquibaseAnalyticsListener.sendEvent((Object)event, (URL)uri.toURL(), (Logger)logger, (Level)logLevel, (String)"Sending data to Liquibase license tracking utility. ", (String)"Response from Liquibase license tracking utility: ", (int)timeout, (int)timeout);
    }

    @Generated
    public LiquibaseLicenseTrackingListener() {
    }
}

