/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.mockdata.engine.generator.advanced.finnegan;

import com.dbeaver.ee.mockdata.engine.generator.advanced.AdvancedStringValueGenerator;
import com.dbeaver.ee.mockdata.engine.generator.advanced.finnegan.Finnegan;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.CommonUtils;

public class FinneganTextGenerator
extends AdvancedStringValueGenerator {
    private Finnegan finnegan;
    private String schema;
    private int minWordCount;
    private int maxWordCount;
    private long startSeed;

    @Override
    public void init(DBSDataManipulator container, DBSAttributeBase attribute, Map<String, Object> properties) throws DBException {
        super.init(container, attribute, properties);
        this.schema = CommonUtils.toString((Object)properties.get("schema"));
        this.minWordCount = CommonUtils.toInt((Object)properties.get("minWordCount"), (int)5);
        this.maxWordCount = CommonUtils.toInt((Object)properties.get("maxWordCount"), (int)10);
        this.startSeed = System.currentTimeMillis();
        try {
            Field field = Finnegan.class.getField(this.schema.toUpperCase(Locale.ENGLISH));
            this.finnegan = (Finnegan)field.get(null);
        }
        catch (Throwable e) {
            throw new DBException("Bad schema: " + this.schema, e);
        }
    }

    @Override
    protected Object generateOneValue(DBRProgressMonitor monitor) throws DBException, IOException {
        return this.finnegan.sentence(this.startSeed++, this.minWordCount, this.maxWordCount, new String[]{",", ",", ",", ";"}, new String[]{".", ".", ".", "!", "?", "..."}, 0.17);
    }
}

