/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.qm.serializer;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMetaObjectType;

public class QMTypeAdapter
implements JsonSerializer<QMMObject>,
JsonDeserializer<QMMObject> {
    private static final String EVENT_TYPE_FIELD = "type";

    public QMMObject deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        JsonElement eventTypeElement = jsonObject.get(EVENT_TYPE_FIELD);
        if (eventTypeElement == null) {
            throw new JsonParseException("Event type not present: " + String.valueOf(jsonElement));
        }
        Class resultClass = QMMetaObjectType.valueOf((String)eventTypeElement.getAsString()).getObjectClass();
        if (resultClass == null) {
            throw new JsonParseException("Unknown event: " + String.valueOf(eventTypeElement));
        }
        return (QMMObject)jsonDeserializationContext.deserialize(jsonElement, (Type)resultClass);
    }

    public JsonElement serialize(QMMObject qmmObject, Type type, JsonSerializationContext jsonSerializationContext) {
        return jsonSerializationContext.serialize((Object)qmmObject);
    }
}

