/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.data;

import com.dbeaver.model.NoSQLDataType;
import com.dbeaver.model.document.DocumentDataManager;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.StringWriter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.utils.IntKeyMap;

public class DBDocumentUtils {
    private static final Log log = Log.getLog(DBDocumentUtils.class);
    private static Gson DEFAULT_JSON_BUILDER = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'").serializeNulls().create();

    public static DocumentDataManager getDocumentDataManager(DBPDataSource dataSource) {
        return (DocumentDataManager)DBUtils.getAdapter(DocumentDataManager.class, (Object)dataSource);
    }

    public static String convertValueToJson(DBPDataSource dataSource, Object value) {
        if (value == null) {
            return "";
        }
        DocumentDataManager dataManager = DBDocumentUtils.getDocumentDataManager(dataSource);
        if (dataManager != null) {
            StringWriter out = new StringWriter();
            dataManager.serializeDocument(value, out);
            return out.toString();
        }
        return DEFAULT_JSON_BUILDER.toJson(value);
    }

    public static DBSDataType getDocumentDataType(DBPDataSource dataSource, int typeId) {
        DocumentDataManager dataManager = DBDocumentUtils.getDocumentDataManager(dataSource);
        if (dataManager != null) {
            return dataManager.getDocumentDataType(typeId);
        }
        return null;
    }

    public static <DATASOURCE extends DBPDataSource> IntKeyMap<NoSQLDataType> makeDocumentDataTypes(DATASOURCE dataSource) {
        IntKeyMap dataTypes = new IntKeyMap();
        NoSQLDataType.TypeName[] typeNameArray = NoSQLDataType.TypeName.values();
        int n = typeNameArray.length;
        int n2 = 0;
        while (n2 < n) {
            NoSQLDataType.TypeName typeName = typeNameArray[n2];
            dataTypes.put(typeName.getTypeId(), new NoSQLDataType<DATASOURCE>(dataSource, typeName));
            ++n2;
        }
        return dataTypes;
    }
}

