/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.document.data;

import com.dbeaver.model.document.data.DBDocumentUtils;
import com.dbeaver.model.document.data.DBMapValue;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDocument;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataType;

public abstract class DBAbstractDocument<DATASOURCE extends DBPDataSource, SOURCE_TYPE>
implements DBDDocument,
DBDComposite {
    private static final Log log = Log.getLog(DBAbstractDocument.class);
    @NotNull
    protected final DATASOURCE dataSource;
    protected SOURCE_TYPE rawValue;
    protected DBMapValue<DATASOURCE> rawMap;

    public DBAbstractDocument(@NotNull DATASOURCE dataSource, SOURCE_TYPE rawValue) {
        this.dataSource = dataSource;
        this.rawValue = rawValue;
    }

    @NotNull
    public DATASOURCE getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getDocumentContentType() {
        return "text/json";
    }

    @NotNull
    public DBMapValue<DATASOURCE> getRootNode() {
        if (this.rawMap == null) {
            this.rawMap = this.makeRawMap();
        }
        return this.rawMap;
    }

    protected abstract DBMapValue<DATASOURCE> makeRawMap();

    public SOURCE_TYPE getRawValue() {
        return this.rawValue;
    }

    public boolean isNull() {
        return this.rawValue == null;
    }

    public boolean isModified() {
        return this.getRootNode().isModified();
    }

    protected void markModified() {
        this.rawMap.setModified(true);
    }

    public void release() {
    }

    public DBSDataType getDataType() {
        return this.getRootNode();
    }

    @NotNull
    public DBSAttributeBase[] getAttributes() {
        return this.getRootNode().getAttributes();
    }

    @Nullable
    public Object getAttributeValue(@NotNull DBSAttributeBase attribute) throws DBCException {
        return this.getRootNode().getAttributeValue(attribute);
    }

    @Nullable
    public Object getAttributeValue(@NotNull String attributeName) throws DBCException {
        return this.getRootNode().getAttributeValue(attributeName);
    }

    public void setAttributeValue(@NotNull DBSAttributeBase attribute, Object value) throws DBCException {
        this.getRootNode().setAttributeValue(attribute, value);
        this.markModified();
    }

    public String toString() {
        return DBDocumentUtils.convertValueToJson(this.dataSource, this.getRawValue());
    }
}

