/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.model.datasource.parameters.registry;

import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.datasource.parameters.DBPParametersProvider;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.google.gson.Strictness;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.WorkspaceConfigEventManager;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.secret.DBSSecretController;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public class DBPParametersProviderRegistry {
    private static final Log log = Log.getLog(DBPParametersProviderRegistry.class);
    private static final String EXTENSION_ID = "com.dbeaver.parametersProvider";
    private static final String PROVIDER_TAG = "parametersProvider";
    public static final String PARAMETERS_CONFIGURATION_JSON = "parameters-provider-configuration.json";
    private static final String PROVIDER_ID_FIELD = "providerId";
    private static final Gson saveSecuredPropsGson = PropertySerializationUtils.baseSecurePropertiesGsonBuilder().create();
    private static final Gson saveNonSecurePropsGson = PropertySerializationUtils.baseNonSecurePropertiesGsonBuilder().create();
    private static final Gson saveAllPropsSaveGson = new GsonBuilder().setPrettyPrinting().setStrictness(Strictness.LENIENT).create();
    private static DBPParametersProviderRegistry instance = null;
    private final Map<String, DBPParametersProviderDescriptor> providers = new LinkedHashMap<String, DBPParametersProviderDescriptor>();
    private Map<String, DBPParametersConfiguration> providerConfigurations;
    private volatile boolean securedPropertiesLoaded = false;

    private DBPParametersProviderRegistry() {
        WorkspaceConfigEventManager.addConfigChangedListener((String)PARAMETERS_CONFIGURATION_JSON, o -> this.reloadProviderConfigurations());
        DBPApplication app = DBWorkbench.getPlatform().getApplication();
        if (!app.isMultiuser() && app.isDistributed()) {
            WorkspaceConfigEventManager.addConfigChangedListener((String)PARAMETERS_CONFIGURATION_JSON, o -> this.resetAllCredentials());
        }
    }

    private void resetAllCredentials() {
        SMSession workspaceSession = DBWorkbench.getPlatform().getWorkspace().getWorkspaceSession();
        if (workspaceSession == null) {
            return;
        }
        for (DBPParametersConfiguration dBPParametersConfiguration : this.getAllConfigurations(this.securedPropertiesLoaded)) {
            try {
                DBPParametersProvider<?> provider = this.getProviderDescriptor(dBPParametersConfiguration.getProviderId()).getInstance();
                provider.invalidateCredentials(workspaceSession, dBPParametersConfiguration);
            }
            catch (Exception e) {
                log.error((Object)("Error invalidating provider credentials: " + dBPParametersConfiguration.getProviderId() + ":" + dBPParametersConfiguration.getConfigurationId()), (Throwable)e);
            }
        }
    }

    public static synchronized DBPParametersProviderRegistry getInstance() {
        if (instance == null) {
            instance = new DBPParametersProviderRegistry();
            instance.loadExtensions(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private void loadExtensions(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor(EXTENSION_ID);
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if (PROVIDER_TAG.equals(ext.getName())) {
                DBPParametersProviderDescriptor descriptor = new DBPParametersProviderDescriptor(ext);
                this.providers.put(descriptor.getId(), descriptor);
            }
            ++n2;
        }
    }

    @NotNull
    public DBPParametersProviderDescriptor getProviderDescriptor(@NotNull String providerId) throws DBException {
        DBPParametersProviderDescriptor providerDescriptor = this.providers.get(providerId);
        if (providerDescriptor == null) {
            throw new DBException("No such provider '" + providerId + "'");
        }
        return providerDescriptor;
    }

    @NotNull
    public List<DBPParametersProviderDescriptor> getAllDescriptors() {
        return this.providers.values().stream().toList();
    }

    @NotNull
    public List<? extends DBPParametersConfiguration> getAllConfigurations(boolean loadSecureProperties) {
        if (this.providerConfigurations == null) {
            this.reloadProviderConfigurations();
        }
        if (loadSecureProperties) {
            this.loadSecureProperties();
        }
        return new ArrayList<DBPParametersConfiguration>(this.providerConfigurations.values());
    }

    @Nullable
    public DBPParametersConfiguration getProviderConfiguration(@NotNull String configurationId) throws DBCException {
        return this.getProviderConfiguration(configurationId, DBPParametersConfiguration.class, false);
    }

    @Nullable
    public <T extends DBPParametersConfiguration> T getProviderConfiguration(@NotNull String configurationId, @NotNull Class<T> configurationClass, boolean loadSecureProperties) {
        DBPParametersConfiguration config;
        if (this.providerConfigurations == null) {
            this.reloadProviderConfigurations();
        }
        if (loadSecureProperties) {
            this.loadSecureProperties();
        }
        if ((config = this.providerConfigurations.get(configurationId)) == null) {
            return null;
        }
        if (configurationClass.isAssignableFrom(config.getClass())) {
            return (T)config;
        }
        return null;
    }

    private synchronized void loadSecureProperties() {
        if (this.securedPropertiesLoaded) {
            return;
        }
        if (this.providerConfigurations == null) {
            this.reloadProviderConfigurations();
        }
        if (CommonUtils.isEmpty(this.providerConfigurations)) {
            return;
        }
        DBSSecretController secretController = null;
        try {
            secretController = DBSSecretController.getGlobalSecretController();
        }
        catch (DBException e) {
            log.error((Object)"Error getting secret controller", (Throwable)e);
        }
        if (secretController == null) {
            log.warn((Object)"No secret controller available, secured properties won't be loaded");
            return;
        }
        for (DBPParametersConfiguration configuration : this.providerConfigurations.values()) {
            if (!this.ignoreGlobalConfigurationFlag() && configuration.isGlobalConfiguration() || !this.useSecretStorage()) continue;
            try {
                InstanceCreator creator = type -> configuration;
                Gson gson = saveAllPropsSaveGson.newBuilder().registerTypeAdapter(configuration.getClass(), (Object)creator).create();
                String secretId = this.getSecretId(configuration);
                String secret = secretController.getPrivateSecretValue(secretId);
                if (CommonUtils.isEmpty((String)secret)) continue;
                gson.fromJson(secret, configuration.getClass());
            }
            catch (Exception e) {
                log.error((Object)"Error reading secret", (Throwable)e);
            }
        }
        this.securedPropertiesLoaded = true;
    }

    private synchronized void reloadProviderConfigurations() {
        LinkedHashMap<String, DBPParametersConfiguration> configurations = new LinkedHashMap<String, DBPParametersConfiguration>();
        String config = this.readConfigurationFile();
        if (CommonUtils.isEmpty((String)config)) {
            this.providerConfigurations = new LinkedHashMap<String, DBPParametersConfiguration>();
            return;
        }
        List allConfigurationsArray = (List)saveNonSecurePropsGson.fromJson(config, new TypeToken<List<Map<String, Object>>>(){}.getType());
        for (Map providerConfiguration : allConfigurationsArray) {
            String providerId = JSONUtils.getString((Map)providerConfiguration, (String)PROVIDER_ID_FIELD);
            if (CommonUtils.isEmpty((String)providerId)) {
                log.warn((Object)"Parameters provider configuration without provider id was found, skipped");
                log.trace((Object)("Parameters provider configuration without provider id: " + String.valueOf(providerConfiguration)));
                continue;
            }
            DBPParametersProviderDescriptor providerDescriptor = this.providers.get(providerId);
            if (providerDescriptor == null) continue;
            DBPParametersConfiguration parsedConfig = this.parseConfiguration(providerConfiguration, providerDescriptor);
            configurations.put(parsedConfig.getConfigurationId(), parsedConfig);
        }
        this.providerConfigurations = new LinkedHashMap<String, DBPParametersConfiguration>(configurations);
    }

    private DBPParametersConfiguration parseConfiguration(@NotNull Map<String, Object> providerConfiguration, @NotNull DBPParametersProviderDescriptor providerDescriptor) {
        DBPParametersProvider<?> providerInstance = providerDescriptor.getInstance();
        Object config = providerInstance.createDefaultConfiguration();
        InstanceCreator defaultConfigCreator = type -> config;
        Gson gson = saveAllPropsSaveGson.newBuilder().registerTypeAdapter(config.getClass(), (Object)defaultConfigCreator).create();
        return (DBPParametersConfiguration)gson.fromJson(gson.toJson(providerConfiguration), providerInstance.createDefaultConfiguration().getClass());
    }

    private boolean useSecretStorage() {
        return !DBWorkbench.getPlatform().getApplication().isMultiuser();
    }

    private boolean ignoreGlobalConfigurationFlag() {
        return this.useSecretStorage() && !DBWorkbench.getPlatform().getApplication().isDistributed();
    }

    @NotNull
    public DBPParametersProviderDescriptor getProviderByConfigurationId(@NotNull String configurationId) throws DBException {
        DBPParametersConfiguration configuration = this.getProviderConfiguration(configurationId);
        if (configuration == null) {
            throw new DBException("Configuration not found: " + configurationId);
        }
        return this.getProviderDescriptor(configuration.getProviderId());
    }

    public synchronized DBPParametersConfiguration addOrUpdateConfiguration(@NotNull DBPParametersConfiguration configuration) throws DBException {
        block5: {
            try {
                if (DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) break block5;
                log.warn((Object)"The user has no permission to save parameters provider configuration");
                return null;
            }
            catch (Exception e) {
                log.error((Object)"Error saving configuration", (Throwable)e);
                throw e;
            }
        }
        if (!configuration.valid()) {
            throw new DBException("Configurations is no valid");
        }
        if (this.providerConfigurations == null) {
            this.reloadProviderConfigurations();
        }
        this.providerConfigurations.put(configuration.getConfigurationId(), configuration);
        this.saveConfigurationFile();
        return configuration;
    }

    public synchronized void deleteConfiguration(@NotNull String configurationId) throws DBException {
        if (!DBWorkbench.getPlatform().getWorkspace().hasRealmPermission("configuration-manager")) {
            log.warn((Object)"The user has no permission to save parameters provider configuration");
            return;
        }
        if (this.providerConfigurations == null) {
            this.reloadProviderConfigurations();
        }
        this.providerConfigurations.remove(configurationId);
        this.saveConfigurationFile();
    }

    private void saveConfigurationFile() throws DBException {
        StringBuilder configurationFileDataBuilder = new StringBuilder();
        configurationFileDataBuilder.append("[\n");
        boolean useSecretStorage = this.useSecretStorage();
        boolean forceEncryptSensitiveData = this.ignoreGlobalConfigurationFlag();
        DBSSecretController secretController = DBSSecretController.getGlobalSecretController();
        ArrayList<String> serializedConfigurations = new ArrayList<String>();
        for (DBPParametersConfiguration configuration : this.providerConfigurations.values()) {
            if (forceEncryptSensitiveData || !configuration.isGlobalConfiguration()) {
                String configurationJson = saveNonSecurePropsGson.toJson((Object)configuration);
                serializedConfigurations.add(configurationJson);
                if (!useSecretStorage) continue;
                String secretId = this.getSecretId(configuration);
                String securedProperties = saveSecuredPropsGson.toJson((Object)configuration);
                if (!CommonUtils.isNotEmpty((String)securedProperties) || PropertySerializationUtils.EMPTY_JSON_OBJECT.equals(securedProperties)) continue;
                secretController.setPrivateSecretValue(secretId, securedProperties);
                continue;
            }
            serializedConfigurations.add(saveAllPropsSaveGson.toJson((Object)configuration));
        }
        secretController.flushChanges();
        configurationFileDataBuilder.append(String.join((CharSequence)",\n", serializedConfigurations));
        configurationFileDataBuilder.append("\n]");
        DBWorkbench.getPlatform().getConfigurationController().saveConfigurationFile(PARAMETERS_CONFIGURATION_JSON, configurationFileDataBuilder.toString());
    }

    private String getSecretId(DBPParametersConfiguration configuration) {
        return configuration.getProviderId() + "/properties/" + configuration.getConfigurationId();
    }

    @Nullable
    private String readConfigurationFile() {
        try {
            return DBWorkbench.getPlatform().getConfigurationController().loadConfigurationFile(PARAMETERS_CONFIGURATION_JSON);
        }
        catch (DBException e) {
            log.error((Object)"Error loading parameters provider configuration file", (Throwable)e);
            return null;
        }
    }

    public DBPParametersProviderDescriptor getProviderOrNull(String providerId) {
        try {
            return this.getProviderDescriptor(providerId);
        }
        catch (DBException e) {
            log.debug((Object)e);
            return null;
        }
    }
}

