/*
 * Decompiled with CFR 0.152.
 */
package com.influxdb.query.dsl;

import com.influxdb.query.dsl.Expression;
import com.influxdb.query.dsl.HasImports;
import com.influxdb.query.dsl.VariableAssignment;
import com.influxdb.query.dsl.functions.AbstractFunctionCallFlux;
import com.influxdb.query.dsl.functions.AbstractFunctionFlux;
import com.influxdb.query.dsl.functions.AbstractParametrizedFlux;
import com.influxdb.query.dsl.functions.AggregateWindow;
import com.influxdb.query.dsl.functions.ArrayFromFlux;
import com.influxdb.query.dsl.functions.ColumnsFlux;
import com.influxdb.query.dsl.functions.CountFlux;
import com.influxdb.query.dsl.functions.CovarianceFlux;
import com.influxdb.query.dsl.functions.CumulativeSumFlux;
import com.influxdb.query.dsl.functions.DerivativeFlux;
import com.influxdb.query.dsl.functions.DifferenceFlux;
import com.influxdb.query.dsl.functions.DistinctFlux;
import com.influxdb.query.dsl.functions.DropFlux;
import com.influxdb.query.dsl.functions.DuplicateFlux;
import com.influxdb.query.dsl.functions.ElapsedFlux;
import com.influxdb.query.dsl.functions.ExpressionFlux;
import com.influxdb.query.dsl.functions.FillFlux;
import com.influxdb.query.dsl.functions.FilterFlux;
import com.influxdb.query.dsl.functions.FirstFlux;
import com.influxdb.query.dsl.functions.FromFlux;
import com.influxdb.query.dsl.functions.GroupFlux;
import com.influxdb.query.dsl.functions.IntegralFlux;
import com.influxdb.query.dsl.functions.InterpolateLinearFlux;
import com.influxdb.query.dsl.functions.JoinFlux;
import com.influxdb.query.dsl.functions.KeepFlux;
import com.influxdb.query.dsl.functions.LastFlux;
import com.influxdb.query.dsl.functions.LimitFlux;
import com.influxdb.query.dsl.functions.MapFlux;
import com.influxdb.query.dsl.functions.MaxFlux;
import com.influxdb.query.dsl.functions.MeanFlux;
import com.influxdb.query.dsl.functions.MinFlux;
import com.influxdb.query.dsl.functions.PivotFlux;
import com.influxdb.query.dsl.functions.QuantileFlux;
import com.influxdb.query.dsl.functions.RangeFlux;
import com.influxdb.query.dsl.functions.ReduceFlux;
import com.influxdb.query.dsl.functions.RenameFlux;
import com.influxdb.query.dsl.functions.SampleFlux;
import com.influxdb.query.dsl.functions.SetFlux;
import com.influxdb.query.dsl.functions.SkewFlux;
import com.influxdb.query.dsl.functions.SortFlux;
import com.influxdb.query.dsl.functions.SpreadFlux;
import com.influxdb.query.dsl.functions.StddevFlux;
import com.influxdb.query.dsl.functions.SumFlux;
import com.influxdb.query.dsl.functions.TailFlux;
import com.influxdb.query.dsl.functions.TimeShiftFlux;
import com.influxdb.query.dsl.functions.ToBoolFlux;
import com.influxdb.query.dsl.functions.ToDurationFlux;
import com.influxdb.query.dsl.functions.ToFloatFlux;
import com.influxdb.query.dsl.functions.ToFlux;
import com.influxdb.query.dsl.functions.ToIntFlux;
import com.influxdb.query.dsl.functions.ToStringFlux;
import com.influxdb.query.dsl.functions.ToTimeFlux;
import com.influxdb.query.dsl.functions.ToUIntFlux;
import com.influxdb.query.dsl.functions.TruncateTimeColumnFlux;
import com.influxdb.query.dsl.functions.UnionFlux;
import com.influxdb.query.dsl.functions.WindowFlux;
import com.influxdb.query.dsl.functions.YieldFlux;
import com.influxdb.query.dsl.functions.properties.FunctionsParameters;
import com.influxdb.query.dsl.functions.properties.TimeInterval;
import com.influxdb.query.dsl.functions.restriction.Restrictions;
import com.influxdb.query.dsl.utils.ImportUtils;
import com.influxdb.utils.Arguments;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Flux
implements HasImports,
Expression {
    protected FunctionsParameters functionsParameters = FunctionsParameters.of();
    protected Set<String> imports;

    @Nonnull
    public static FromFlux from(@Nonnull String bucket) {
        Arguments.checkNonEmpty((String)bucket, (String)"Bucket name");
        return new FromFlux().withBucket(bucket);
    }

    @Nonnull
    public static FromFlux from(@Nonnull String bucket, @Nonnull Collection<String> hosts) {
        Arguments.checkNonEmpty((String)bucket, (String)"Bucket name");
        Arguments.checkNotNull(hosts, (String)"Hosts are required");
        return new FromFlux().withBucket(bucket).withHosts(hosts);
    }

    @Nonnull
    public static FromFlux from(@Nonnull String bucket, @Nonnull String[] hosts) {
        Arguments.checkNonEmpty((String)bucket, (String)"Database name");
        Arguments.checkNotNull((Object)hosts, (String)"Hosts are required");
        return new FromFlux().withBucket(bucket).withHosts(hosts);
    }

    public final AggregateWindow aggregateWindow() {
        return new AggregateWindow(this);
    }

    @Nonnull
    public final AggregateWindow aggregateWindow(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull String namedFunction) {
        Arguments.checkNotNull((Object)every, (String)"Every is required");
        Arguments.checkNotNull((Object)everyUnit, (String)"Every ChronoUnit is required");
        return new AggregateWindow(this).withEvery(every, everyUnit).withAggregateFunction(namedFunction);
    }

    @Nonnull
    public static ArrayFromFlux arrayFrom() {
        return new ArrayFromFlux();
    }

    @SafeVarargs
    @Nonnull
    public static ArrayFromFlux arrayFrom(Map<String, Object> ... rows) {
        return Flux.arrayFrom().withRow(rows);
    }

    @Nonnull
    public static JoinFlux join() {
        return new JoinFlux();
    }

    @Nonnull
    public static JoinFlux join(@Nonnull String name1, @Nonnull Flux table1, @Nonnull String name2, @Nonnull Flux table2, @Nonnull String tag, @Nonnull String method) {
        return new JoinFlux().withTable(name1, table1).withTable(name2, table2).withOn(tag).withMethod(method);
    }

    @Nonnull
    public final KeepFlux keep() {
        return new KeepFlux(this);
    }

    @Nonnull
    public final KeepFlux keep(@Nonnull Collection<String> columns) {
        return new KeepFlux(this).withColumns(columns);
    }

    @Nonnull
    public final KeepFlux keep(@Nonnull String[] columns) {
        return new KeepFlux(this).withColumns(columns);
    }

    @Nonnull
    public final KeepFlux keep(@Nonnull String function) {
        return new KeepFlux(this).withFunction(function);
    }

    @Nonnull
    public final ColumnsFlux columns() {
        return new ColumnsFlux(this);
    }

    @Nonnull
    public final ColumnsFlux columns(@Nonnull String column) {
        return new ColumnsFlux(this).withColumn(column);
    }

    @Nonnull
    public final CountFlux count() {
        return new CountFlux(this);
    }

    @Nonnull
    public final CountFlux count(@Nonnull String column) {
        return new CountFlux(this).withColumn(column);
    }

    @Nonnull
    public final CovarianceFlux covariance() {
        return new CovarianceFlux(this);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull Collection<String> columns) {
        return new CovarianceFlux(this).withColumns(columns);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull String[] columns) {
        return new CovarianceFlux(this).withColumns(columns);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull Collection<String> columns, boolean pearsonr) {
        return new CovarianceFlux(this).withColumns(columns).withPearsonr(pearsonr);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull String[] columns, boolean pearsonr) {
        return new CovarianceFlux(this).withColumns(columns).withPearsonr(pearsonr);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull Collection<String> columns, @Nonnull String valueDst) {
        return new CovarianceFlux(this).withColumns(columns).withValueDst(valueDst);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull String[] columns, @Nonnull String valueDst) {
        return new CovarianceFlux(this).withColumns(columns).withValueDst(valueDst);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull Collection<String> columns, boolean pearsonr, @Nonnull String valueDst) {
        return new CovarianceFlux(this).withColumns(columns).withPearsonr(pearsonr).withValueDst(valueDst);
    }

    @Nonnull
    public final CovarianceFlux covariance(@Nonnull String[] columns, boolean pearsonr, @Nonnull String valueDst) {
        return new CovarianceFlux(this).withColumns(columns).withPearsonr(pearsonr).withValueDst(valueDst);
    }

    @Nonnull
    public final CumulativeSumFlux cumulativeSum() {
        return new CumulativeSumFlux(this);
    }

    @Nonnull
    public final CumulativeSumFlux cumulativeSum(@Nonnull String[] columns) {
        return new CumulativeSumFlux(this).withColumns(columns);
    }

    @Nonnull
    public final CumulativeSumFlux cumulativeSum(@Nonnull Collection<String> columns) {
        return new CumulativeSumFlux(this).withColumns(columns);
    }

    @Nonnull
    public final DerivativeFlux derivative() {
        return new DerivativeFlux(this);
    }

    @Nonnull
    public final DerivativeFlux derivative(@Nonnull Long duration, @Nonnull ChronoUnit unit) {
        return new DerivativeFlux(this).withUnit(duration, unit);
    }

    @Nonnull
    public final DifferenceFlux difference() {
        return new DifferenceFlux(this);
    }

    @Nonnull
    public final DifferenceFlux difference(boolean nonNegative) {
        return new DifferenceFlux(this).withNonNegative(nonNegative);
    }

    @Nonnull
    public final DifferenceFlux difference(@Nonnull Collection<String> columns) {
        return new DifferenceFlux(this).withColumns(columns);
    }

    @Nonnull
    public final DifferenceFlux difference(@Nonnull String[] columns) {
        return new DifferenceFlux(this).withColumns(columns);
    }

    @Nonnull
    public final DifferenceFlux difference(@Nonnull Collection<String> columns, boolean nonNegative) {
        return new DifferenceFlux(this).withColumns(columns).withNonNegative(nonNegative);
    }

    @Nonnull
    public final DifferenceFlux difference(@Nonnull String[] columns, boolean nonNegative) {
        return new DifferenceFlux(this).withColumns(columns).withNonNegative(nonNegative);
    }

    @Nonnull
    public final DistinctFlux distinct() {
        return new DistinctFlux(this);
    }

    @Nonnull
    public final DistinctFlux distinct(@Nonnull String column) {
        return new DistinctFlux(this).withColumn(column);
    }

    @Nonnull
    public final DropFlux drop() {
        return new DropFlux(this);
    }

    @Nonnull
    public final DropFlux drop(@Nonnull Collection<String> columns) {
        return new DropFlux(this).withColumns(columns);
    }

    @Nonnull
    public final DropFlux drop(@Nonnull String[] columns) {
        return new DropFlux(this).withColumns(columns);
    }

    @Nonnull
    public final DropFlux drop(@Nonnull String function) {
        return new DropFlux(this).withFunction(function);
    }

    @Nonnull
    public final DuplicateFlux duplicate() {
        return new DuplicateFlux(this);
    }

    @Nonnull
    public final DuplicateFlux duplicate(@Nonnull String column, @Nonnull String as) {
        return new DuplicateFlux(this).withColumn(column).withAs(as);
    }

    @Nonnull
    public final ElapsedFlux elapsed(@Nonnull TimeInterval unit) {
        return new ElapsedFlux(this).withDuration(unit);
    }

    @Nonnull
    public final ElapsedFlux elapsed(@Nonnull int count, @Nonnull ChronoUnit unit) {
        return new ElapsedFlux(this).withDuration(new TimeInterval(Long.valueOf(count), unit));
    }

    @Nonnull
    public final ElapsedFlux elapsed(@Nonnull ChronoUnit unit) {
        return new ElapsedFlux(this).withDuration(new TimeInterval(1L, unit));
    }

    @Nonnull
    public final ElapsedFlux elapsed() {
        return new ElapsedFlux(this).withDuration(new TimeInterval(1L, ChronoUnit.MILLIS));
    }

    @Nonnull
    public final FillFlux fill() {
        return new FillFlux(this);
    }

    @Nonnull
    public final FillFlux fill(@Nonnull Object value) {
        return new FillFlux(this).withValue(value);
    }

    @Nonnull
    public final FilterFlux filter() {
        return new FilterFlux(this);
    }

    @Nonnull
    public final FilterFlux filter(@Nonnull Restrictions restrictions) {
        Arguments.checkNotNull((Object)restrictions, (String)"Restrictions are required");
        return new FilterFlux(this).withRestrictions(restrictions);
    }

    @Nonnull
    public final FirstFlux first() {
        return new FirstFlux(this);
    }

    @Nonnull
    public final GroupFlux group() {
        return new GroupFlux(this);
    }

    @Nonnull
    public final GroupFlux groupBy(@Nonnull String groupBy) {
        Arguments.checkNotNull((Object)groupBy, (String)"GroupBy Columns are required");
        return new GroupFlux(this).withBy(groupBy);
    }

    @Nonnull
    public final GroupFlux groupBy(@Nonnull Collection<String> groupBy) {
        Arguments.checkNotNull(groupBy, (String)"GroupBy Columns are required");
        return new GroupFlux(this).withBy(groupBy);
    }

    @Nonnull
    public final GroupFlux groupBy(@Nonnull String[] groupBy) {
        Arguments.checkNotNull((Object)groupBy, (String)"GroupBy Columns are required");
        return new GroupFlux(this).withBy(groupBy);
    }

    @Nonnull
    public final GroupFlux groupExcept(@Nonnull Collection<String> except) {
        Arguments.checkNotNull(except, (String)"GroupBy Except Columns are required");
        return new GroupFlux(this).withExcept(except);
    }

    @Nonnull
    public final GroupFlux groupExcept(@Nonnull String except) {
        Arguments.checkNotNull((Object)except, (String)"GroupBy Except Column are required");
        return new GroupFlux(this).withExcept(except);
    }

    @Nonnull
    public final GroupFlux groupExcept(@Nonnull String[] except) {
        Arguments.checkNotNull((Object)except, (String)"GroupBy Except Columns are required");
        return new GroupFlux(this).withExcept(except);
    }

    @Nonnull
    public final IntegralFlux integral() {
        return new IntegralFlux(this);
    }

    @Nonnull
    public final IntegralFlux integral(@Nonnull Long duration, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)duration, (String)"Duration is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        return new IntegralFlux(this).withUnit(duration, unit);
    }

    @Nonnull
    public final InterpolateLinearFlux interpolateLinear() {
        return new InterpolateLinearFlux(this);
    }

    @Nonnull
    public final InterpolateLinearFlux interpolateLinear(@Nonnull Long duration, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)duration, (String)"Duration is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        return new InterpolateLinearFlux(this).withEvery(duration, unit);
    }

    @Nonnull
    public final LastFlux last() {
        return new LastFlux(this);
    }

    @Nonnull
    public final LastFlux last(@Nonnull String column) {
        return new LastFlux(this).withColumn(column);
    }

    @Nonnull
    public final LimitFlux limit() {
        return new LimitFlux(this);
    }

    @Nonnull
    public final LimitFlux limit(int numberOfResults) {
        return new LimitFlux(this).withN(numberOfResults);
    }

    @Nonnull
    public final LimitFlux limit(int numberOfResults, int offset) {
        return new LimitFlux(this).withN(numberOfResults).withOffset(offset);
    }

    @Nonnull
    public final MapFlux map() {
        return new MapFlux(this);
    }

    @Nonnull
    public final MapFlux map(@Nonnull String function) {
        return new MapFlux(this).withFunction(function);
    }

    @Nonnull
    public final MaxFlux max() {
        return new MaxFlux(this);
    }

    @Nonnull
    public final MaxFlux max(@Nonnull String column) {
        return new MaxFlux(this).withColumn(column);
    }

    @Nonnull
    public final MeanFlux mean() {
        return new MeanFlux(this);
    }

    @Nonnull
    public final MeanFlux mean(String column) {
        return new MeanFlux(this).withColumn(column);
    }

    @Nonnull
    public final MinFlux min() {
        return new MinFlux(this);
    }

    @Nonnull
    public final MinFlux min(@Nonnull String column) {
        return new MinFlux(this).withColumn(column);
    }

    @Nonnull
    public final QuantileFlux quantile() {
        return new QuantileFlux(this);
    }

    @Nonnull
    public final QuantileFlux quantile(@Nonnull Float quantile) {
        return new QuantileFlux(this).withQuantile(quantile);
    }

    @Nonnull
    public final QuantileFlux quantile(@Nonnull Float quantile, @Nonnull QuantileFlux.MethodType method) {
        return new QuantileFlux(this).withQuantile(quantile).withMethod(method);
    }

    @Nonnull
    public final QuantileFlux quantile(@Nonnull Float quantile, @Nonnull QuantileFlux.MethodType method, @Nonnull Float compression) {
        return new QuantileFlux(this).withQuantile(quantile).withMethod(method).withCompression(compression);
    }

    @Nonnull
    public final QuantileFlux quantile(@Nonnull String column, @Nonnull Float quantile, @Nonnull QuantileFlux.MethodType method, @Nonnull Float compression) {
        return new QuantileFlux(this).withColumn(column).withQuantile(quantile).withMethod(method).withCompression(compression);
    }

    @Nonnull
    public final PivotFlux pivot() {
        return new PivotFlux(this);
    }

    @Nonnull
    public final PivotFlux pivot(@Nonnull String[] rowKey, @Nonnull String[] columnKey, @Nonnull String valueColumn) {
        return new PivotFlux(this).withRowKey(rowKey).withColumnKey(columnKey).withValueColumn(valueColumn);
    }

    @Nonnull
    public final PivotFlux pivot(@Nonnull Collection<String> rowKey, @Nonnull Collection<String> columnKey, @Nonnull String valueColumn) {
        return new PivotFlux(this).withRowKey(rowKey).withColumnKey(columnKey).withValueColumn(valueColumn);
    }

    @Nonnull
    public final RangeFlux range() {
        return new RangeFlux(this);
    }

    @Nonnull
    public final RangeFlux range(@Nonnull Instant start) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        return new RangeFlux(this).withStart(start);
    }

    @Nonnull
    public final RangeFlux range(@Nonnull Instant start, @Nonnull Instant stop) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        return new RangeFlux(this).withStart(start).withStop(stop);
    }

    @Nonnull
    public final RangeFlux range(@Nonnull Long start, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        return new RangeFlux(this).withStart(start, unit);
    }

    @Nonnull
    public final RangeFlux range(@Nonnull Long start, @Nonnull Long stop, @Nonnull ChronoUnit unit) {
        Arguments.checkNotNull((Object)start, (String)"Start is required");
        Arguments.checkNotNull((Object)stop, (String)"Stop is required");
        Arguments.checkNotNull((Object)unit, (String)"ChronoUnit is required");
        return new RangeFlux(this).withStart(start, unit).withStop(stop, unit);
    }

    @Nonnull
    public final RangeFlux range(Long start, Long stop) {
        return new RangeFlux(this).withStart(start).withStop(stop);
    }

    @Nonnull
    public final RangeFlux range(Long start) {
        return new RangeFlux(this).withStart(start);
    }

    public final ReduceFlux reduce() {
        return new ReduceFlux(this);
    }

    public final ReduceFlux reduce(@Nonnull String function, @Nonnull String identity) {
        return new ReduceFlux(this).withFunction(function).withIdentity(identity);
    }

    @Nonnull
    public final RenameFlux rename() {
        return new RenameFlux(this);
    }

    @Nonnull
    public final RenameFlux rename(@Nonnull Map<String, String> columns) {
        return new RenameFlux(this).withColumns(columns);
    }

    @Nonnull
    public final RenameFlux rename(@Nonnull String function) {
        return new RenameFlux(this).withFunction(function);
    }

    @Nonnull
    public final SampleFlux sample() {
        return new SampleFlux(this);
    }

    @Nonnull
    public final SampleFlux sample(int n) {
        return new SampleFlux(this).withN(n);
    }

    @Nonnull
    public final SampleFlux sample(int n, int pos) {
        if (pos >= n) {
            throw new IllegalArgumentException("pos must be less than n");
        }
        return new SampleFlux(this).withN(n).withPos(pos);
    }

    @Nonnull
    public final SetFlux set() {
        return new SetFlux(this);
    }

    @Nonnull
    public final SetFlux set(@Nonnull String key, @Nonnull String value) {
        return new SetFlux(this).withKeyValue(key, value);
    }

    @Nonnull
    public final TimeShiftFlux timeShift() {
        return new TimeShiftFlux(this);
    }

    @Nonnull
    public final TimeShiftFlux timeShift(@Nonnull Long amount, @Nonnull ChronoUnit unit) {
        return new TimeShiftFlux(this).withDuration(amount, unit);
    }

    @Nonnull
    public final TimeShiftFlux timeShift(@Nonnull Long amount, @Nonnull ChronoUnit unit, @Nonnull String[] columns) {
        return new TimeShiftFlux(this).withDuration(amount, unit).withColumns(columns);
    }

    @Nonnull
    public final TimeShiftFlux timeShift(@Nonnull Long amount, @Nonnull ChronoUnit unit, @Nonnull Collection<String> columns) {
        return new TimeShiftFlux(this).withDuration(amount, unit).withColumns(columns);
    }

    @Nonnull
    public final SkewFlux skew() {
        return new SkewFlux(this);
    }

    @Nonnull
    public final SkewFlux skew(@Nonnull String column) {
        return new SkewFlux(this).withColumn(column);
    }

    @Nonnull
    public final SortFlux sort() {
        return new SortFlux(this);
    }

    @Nonnull
    public final SortFlux sort(boolean desc) {
        return new SortFlux(this).withDesc(desc);
    }

    @Nonnull
    public final SortFlux sort(@Nonnull String[] columns) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        return new SortFlux(this).withColumns(columns);
    }

    @Nonnull
    public final SortFlux sort(@Nonnull Collection<String> columns) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        return new SortFlux(this).withColumns(columns);
    }

    @Nonnull
    public final SortFlux sort(@Nonnull String[] columns, boolean desc) {
        Arguments.checkNotNull((Object)columns, (String)"Columns are required");
        return new SortFlux(this).withColumns(columns).withDesc(desc);
    }

    @Nonnull
    public final SortFlux sort(@Nonnull Collection<String> columns, boolean desc) {
        Arguments.checkNotNull(columns, (String)"Columns are required");
        return new SortFlux(this).withColumns(columns).withDesc(desc);
    }

    @Nonnull
    public final SpreadFlux spread() {
        return new SpreadFlux(this);
    }

    @Nonnull
    public final SpreadFlux spread(@Nonnull String column) {
        return new SpreadFlux(this).withColumn(column);
    }

    @Nonnull
    public final StddevFlux stddev() {
        return new StddevFlux(this);
    }

    @Nonnull
    public final StddevFlux stddev(@Nonnull String column) {
        return new StddevFlux(this).withColumn(column);
    }

    @Nonnull
    public final SumFlux sum() {
        return new SumFlux(this);
    }

    @Nonnull
    public final SumFlux sum(@Nonnull String column) {
        return new SumFlux(this).withColumn(column);
    }

    @Nonnull
    public final TailFlux tail() {
        return new TailFlux(this);
    }

    @Nonnull
    public final TailFlux tail(int numberOfResults) {
        return new TailFlux(this).withN(numberOfResults);
    }

    @Nonnull
    public final TailFlux tail(int numberOfResults, int offset) {
        return new TailFlux(this).withN(numberOfResults).withOffset(offset);
    }

    @Nonnull
    public final ToFlux to() {
        return new ToFlux(this);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket) {
        return new ToFlux(this).withBucket(bucket);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org) {
        return new ToFlux(this).withBucket(bucket).withOrg(org);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org, @Nonnull String fieldFn) {
        return new ToFlux(this).withBucket(bucket).withOrg(org).withFieldFunction(fieldFn);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org, @Nonnull String[] tagColumns, @Nonnull String fieldFn) {
        return new ToFlux(this).withBucket(bucket).withOrg(org).withTagColumns(tagColumns).withFieldFunction(fieldFn);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org, @Nonnull Collection<String> tagColumns, @Nonnull String fieldFn) {
        return new ToFlux(this).withBucket(bucket).withOrg(org).withTagColumns(tagColumns).withFieldFunction(fieldFn);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org, @Nonnull String host, @Nonnull String token, @Nonnull String timeColumn, @Nonnull String[] tagColumns, @Nonnull String fieldFn) {
        return new ToFlux(this).withBucket(bucket).withOrg(org).withHost(host).withToken(token).withTimeColumn(timeColumn).withTagColumns(tagColumns).withFieldFunction(fieldFn);
    }

    @Nonnull
    public final ToFlux to(@Nonnull String bucket, @Nonnull String org, @Nonnull String host, @Nonnull String token, @Nonnull String timeColumn, @Nonnull Collection<String> tagColumns, @Nonnull String fieldFn) {
        return new ToFlux(this).withBucket(bucket).withOrg(org).withHost(host).withToken(token).withTimeColumn(timeColumn).withTagColumns(tagColumns).withFieldFunction(fieldFn);
    }

    @Nonnull
    public final ToBoolFlux toBool() {
        return new ToBoolFlux(this);
    }

    @Nonnull
    public final ToIntFlux toInt() {
        return new ToIntFlux(this);
    }

    @Nonnull
    public final ToFloatFlux toFloat() {
        return new ToFloatFlux(this);
    }

    @Nonnull
    public final ToDurationFlux toDuration() {
        return new ToDurationFlux(this);
    }

    @Nonnull
    public final ToStringFlux toStringConvert() {
        return new ToStringFlux(this);
    }

    @Nonnull
    public final ToTimeFlux toTime() {
        return new ToTimeFlux(this);
    }

    @Nonnull
    public final ToUIntFlux toUInt() {
        return new ToUIntFlux(this);
    }

    @Nonnull
    public final TruncateTimeColumnFlux truncateTimeColumn(@Nonnull ChronoUnit unit) {
        return new TruncateTimeColumnFlux(this).withUnit(unit);
    }

    public static UnionFlux union(Flux ... tables) {
        return new UnionFlux().withTables(tables);
    }

    @Nonnull
    public final WindowFlux window() {
        return new WindowFlux(this);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit) {
        Arguments.checkNotNull((Object)every, (String)"Every is required");
        Arguments.checkNotNull((Object)everyUnit, (String)"Every ChronoUnit is required");
        return new WindowFlux(this).withEvery(every, everyUnit);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull Long period, @Nonnull ChronoUnit periodUnit) {
        Arguments.checkNotNull((Object)every, (String)"Every is required");
        Arguments.checkNotNull((Object)everyUnit, (String)"Every ChronoUnit is required");
        Arguments.checkNotNull((Object)period, (String)"Period is required");
        Arguments.checkNotNull((Object)periodUnit, (String)"Period ChronoUnit is required");
        return new WindowFlux(this).withEvery(every, everyUnit).withPeriod(period, periodUnit);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull Long period, @Nonnull ChronoUnit periodUnit, @Nonnull Instant offset) {
        return new WindowFlux(this).withEvery(every, everyUnit).withPeriod(period, periodUnit).withOffset(offset);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull Long period, @Nonnull ChronoUnit periodUnit, @Nonnull Long offset, @Nonnull ChronoUnit offsetUnit) {
        return new WindowFlux(this).withEvery(every, everyUnit).withPeriod(period, periodUnit).withOffset(offset, offsetUnit);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull Long period, @Nonnull ChronoUnit periodUnit, @Nonnull Long offset, @Nonnull ChronoUnit offsetUnit, @Nonnull String timeColumn, @Nonnull String startColumn, @Nonnull String stopColumn) {
        return new WindowFlux(this).withEvery(every, everyUnit).withPeriod(period, periodUnit).withOffset(offset, offsetUnit).withTimeColumn(timeColumn).withStartColumn(startColumn).withStopCol(stopColumn);
    }

    @Nonnull
    public final WindowFlux window(@Nonnull Long every, @Nonnull ChronoUnit everyUnit, @Nonnull Long period, @Nonnull ChronoUnit periodUnit, @Nonnull Instant offset, @Nonnull String timeColumn, @Nonnull String startColumn, @Nonnull String stopColumn) {
        return new WindowFlux(this).withEvery(every, everyUnit).withPeriod(period, periodUnit).withOffset(offset).withTimeColumn(timeColumn).withStartColumn(startColumn).withStopCol(stopColumn);
    }

    @Nonnull
    public final YieldFlux yield() {
        return new YieldFlux(this);
    }

    @Nonnull
    public final YieldFlux yield(@Nonnull String name) {
        return new YieldFlux(this).withName(name);
    }

    @Nonnull
    public final ExpressionFlux expression(@Nonnull String expression) {
        Arguments.checkNonEmpty((String)expression, (String)"Expression");
        return new ExpressionFlux(this, expression);
    }

    @Nonnull
    public final <F extends AbstractParametrizedFlux> F function(@Nonnull Class<F> type) {
        Arguments.checkNotNull(type, (String)"Function type");
        try {
            return (F)((AbstractParametrizedFlux)type.getConstructor(Flux.class).newInstance(this));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <CALL extends AbstractFunctionCallFlux> CALL withPipedFunction(AbstractFunctionFlux<CALL> fun) {
        return fun.invokePiped(this);
    }

    @Nonnull
    public final Flux withPropertyNamed(@Nonnull String property) {
        return this.withPropertyNamed(property, property);
    }

    @Nonnull
    public final Flux withPropertyNamed(@Nonnull String fluxName, @Nonnull String namedProperty) {
        Arguments.checkNonEmpty((String)fluxName, (String)"Flux property name");
        Arguments.checkNonEmpty((String)namedProperty, (String)"Named property");
        this.functionsParameters.putPropertyNamed(fluxName, namedProperty);
        return this;
    }

    @Nonnull
    public final Flux withPropertyValue(@Nonnull String propertyName, @Nullable Object value) {
        Arguments.checkNonEmpty((String)propertyName, (String)"Flux property name");
        this.functionsParameters.putPropertyValue(propertyName, value);
        return this;
    }

    @Nonnull
    public final Flux withFunction(@Nonnull String functionName, @Nullable Object function) {
        Arguments.checkNonEmpty((String)functionName, (String)"functionName");
        this.functionsParameters.putFunctionValue(functionName, function);
        return this;
    }

    @Nonnull
    public final Flux withFunctionNamed(@Nonnull String functionName, @Nonnull String namedProperty) {
        Arguments.checkNonEmpty((String)functionName, (String)"functionName");
        Arguments.checkNonEmpty((String)namedProperty, (String)"namedProperty");
        this.functionsParameters.putFunctionNamed(functionName, namedProperty);
        return this;
    }

    @Nonnull
    public final Flux withPropertyValue(@Nonnull String property, @Nullable Long amount, @Nullable ChronoUnit unit) {
        Arguments.checkNonEmpty((String)property, (String)"Flux property name");
        this.functionsParameters.putPropertyValue(property, amount, unit);
        return this;
    }

    @Nonnull
    public final Flux withPropertyValueEscaped(@Nonnull String property, @Nullable String value) {
        Arguments.checkNonEmpty((String)property, (String)"Flux property name");
        this.functionsParameters.putPropertyValueString(property, value);
        return this;
    }

    public abstract void appendActual(@Nonnull Map<String, Object> var1, @Nonnull StringBuilder var2);

    @Nonnull
    public String toString() {
        return this.toString(new HashMap<String, Object>());
    }

    @Nonnull
    public String toString(@Nonnull Map<String, Object> parameters) {
        return this.toString(parameters, true);
    }

    @Override
    public String toString(@Nonnull Map<String, Object> parameters, boolean prependImports) {
        Arguments.checkNotNull(parameters, (String)"Parameters are required");
        StringBuilder builder = new StringBuilder();
        if (prependImports) {
            builder.append(ImportUtils.getImportsString(this));
        }
        this.appendActual(parameters, builder);
        return builder.toString();
    }

    public VariableAssignment asVariable(String name) {
        return new VariableAssignment(name, this);
    }

    @Override
    public Set<String> getImports() {
        TreeSet<String> collectedImports = new TreeSet<String>();
        this.collectImports(collectedImports);
        return collectedImports;
    }

    public void collectImports(@Nonnull Set<String> collectedImports) {
        if (this.imports != null) {
            collectedImports.addAll(this.imports);
        }
    }

    protected Flux addImport(String pImport) {
        if (this.imports == null) {
            this.imports = new HashSet<String>();
        }
        this.imports.add(pImport);
        return this;
    }
}

