/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.processor;

import com.dbeaver.data.transfer.internal.DTMessages;
import com.dbeaver.data.transfer.mail.SMTPAuthentication;
import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.tools.transfer.IDataTransferEventProcessor;
import org.jkiss.dbeaver.tools.transfer.stream.StreamTransferConsumer;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class SendMailEventProcessor
implements IDataTransferEventProcessor<IDataTransferConsumer<?, ?>> {
    public static final String PROP_PROFILE = "profile";
    public static final String PROP_FROM = "from";
    public static final String PROP_RECIPIENT = "recipient";
    public static final String PROP_SUBJECT = "subject";
    public static final String PROP_BODY = "body";
    public static final String PROP_REPORT_TASK_SUCCESS = "sendOnSuccess";
    public static final String PROP_REPORT_TASK_FAILURE = "sendOnError";
    public static final String PROP_OMIT_RESULT_FILES = "omitResultFiles";
    public static final String PROP_OMIT_EMPTY_RESULT_FILES = "omitEmptyResults";
    public static final String PROP_TRUST_SERVER = "trustServer";
    public static final String PROP_SPLIT_FILES = "splitFiles";
    public static final String PROP_SPLIT_FILE_SIZE = "splitFileSize";
    private static final Log log = Log.getLog(SendMailEventProcessor.class);

    public void processEvent(@NotNull DBRProgressMonitor monitor, @NotNull IDataTransferEventProcessor.Event event, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        this.process(monitor, null, consumer, task, settings);
    }

    public void processError(@NotNull DBRProgressMonitor monitor, @NotNull Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        this.process(monitor, error, consumer, task, settings);
    }

    private void process(@NotNull DBRProgressMonitor monitor, @Nullable Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @Nullable DBTTask task, @NotNull Map<String, Object> settings) throws DBException {
        if (!SendMailEventProcessor.canProceed(error, consumer, settings)) {
            return;
        }
        SMTPProfile profile = SMTPProfileManager.getProfile(CommonUtils.toString((Object)settings.get(PROP_PROFILE)));
        if (profile == null) {
            throw new DBException("Can't find SMTP profile");
        }
        String from = CommonUtils.toString((Object)settings.get(PROP_FROM));
        String recipient = CommonUtils.toString((Object)settings.get(PROP_RECIPIENT));
        String subject = CommonUtils.toString((Object)settings.get(PROP_SUBJECT));
        String body = CommonUtils.nullIfEmpty((String)CommonUtils.toString((Object)settings.get(PROP_BODY)));
        SMTPAuthentication auth = profile.getOrResolveAuthentication();
        if (CommonUtils.isEmptyTrimmed((String)from) && auth != null) {
            from = auth.getUsername();
        }
        if (CommonUtils.isEmptyTrimmed((String)from) || CommonUtils.isEmptyTrimmed((String)recipient) || CommonUtils.isEmptyTrimmed((String)subject)) {
            throw new DBException("Invalid E-Mail configuration: check that \"From\", \"Recipient\" and \"Subject\" fields are filled in");
        }
        Properties properties = new Properties();
        properties.put("mail.smtp.host", profile.getHostname());
        properties.put("mail.smtp.port", (Object)profile.getPort());
        properties.put("mail.smtp.auth", (Object)(auth != null ? 1 : 0));
        properties.put("mail.smtp.starttls.enable", (Object)true);
        if (CommonUtils.toBoolean((Object)settings.get(PROP_TRUST_SERVER))) {
            try {
                properties.put("mail.smtp.socketFactory", SSLHandlerTrustStoreImpl.createNonValidatingSslSocketFactory());
            }
            catch (Exception e) {
                log.error((Object)"Error creating non-validating socket factory", (Throwable)e);
            }
        }
        Session session = Session.getInstance((Properties)properties, (Authenticator)profile.createAuthenticator());
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(Session.class.getClassLoader());
        try {
            try {
                List files;
                MimeMultipart multipart = new MimeMultipart();
                MimeMessage message = new MimeMessage(session);
                message.setFrom((Address)new InternetAddress(from));
                message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)recipient));
                message.setSubject(subject);
                message.setContent((Multipart)multipart);
                if (consumer instanceof StreamTransferConsumer) {
                    StreamTransferConsumer sc = (StreamTransferConsumer)consumer;
                    v0 = sc.getOutputFiles();
                } else {
                    v0 = files = List.of();
                }
                if (CommonUtils.toBoolean((Object)settings.get(PROP_OMIT_RESULT_FILES)) || error != null || files.isEmpty()) {
                    SendMailEventProcessor.send(monitor, body, task, error, (Message)message, (Multipart)multipart);
                } else if (CommonUtils.toBoolean((Object)settings.get(PROP_SPLIT_FILES))) {
                    SendMailEventProcessor.send(monitor, body, task, (Message)message, (Multipart)multipart, files, CommonUtils.toInt((Object)settings.get(PROP_SPLIT_FILE_SIZE)) * 1024 * 1024);
                } else {
                    SendMailEventProcessor.send(monitor, body, task, (Message)message, (Multipart)multipart, files);
                }
            }
            catch (Exception e) {
                throw new DBException("Error sending E-Mail message", (Throwable)e);
            }
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    private static boolean canProceed(@Nullable Throwable error, @NotNull IDataTransferConsumer<?, ?> consumer, @NotNull Map<String, Object> settings) {
        if (error != null) {
            return CommonUtils.getBoolean((Object)settings.get(PROP_REPORT_TASK_FAILURE), (boolean)true);
        }
        if (!CommonUtils.getBoolean((Object)settings.get(PROP_REPORT_TASK_SUCCESS), (boolean)true)) {
            return false;
        }
        if (consumer instanceof StreamTransferConsumer && ((StreamTransferConsumer)consumer).isBeforeFirstRow()) {
            return !CommonUtils.toBoolean((Object)settings.get(PROP_OMIT_EMPTY_RESULT_FILES));
        }
        return true;
    }

    private static void send(@NotNull DBRProgressMonitor monitor, @Nullable String text, @Nullable DBTTask task, @NotNull Message message, @NotNull Multipart multipart, @NotNull List<Path> files) throws MessagingException, IOException {
        for (Path path : files) {
            MimeBodyPart attachment = new MimeBodyPart();
            attachment.attachFile(path.toFile());
            multipart.addBodyPart((BodyPart)attachment);
        }
        SendMailEventProcessor.send(monitor, text, task, null, message, multipart);
    }

    private static void send(@NotNull DBRProgressMonitor monitor, @Nullable String text, @Nullable DBTTask task, @NotNull Message message, @NotNull Multipart multipart, @NotNull List<Path> files, int maxAttachmentSize) throws IOException, MessagingException {
        monitor.beginTask("Compress output files", files.size());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var9_10 = null;
        try (ZipOutputStream zos = new ZipOutputStream((OutputStream)os, StandardCharsets.UTF_8);){
            for (Path path : files) {
                zos.putNextEntry(new ZipEntry(path.getFileName().toString()));
                Throwable throwable2 = null;
                Object var14_20 = null;
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
                    is.transferTo(zos);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
                zos.closeEntry();
                monitor.worked(1);
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        byte[] data = os.toByteArray();
        int total = data.length;
        int parts = (total + maxAttachmentSize - 1) / maxAttachmentSize;
        boolean multiParts = parts > 1;
        Object filename = files.size() == 1 ? IOUtils.getFileNameWithoutExtension((Path)files.get(0).getFileName()) + ".zip" : "files.zip";
        MimeBodyPart attachment = new MimeBodyPart();
        String subject = message.getSubject();
        multipart.addBodyPart((BodyPart)SendMailEventProcessor.body(text, task, null, multiParts));
        multipart.addBodyPart((BodyPart)attachment);
        monitor.beginTask("Send mail", parts);
        int i = 0;
        while (i < parts) {
            int offset = i * maxAttachmentSize;
            int length = Math.min(maxAttachmentSize, total - offset);
            Object name = multiParts ? "%s.%03d".formatted(filename, i + 1) : filename;
            attachment.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource((String)name, data, offset, length)));
            attachment.setFileName((String)name);
            attachment.setDisposition("attachment");
            if (multiParts) {
                message.setSubject("%s (%d/%d)".formatted(subject, i + 1, parts));
                monitor.subTask("Sending part " + (i + 1) + "/" + parts);
            }
            Transport.send((Message)message);
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    private static void send(@NotNull DBRProgressMonitor monitor, @Nullable String text, @Nullable DBTTask task, @Nullable Throwable error, @NotNull Message message, @NotNull Multipart multipart) throws MessagingException {
        multipart.addBodyPart((BodyPart)SendMailEventProcessor.body(text, task, error, false));
        try {
            monitor.beginTask("Send mail", 1);
            Transport.send((Message)message);
        }
        finally {
            monitor.done();
        }
    }

    @NotNull
    private static MimeBodyPart body(@Nullable String text, @Nullable DBTTask task, @Nullable Throwable error, boolean multiParts) throws MessagingException {
        String taskName;
        StringJoiner buffer = new StringJoiner("<br>");
        String string = taskName = task != null ? task.getName() : "<unknown>";
        if (text != null) {
            buffer.add(CommonUtils.escapeHtml((String)text));
            buffer.add("<hr>");
        }
        if (error != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            error.printStackTrace(pw);
            buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_task_failed_text, (Object)taskName));
            buffer.add("<pre>" + CommonUtils.escapeHtml((String)sw.toString().trim()) + "</pre>");
        } else {
            buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_task_success_text, (Object)taskName));
        }
        if (multiParts) {
            buffer.add("");
            buffer.add(DTMessages.data_transfer_event_processor_send_mail_split_files_text);
        }
        buffer.add("");
        buffer.add(NLS.bind((String)DTMessages.data_transfer_event_processor_send_mail_sent_by_text, (Object)GeneralUtils.getProductName()));
        MimeBodyPart body = new MimeBodyPart();
        body.setContent((Object)buffer.toString(), "text/html; charset=UTF-8");
        return body;
    }

    private record ByteArrayDataSource(@NotNull String name, byte[] buf, int offset, int length) implements DataSource
    {
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.buf, this.offset, this.length);
        }

        public OutputStream getOutputStream() throws IOException {
            throw new IOException("Not supported");
        }

        public String getContentType() {
            return "application/octet-stream";
        }

        public String getName() {
            return this.name;
        }
    }
}

