/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.renametrigger;

import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.renametrigger.RenameTriggerStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="renameTrigger", description="Rename Trigger", priority=201)
public class RenameTriggerChange
extends AbstractOracleChange {
    private String schemaName;
    private String triggerName;
    private String newName;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String triggerName) {
        this.triggerName = triggerName;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getConfirmationMessage() {
        return "Trigger has been renamed.";
    }

    public SqlStatement[] generateStatements(Database database) {
        RenameTriggerStatement statement = new RenameTriggerStatement(this.getSchemaName(), this.getTriggerName(), this.getNewName());
        return new SqlStatement[]{statement};
    }
}

