/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.dropSynonym;

import java.text.MessageFormat;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.AbstractOracleChange;
import liquibase.ext.ora.dropSynonym.DropSynonymStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropSynonym", description="Drop synonym", priority=201)
public class DropSynonymChange
extends AbstractOracleChange {
    private Boolean isPublic = false;
    private String synonymSchemaName;
    private String synonymName;
    private Boolean force;

    public Boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(Boolean isPublic) {
        this.isPublic = isPublic;
    }

    public String getSynonymName() {
        return this.synonymName;
    }

    public void setSynonymName(String synonymName) {
        this.synonymName = synonymName;
    }

    public String getSynonymSchemaName() {
        return this.synonymSchemaName;
    }

    public void setSynonymSchemaName(String synonymSchemaName) {
        this.synonymSchemaName = synonymSchemaName;
    }

    public Boolean isForce() {
        return this.force;
    }

    public void setForce(Boolean force) {
        this.force = force;
    }

    public String getConfirmationMessage() {
        return MessageFormat.format("Synonym {0} dropped", this.getSynonymName());
    }

    public SqlStatement[] generateStatements(Database database) {
        DropSynonymStatement statement = new DropSynonymStatement();
        statement.setForce(this.isForce());
        statement.setSynonymName(this.getSynonymName());
        statement.setSynonymSchemaName(this.getSynonymSchemaName());
        statement.setPublic(this.isPublic());
        return new SqlStatement[]{statement};
    }
}

