/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.disabletrigger;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.disabletrigger.DisableTriggerStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DisableTriggerGenerator
extends AbstractSqlGenerator<DisableTriggerStatement> {
    public boolean supports(DisableTriggerStatement disableTriggertStatement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("triggerName", (Object)disableTriggerStatement.getTriggerName());
        return validationErrors;
    }

    public Sql[] generateSql(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder sql = new StringBuilder();
        sql.append("ALTER TRIGGER ");
        if (disableTriggerStatement.getSchemaName() != null) {
            sql.append(disableTriggerStatement.getSchemaName()).append(".");
        }
        if (disableTriggerStatement.getTriggerName() == null) {
            throw new IllegalStateException("Sorry but triggerName must be set");
        }
        sql.append(disableTriggerStatement.getTriggerName()).append(" ");
        sql.append("DISABLE");
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

