/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui.function;

import com.dbeaver.model.ai.AIUtilsPro;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithReturn;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.tasks.ui.wizard.TaskConfigurationWizardDialog;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;
import org.jkiss.utils.CommonUtils;

public class AIFunctionSchemaCompare
implements AIFunction {
    public static final String PARAM_SOURCE_OBJECT = "sourceObject";
    public static final String PARAM_SOURCE_OBJECT_TYPE = "sourceObjectType";
    public static final String PARAM_TARGET_SCHEMA = "targetSchema";
    public static final String TABLE_TYPE = "table";
    public static final String SCHEMA_TYPE = "schema";

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull Map<String, Object> parameters) throws DBException {
        String sourceObjectName = JSONUtils.getString(parameters, (String)PARAM_SOURCE_OBJECT);
        if (CommonUtils.isEmpty((String)sourceObjectName)) {
            throw new DBException("Source object name parameter is missing");
        }
        String sourceObjectType = JSONUtils.getString(parameters, (String)PARAM_SOURCE_OBJECT_TYPE);
        if (CommonUtils.isEmpty((String)sourceObjectType)) {
            throw new DBException("Source object type parameter is missing");
        }
        String targetSchemaName = JSONUtils.getString(parameters, (String)PARAM_TARGET_SCHEMA);
        if (CommonUtils.isEmpty((String)targetSchemaName)) {
            throw new DBException("Target schema name parameter is missing");
        }
        DBSSchema sourceObject = switch (sourceObjectType) {
            case TABLE_TYPE -> AIUtilsPro.findTableInContext((AIFunctionContext)context, (String)sourceObjectName);
            case SCHEMA_TYPE -> AIUtilsPro.findSchemaInContext((AIFunctionContext)context, (String)sourceObjectName);
            default -> throw new DBException("Unknown source object type");
        };
        DBSSchema targetSchema = AIUtilsPro.findSchemaInContext((AIFunctionContext)context, (String)targetSchemaName);
        DBRRunnableWithReturn callback = arg_0 -> AIFunctionSchemaCompare.lambda$0((DBSObject)sourceObject, targetSchema, arg_0);
        callback.runTask(context.getMonitor());
        return new AIFunctionResult(AIFunctionResult.FunctionType.ACTION, "Compare schema between '" + sourceObjectName + "' and '" + targetSchemaName + "'", callback);
    }

    private static /* synthetic */ Object lambda$0(DBSObject dBSObject, DBSSchema dBSSchema, DBRProgressMonitor monitor) throws DBException {
        UIUtils.asyncExec(() -> TaskConfigurationWizardDialog.openNewTaskDialog((IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow(), (DBPProject)NavigatorUtils.getSelectedProject(), (String)"schemaCompare", (IStructuredSelection)new StructuredSelection(List.of(dBSObject, dBSSchema))));
        return null;
    }
}

