/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.ui;

import com.dbeaver.ee.scmp.internal.ui.LBMessages;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import liquibase.Scope;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.DialogUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class ImportLBKeyDialog
extends Dialog {
    private Text liquibaseKeyText;
    private Text messagesText;

    ImportLBKeyDialog(Shell parentShell) {
        super(parentShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Import Liquibase PRO Key");
        Composite composite = (Composite)super.createDialogArea(parent);
        DBPPreferenceStore globalPreferences = DBWorkbench.getPlatform().getPreferenceStore();
        Label infoLabel = new Label(composite, 0);
        infoLabel.setLayoutData((Object)new GridData(768));
        infoLabel.setText(LBMessages.import_lb_key_dialog_info_label);
        Group licenseGroup = UIUtils.createControlGroup((Composite)composite, (String)"Liquibase Key", (int)1, (int)1808, (int)0);
        this.liquibaseKeyText = new Text((Composite)licenseGroup, 2626);
        GridData gd = new GridData(1808);
        gd.heightHint = this.liquibaseKeyText.getLineHeight() * 6;
        gd.widthHint = this.liquibaseKeyText.getLineHeight() * 30;
        this.liquibaseKeyText.setLayoutData((Object)gd);
        String property = System.getProperty("liquibase.license.key");
        if (!CommonUtils.isEmpty((String)property)) {
            this.liquibaseKeyText.setText(property);
        } else {
            String licenseInPreferences = globalPreferences.getString("@dbeaver-prop-lb-lic@");
            if (CommonUtils.isNotEmpty((String)licenseInPreferences)) {
                this.liquibaseKeyText.setText(licenseInPreferences);
            }
        }
        Composite buttonsBar = UIUtils.createPlaceholder((Composite)licenseGroup, (int)2, (int)5);
        UIUtils.createPushButton((Composite)buttonsBar, (String)LBMessages.import_lb_key_dialog_button_paste, (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_PASTE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLBKeyDialog.this.copyKeyFromClipboard();
            }
        });
        UIUtils.createPushButton((Composite)buttonsBar, (String)LBMessages.import_lb_key_dialog_button_load, (Image)PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE")).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportLBKeyDialog.this.loadKeyFromFile();
            }
        });
        Group messagesGroup = UIUtils.createControlGroup((Composite)composite, (String)LBMessages.import_lb_key_dialog_group_messages, (int)1, (int)1808, (int)0);
        this.messagesText = new Text((Composite)messagesGroup, 2634);
        gd.heightHint = this.liquibaseKeyText.getLineHeight() * 5;
        this.messagesText.setLayoutData((Object)gd);
        return parent;
    }

    private void loadKeyFromFile() {
        File file = DialogUtils.openFile((Shell)this.getShell(), (String[])new String[]{"*", "*.txt"});
        if (file != null) {
            try {
                String fileContents = IOUtils.toString((File)file, (String)GeneralUtils.UTF8_ENCODING);
                if (fileContents != null) {
                    this.liquibaseKeyText.setText(fileContents);
                }
            }
            catch (IOException e) {
                DBWorkbench.getPlatformUI().showError("Load Liquibase Key", "Error loading Liquibase PRO Key from file", (Throwable)e);
            }
        }
    }

    private boolean checkLicenseState() {
        this.messagesText.setText("");
        String keyText = this.liquibaseKeyText.getText();
        if (CommonUtils.isNotEmpty((String)keyText)) {
            Location licenseKeyLocation;
            LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
            LicenseInstallResult licenseInstallResult = licenseService.installLicense(new Location[]{licenseKeyLocation = new Location("property liquibaseProLicenseKey", keyText)});
            if (licenseInstallResult == null) {
                this.messagesText.setText("Can't read license key.");
                return false;
            }
            List messagesList = licenseInstallResult.messages;
            if (!CommonUtils.isEmpty((Collection)messagesList)) {
                this.messagesText.setText(String.join((CharSequence)"\n", messagesList));
            }
            if (CommonUtils.isEmpty((String)this.messagesText.getText()) && licenseService.daysTilExpiration() < 1 && !licenseService.licenseIsInstalled()) {
                this.messagesText.setText(LBMessages.import_lb_key_dialog_message_key_expired);
                return false;
            }
            return licenseInstallResult.code == 0;
        }
        return false;
    }

    private void copyKeyFromClipboard() {
        Object textContents = new Clipboard(Display.getCurrent()).getContents((Transfer)TextTransfer.getInstance());
        if (textContents instanceof String) {
            this.liquibaseKeyText.setText(textContents.toString());
        }
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 10, LBMessages.import_lb_key_dialog_button_check_key_state, true);
        this.createButton(parent, 0, LBMessages.import_lb_key_dialog_button_import, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 10) {
            if (this.checkLicenseState()) {
                this.messagesText.setText(LBMessages.import_lb_key_dialog_message_key_installed);
            }
        } else if (buttonId == 0) {
            DBPPreferenceStore store = DBWorkbench.getPlatform().getPreferenceStore();
            if (!this.checkLicenseState()) {
                store.setValue("@dbeaver-prop-lb-lic@", "");
                if (CommonUtils.isNotEmpty((String)this.liquibaseKeyText.getText())) {
                    return;
                }
            } else {
                store.setValue("@dbeaver-prop-lb-lic@", this.liquibaseKeyText.getText());
            }
        }
        super.buttonPressed(buttonId);
    }
}

