/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudNode;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPHiddenObject;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudsRootNode
extends DBNNode
implements DBPHiddenObject {
    private static final Log log = Log.getLog(DBNCloudsRootNode.class);
    private DBNCloudNode[] clouds;

    DBNCloudsRootNode(DBNProject parentNode) {
        super((DBNNode)parentNode);
    }

    @NotNull
    public String getNodeType() {
        return "clouds";
    }

    @NotNull
    public String getNodeId() {
        return "clouds";
    }

    @NotNull
    public String getNodeDisplayName() {
        return "clouds";
    }

    @Nullable
    public String getNodeDescription() {
        return "Cloud explorer";
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return null;
    }

    protected boolean allowsChildren() {
        return true;
    }

    @Nullable
    public DBNCloudNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.clouds == null && !monitor.isForceCacheUsage()) {
            List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
            ArrayList<DBNCloudNode> cloudNodes = new ArrayList<DBNCloudNode>();
            for (CloudProviderDescriptor cpDescriptor : providers) {
                for (CPCloud<CPCloudZone, CPCloudSession<CPCloudZone>> cPCloud : cpDescriptor.getInstance().getAvailableClouds()) {
                    cloudNodes.add(new DBNCloudNode(this, cpDescriptor, cPCloud));
                }
            }
            this.clouds = cloudNodes.toArray(new DBNCloudNode[0]);
        }
        return this.clouds;
    }

    @Deprecated
    @NotNull
    public String getNodeItemPath() {
        return DBNNode.NodePathType.ext.getPrefix() + this.getNodeDisplayName();
    }

    @Nullable
    public DBNNode refreshNode(@NotNull DBRProgressMonitor monitor, @Nullable Object source) throws DBException {
        this.refreshCloudList();
        return this;
    }

    public void refreshCloudList() {
        if (this.clouds != null) {
            DBNCloudNode[] dBNCloudNodeArray = this.clouds;
            int n = this.clouds.length;
            int n2 = 0;
            while (n2 < n) {
                DBNCloudNode node = dBNCloudNodeArray[n2];
                DBNUtils.disposeNode((DBNNode)node, (boolean)true);
                ++n2;
            }
            this.clouds = null;
        }
    }

    @NotNull
    public String toString() {
        return this.getNodeDisplayName();
    }

    public boolean isHidden() {
        return true;
    }
}

