/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model;

import com.dbeaver.cloud.impl.AbstractCloud;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.model.navigator.DBNCloudDataSourceNode;
import com.dbeaver.cloud.model.services.CPDatabaseInstance;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CPCloudConfigurationRegistry;
import com.dbeaver.cloud.registry.CloudConfigSerializationStrategy;
import com.dbeaver.cloud.registry.CloudConfigurationProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import com.dbeaver.cloud.statistic.CloudFeature;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.Strictness;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceFolder;
import org.jkiss.dbeaver.model.DBPDataSourceOrigin;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.PropertySerializationUtils;
import org.jkiss.utils.CommonUtils;

public class CPCloudUtils {
    private static final Log log = Log.getLog(CPCloudUtils.class);
    public static final String PROP_PROFILE_ZONE = "cloud-network-profile-default-zone";
    public static final String PROP_PROFILE_AUTO_ASSIGN = "cloud-network-profile-auto-assign";

    @Nullable
    public static CPCloud<?, ?> getCloud(@NotNull String cloudId) throws DBException {
        return CPCloudUtils.getCloud(null, cloudId, null);
    }

    @Nullable
    public static CPCloud<?, ?> getCloud(@Nullable CloudProviderDescriptor provider, @NotNull String cloudId, @Nullable DBPExternalConfiguration externalConfiguration) throws DBException {
        CPCloudConfigurationProvider<?> configurationProvider;
        CPCloud<?, ?> cloud = null;
        if (provider == null) {
            List<CloudProviderDescriptor> providers = CloudProviderRegistry.getInstance().getCloudProviders();
            for (CloudProviderDescriptor cpDescriptor : providers) {
                cloud = CPCloudUtils.findCloudInProvider(cpDescriptor, cloudId);
                if (cloud == null) {
                    continue;
                }
                break;
            }
        } else {
            cloud = CPCloudUtils.findCloudInProvider(provider, cloudId);
        }
        if (cloud == null && provider != null && (configurationProvider = CloudProviderRegistry.getInstance().getConfigurationProvider(provider.getId())) != null) {
            if (externalConfiguration != null) {
                Object cloudConfiguration;
                if (!CommonUtils.equalObjects((Object)externalConfiguration.getId(), (Object)cloudId)) {
                    log.debug((Object)("ID in external configuration (" + externalConfiguration.getId() + ") doesn't match cloud ID (" + cloudId + ")"));
                }
                if ((cloudConfiguration = configurationProvider.importExternalCloudConfiguration(externalConfiguration)) != null) {
                    CPCloudConfigurationRegistry.getInstance().fireCloudConfigurationChange();
                }
            }
            cloud = CPCloudUtils.findCloudInProvider(provider, cloudId);
        }
        return cloud;
    }

    public static CPCloud<?, ?> findCloudInProvider(CloudProviderDescriptor provider, String cloudId) throws DBException {
        for (CPCloud<?, ?> cloud : provider.getInstance().getAvailableClouds()) {
            if (!cloud.getCloudId().equals(cloudId)) continue;
            return cloud;
        }
        return null;
    }

    @Nullable
    public static CPCloud<?, ?> getCloud(CloudProviderDescriptor provider, String cloudId) throws DBException {
        if (provider != null) {
            for (CPCloud<?, ?> cloud : provider.getInstance().getAvailableClouds()) {
                if (!cloud.getCloudId().equals(cloudId)) continue;
                return cloud;
            }
        }
        return null;
    }

    @Nullable
    public static <T extends CPCloudConfiguration<?>> T getCloudConfiguration(@NotNull String cloudId, @NotNull Class<T> configurationType) throws DBException {
        CPCloud<?, ?> cloud = CPCloudUtils.getCloud(null, cloudId, null);
        if (cloud != null) {
            return (T)((CPCloudConfiguration)configurationType.cast(cloud.getCloudConfiguration()));
        }
        return null;
    }

    @Nullable
    public static CPCloudZone findZone(CPCloud<?, ?> cloud, String zoneId) {
        CPCloudZone[] cPCloudZoneArray = cloud.getAllZones();
        int n = cPCloudZoneArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPCloudZone zone = cPCloudZoneArray[n2];
            if (zone.getZoneId().equals(zoneId)) {
                return zone;
            }
            ++n2;
        }
        return null;
    }

    @NotNull
    public static List<DBWNetworkProfile> getCloudTunnels(CPCloud<?, ?> cloud) {
        if (cloud instanceof AbstractCloud) {
            return ((AbstractCloud)cloud).getTunnelProfiles();
        }
        return Collections.emptyList();
    }

    @Nullable
    public static DBWNetworkProfile findCloudTunnel(CPCloud<?, ?> cloud, String profileName) {
        for (DBWNetworkProfile profile : CPCloudUtils.getCloudTunnels(cloud)) {
            if (!profile.getProfileId().equals(profileName)) continue;
            return profile;
        }
        return null;
    }

    @NotNull
    public static List<DBPDataSourceContainer> createDataSourcesFromCloudNodes(@NotNull DBPProject project, @Nullable DBPDataSourceFolder folder, @NotNull List<DBNCloudDataSourceNode> nodes) throws DBException {
        DBNModel navigatorModel = project.getNavigatorModel();
        if (navigatorModel == null) {
            throw new DBException("Navigator model is not found for project " + project.getName());
        }
        DBNProject projectNode = navigatorModel.getRoot().getProjectNode(project);
        if (projectNode == null) {
            throw new DBException("Project node '" + project.getName() + "' not found");
        }
        ArrayList<DBPDataSourceContainer> result = new ArrayList<DBPDataSourceContainer>();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        for (DBNCloudDataSourceNode dsNode : nodes) {
            DBPDataSourceContainer dataSourceContainer = dsNode.getDataSourceContainer();
            DBPDataSourceContainer newDataSource = CPCloudUtils.createDataSourceFromCloudTemplate(dataSourceRegistry, folder, dataSourceContainer, dsNode.getInstance());
            result.add(newDataSource);
        }
        return result;
    }

    @NotNull
    private static DBPDataSourceContainer createDataSourceFromCloudTemplate(@NotNull DBPDataSourceRegistry dataSourceRegistry, @Nullable DBPDataSourceFolder folder, @NotNull DBPDataSourceContainer dataSourceContainer, @Nullable CPDatabaseNode instance) throws DBException {
        DBPDataSourceContainer ds;
        if (instance == null) {
            throw new DBException("Cloud instance is missing");
        }
        CPCloudSession cloudSession = instance.getCloudSession();
        if (cloudSession == null) {
            throw new DBException("Cloud session is missing in instance");
        }
        DBPDataSourceContainer newDataSource = dataSourceRegistry.createDataSource(dataSourceContainer);
        if (folder != null) {
            newDataSource.setFolder(folder);
        }
        Object dsName = newDataSource.getName();
        int tryCount = 1;
        while ((ds = dataSourceRegistry.findDataSourceByName((String)dsName)) != null && !ds.isHidden()) {
            dsName = newDataSource.getName() + " (" + tryCount + ")";
            ++tryCount;
        }
        newDataSource.setName((String)dsName);
        for (DBWNetworkProfile profile : CPCloudUtils.getCloudTunnels(cloudSession.getCloud())) {
            CPCloudZone instanceZone;
            String cloudZone;
            if (!CommonUtils.toBoolean(profile.getProperties().get(PROP_PROFILE_AUTO_ASSIGN)) || !CommonUtils.isEmpty((String)(cloudZone = (String)profile.getProperties().get(PROP_PROFILE_ZONE))) && !(instanceZone = instance.getZone()).getZoneId().equals(cloudZone)) continue;
            newDataSource.getConnectionConfiguration().setConfigProfile(profile);
            break;
        }
        dataSourceRegistry.addDataSource(newDataSource);
        CloudFeature.CLOUD_CONNECTION_CREATE.use();
        return newDataSource;
    }

    public static DBPDataSourceContainer findOrCreateDataSourceByInstance(@NotNull DBRProgressMonitor monitor, @NotNull DBPProject project, @NotNull CPDatabaseInstance databaseInstance) throws DBException {
        String resourceId = databaseInstance.getCloudResourceId();
        DBPDataSourceRegistry dataSourceRegistry = project.getDataSourceRegistry();
        for (DBPDataSourceContainer ds : dataSourceRegistry.getDataSources()) {
            DataSourceOriginCloud cloudOrigin;
            DBPDataSourceOrigin dBPDataSourceOrigin;
            if (ds.isHidden() || !((dBPDataSourceOrigin = ds.getOrigin()) instanceof DataSourceOriginCloud) || !resourceId.equals((cloudOrigin = (DataSourceOriginCloud)dBPDataSourceOrigin).getResourceId())) continue;
            return ds;
        }
        DBPDataSourceContainer templateDataSource = dataSourceRegistry.getDataSource(resourceId);
        if (templateDataSource == null) {
            templateDataSource = databaseInstance.createDataSourceContainer(monitor, dataSourceRegistry);
        }
        return CPCloudUtils.createDataSourceFromCloudTemplate(dataSourceRegistry, null, templateDataSource, databaseInstance);
    }

    @NotNull
    public static Gson createSecureGson(boolean saveSecureProperties) {
        GsonBuilder builder = saveSecureProperties ? new GsonBuilder() : PropertySerializationUtils.baseNonSecurePropertiesGsonBuilder();
        builder.setPrettyPrinting().setStrictness(Strictness.LENIENT);
        builder.addSerializationExclusionStrategy((ExclusionStrategy)new CloudConfigSerializationStrategy());
        return builder.create();
    }

    @NotNull
    public static String generateCloudId(@NotNull CloudProviderDescriptor cloudProvider) throws DBException {
        return CPCloudUtils.generateCloudId(cloudProvider.getId(), cloudProvider.getInstance().getAvailableClouds().stream().map(CPCloud::getCloudId).collect(Collectors.toList()));
    }

    @NotNull
    public static String generateCloudId(@NotNull String providerId, @NotNull List<String> allClouds) {
        Object id;
        if (!(allClouds = allClouds.stream().filter(Objects::nonNull).map(String::toLowerCase).collect(Collectors.toList())).contains(id = providerId.toLowerCase(Locale.ROOT))) {
            return id;
        }
        int i = 1;
        while (allClouds.contains(id = providerId.toLowerCase(Locale.ROOT) + "_" + i)) {
            ++i;
        }
        return id;
    }

    public static CPCloudConfigurationProvider<?> getConfigurationProvider(Class<? extends CPCloudConfiguration> cloudConfig) {
        for (CloudConfigurationProviderDescriptor cp : CloudProviderRegistry.getInstance().getConfigurationProviders()) {
            try {
                CPCloudConfigurationProvider<?> cpInstance = cp.getInstance();
                if (cpInstance.getCloudConfigurationClass() != cloudConfig) continue;
                return cpInstance;
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return null;
    }

    @NotNull
    public static List<DBPDataSourceContainer> getCloudDataSources(@NotNull CPCloudConfiguration<?> configuration) {
        ArrayList<DBPDataSourceContainer> dsList = new ArrayList<DBPDataSourceContainer>();
        ArrayList allDataSources = new ArrayList();
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        for (DBPProject project : workspace.getProjects()) {
            if (!project.isOpen()) {
                project.ensureOpen();
            }
            allDataSources.addAll(project.getDataSourceRegistry().getDataSources());
        }
        for (DBPDataSourceContainer ds : allDataSources) {
            if (ds.isHidden() || !(ds.getOrigin() instanceof DataSourceOriginCloud) || !ds.getOrigin().getDisplayName().equals(configuration.getCloudId())) continue;
            dsList.add(ds);
        }
        if (dsList.isEmpty()) {
            for (DBPDataSourceContainer ds : allDataSources) {
                if (ds.isHidden() || !(ds.getOrigin() instanceof DataSourceOriginCloud) || !ds.getOrigin().getDisplayName().equals(configuration.getCloudName())) continue;
                dsList.add(ds);
            }
        }
        return dsList;
    }
}

