/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.impl;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.registry.CPCloudSessionProvider;
import com.dbeaver.model.DBPServiceApplication;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.app.DBPApplication;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCloudSessionProvider<CLOUD extends CPCloud<?, ?>, CREDENTIALS extends DBAAuthCredentials>
implements CPCloudSessionProvider<CLOUD, CREDENTIALS> {
    private static final Log log = Log.getLog(AbstractCloudSessionProvider.class);

    protected CREDENTIALS updateCredentialsFromService(@NotNull CLOUD cloud, @NotNull CREDENTIALS credentials) {
        DBPServiceApplication sa;
        String serviceAccountId;
        DBPApplication application = DBWorkbench.getPlatform().getApplication();
        if (application instanceof DBPServiceApplication && !CommonUtils.isEmpty((String)(serviceAccountId = (sa = (DBPServiceApplication)application).getDefaultServiceAccountId()))) {
            try {
                List<CPCloudServiceAccount> serviceAccounts = cloud.getCloudConfiguration().getServiceAccounts();
                for (CPCloudServiceAccount serviceAccount : serviceAccounts) {
                    if (!serviceAccount.getId().equals(serviceAccountId)) continue;
                    return this.updateCredentialsFromServiceAccount(cloud, serviceAccount, credentials);
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return credentials;
    }

    private CREDENTIALS updateCredentialsFromServiceAccount(@NotNull CLOUD cloud, @NotNull CPCloudServiceAccount serviceAccount, @NotNull CREDENTIALS credentials) {
        DBAAuthCredentials saCredentials = serviceAccount.getCredentials();
        if (saCredentials != null) {
            log.debug((Object)("Use Service Account '" + serviceAccount.getId() + "' credentials for cloud '" + cloud.getName() + "'"));
            return (CREDENTIALS)saCredentials;
        }
        return credentials;
    }
}

