/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.services.athena.model.QueryExecutionListCopier;
import software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId;
import software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetQueryExecutionResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, BatchGetQueryExecutionResponse> {
    private static final SdkField<List<QueryExecution>> QUERY_EXECUTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("QueryExecutions").getter(BatchGetQueryExecutionResponse.getter(BatchGetQueryExecutionResponse::queryExecutions)).setter(BatchGetQueryExecutionResponse.setter(Builder::queryExecutions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryExecutions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(QueryExecution::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<UnprocessedQueryExecutionId>> UNPROCESSED_QUERY_EXECUTION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedQueryExecutionIds").getter(BatchGetQueryExecutionResponse.getter(BatchGetQueryExecutionResponse::unprocessedQueryExecutionIds)).setter(BatchGetQueryExecutionResponse.setter(Builder::unprocessedQueryExecutionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedQueryExecutionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UnprocessedQueryExecutionId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_EXECUTIONS_FIELD, UNPROCESSED_QUERY_EXECUTION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetQueryExecutionResponse.memberNameToFieldInitializer();
    private final List<QueryExecution> queryExecutions;
    private final List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds;

    private BatchGetQueryExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecutions = builder.queryExecutions;
        this.unprocessedQueryExecutionIds = builder.unprocessedQueryExecutionIds;
    }

    public final boolean hasQueryExecutions() {
        return this.queryExecutions != null && !(this.queryExecutions instanceof SdkAutoConstructList);
    }

    public final List<QueryExecution> queryExecutions() {
        return this.queryExecutions;
    }

    public final boolean hasUnprocessedQueryExecutionIds() {
        return this.unprocessedQueryExecutionIds != null && !(this.unprocessedQueryExecutionIds instanceof SdkAutoConstructList);
    }

    public final List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds() {
        return this.unprocessedQueryExecutionIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryExecutions() ? this.queryExecutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedQueryExecutionIds() ? this.unprocessedQueryExecutionIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetQueryExecutionResponse)) {
            return false;
        }
        BatchGetQueryExecutionResponse other = (BatchGetQueryExecutionResponse)((Object)obj);
        return this.hasQueryExecutions() == other.hasQueryExecutions() && Objects.equals(this.queryExecutions(), other.queryExecutions()) && this.hasUnprocessedQueryExecutionIds() == other.hasUnprocessedQueryExecutionIds() && Objects.equals(this.unprocessedQueryExecutionIds(), other.unprocessedQueryExecutionIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetQueryExecutionResponse").add("QueryExecutions", this.hasQueryExecutions() ? this.queryExecutions() : null).add("UnprocessedQueryExecutionIds", this.hasUnprocessedQueryExecutionIds() ? this.unprocessedQueryExecutionIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutions": {
                return Optional.ofNullable(clazz.cast(this.queryExecutions()));
            }
            case "UnprocessedQueryExecutionIds": {
                return Optional.ofNullable(clazz.cast(this.unprocessedQueryExecutionIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("QueryExecutions", QUERY_EXECUTIONS_FIELD);
        map.put("UnprocessedQueryExecutionIds", UNPROCESSED_QUERY_EXECUTION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetQueryExecutionResponse, T> g) {
        return obj -> g.apply((BatchGetQueryExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<QueryExecution> queryExecutions = DefaultSdkAutoConstructList.getInstance();
        private List<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetQueryExecutionResponse model) {
            super(model);
            this.queryExecutions(model.queryExecutions);
            this.unprocessedQueryExecutionIds(model.unprocessedQueryExecutionIds);
        }

        public final List<QueryExecution.Builder> getQueryExecutions() {
            List<QueryExecution.Builder> result = QueryExecutionListCopier.copyToBuilder(this.queryExecutions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueryExecutions(Collection<QueryExecution.BuilderImpl> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copyFromBuilder(queryExecutions);
        }

        @Override
        public final Builder queryExecutions(Collection<QueryExecution> queryExecutions) {
            this.queryExecutions = QueryExecutionListCopier.copy(queryExecutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutions(QueryExecution ... queryExecutions) {
            this.queryExecutions(Arrays.asList(queryExecutions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutions(Consumer<QueryExecution.Builder> ... queryExecutions) {
            this.queryExecutions(Stream.of(queryExecutions).map(c -> (QueryExecution)((QueryExecution.Builder)QueryExecution.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<UnprocessedQueryExecutionId.Builder> getUnprocessedQueryExecutionIds() {
            List<UnprocessedQueryExecutionId.Builder> result = UnprocessedQueryExecutionIdListCopier.copyToBuilder(this.unprocessedQueryExecutionIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId.BuilderImpl> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier.copyFromBuilder(unprocessedQueryExecutionIds);
        }

        @Override
        public final Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds = UnprocessedQueryExecutionIdListCopier.copy(unprocessedQueryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId ... unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds(Arrays.asList(unprocessedQueryExecutionIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedQueryExecutionIds(Consumer<UnprocessedQueryExecutionId.Builder> ... unprocessedQueryExecutionIds) {
            this.unprocessedQueryExecutionIds(Stream.of(unprocessedQueryExecutionIds).map(c -> (UnprocessedQueryExecutionId)((UnprocessedQueryExecutionId.Builder)UnprocessedQueryExecutionId.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetQueryExecutionResponse build() {
            return new BatchGetQueryExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AthenaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetQueryExecutionResponse> {
        public Builder queryExecutions(Collection<QueryExecution> var1);

        public Builder queryExecutions(QueryExecution ... var1);

        public Builder queryExecutions(Consumer<QueryExecution.Builder> ... var1);

        public Builder unprocessedQueryExecutionIds(Collection<UnprocessedQueryExecutionId> var1);

        public Builder unprocessedQueryExecutionIds(UnprocessedQueryExecutionId ... var1);

        public Builder unprocessedQueryExecutionIds(Consumer<UnprocessedQueryExecutionId.Builder> ... var1);
    }
}

