/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.event.client;

import com.google.gson.Gson;
import jakarta.websocket.CloseReason;
import jakarta.websocket.Endpoint;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.MessageHandler;
import jakarta.websocket.Session;
import java.util.concurrent.CountDownLatch;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.websocket.WSUtils;
import org.jkiss.dbeaver.model.websocket.event.WSEvent;
import org.jkiss.dbeaver.model.websocket.event.WSEventController;
import org.jkiss.utils.CommonUtils;

public class WSClientEndpoint
extends Endpoint {
    private static final Log log = Log.getLog(WSClientEndpoint.class);
    private static final Gson gson = WSUtils.gson;
    private static final int FIVE_MINUTES = 300000;
    private final WSEventController eventController;
    private volatile CountDownLatch countDownLatch = new CountDownLatch(1);

    public WSClientEndpoint(WSEventController eventController) {
        this.eventController = eventController;
    }

    public void onClose(Session session, CloseReason closeReason) {
        log.debug((Object)("WebSocket closed: " + String.valueOf(closeReason.getCloseCode()) + " - " + closeReason.getReasonPhrase()));
        this.countDownLatch.countDown();
    }

    public void onOpen(Session session, EndpointConfig config) {
        this.countDownLatch = new CountDownLatch(1);
        session.setMaxIdleTimeout(300000L);
        session.addMessageHandler(String.class, (MessageHandler.Whole)new Handler());
        log.debug((Object)"WebSocket event controller has been connected");
    }

    public void onError(Session session, Throwable cause) {
        log.error((Object)cause.getMessage(), cause);
    }

    public void awaitClosure() throws InterruptedException {
        log.debug((Object)"Await websocket closure from remote");
        this.countDownLatch.await();
    }

    private class Handler
    implements MessageHandler.Whole<String> {
        private Handler() {
        }

        public void onMessage(String message) {
            if (CommonUtils.isEmpty((String)message)) {
                return;
            }
            WSEvent event = (WSEvent)gson.fromJson(message, WSEvent.class);
            if (event.getId() == null) {
                log.error((Object)("Invalid event without id: " + message));
            }
            WSClientEndpoint.this.eventController.addEvent(event);
        }
    }
}

